/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.grpc;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.Server;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.common.utils.StartAndShutdown;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.proxy.grpc.ProxyAndTlsProtocolNegotiator;
import org.apache.rocketmq.proxy.service.cert.TlsCertificateManager;

public class GrpcServer
implements StartAndShutdown {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    private final Server server;
    private final long timeout;
    private final TimeUnit unit;
    private final TlsCertificateManager tlsCertificateManager;
    @VisibleForTesting
    final GrpcTlsReloadHandler tlsReloadHandler;

    protected GrpcServer(Server server, long timeout, TimeUnit unit, TlsCertificateManager tlsCertificateManager) throws Exception {
        this.server = server;
        this.timeout = timeout;
        this.unit = unit;
        this.tlsCertificateManager = tlsCertificateManager;
        this.tlsReloadHandler = new GrpcTlsReloadHandler();
    }

    public void start() throws Exception {
        this.tlsCertificateManager.registerReloadListener(this.tlsReloadHandler);
        this.server.start();
        log.info("grpc server start successfully.");
    }

    public void shutdown() {
        try {
            this.tlsCertificateManager.unregisterReloadListener(this.tlsReloadHandler);
            this.server.shutdown().awaitTermination(this.timeout, this.unit);
            log.info("grpc server shutdown successfully.");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Failed to shutdown grpc server", (Throwable)e);
        }
    }

    @VisibleForTesting
    class GrpcTlsReloadHandler
    implements TlsCertificateManager.TlsContextReloadListener {
        GrpcTlsReloadHandler() {
        }

        @Override
        public void onTlsContextReload() {
            try {
                ProxyAndTlsProtocolNegotiator.loadSslContext();
                log.info("SslContext reloaded for grpc server");
            }
            catch (IOException | CertificateException e) {
                log.error("Failed to reload SslContext for server", (Throwable)e);
            }
        }
    }
}

