/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.scopes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.internal.scopes.IDefinitionStore;
import org.apache.royale.compiler.internal.scopes.SmallDefinitionStore8;
import org.apache.royale.compiler.internal.scopes.SmallDefinitionStoreBase;
import org.apache.royale.compiler.scopes.IDefinitionSet;

public final class LargeDefinitionStore
extends HashMap<String, IDefinitionSet>
implements IDefinitionStore {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public LargeDefinitionStore() {
    }

    public LargeDefinitionStore(SmallDefinitionStore8 store) {
        int n = store.getCapacity();
        for (int i = 0; i < n; ++i) {
            IDefinitionSet definitionSet = store.getDefinitionSet(i);
            if (definitionSet == null) continue;
            int m = definitionSet.getSize();
            for (int j = 0; j < m; ++j) {
                IDefinition definition = definitionSet.getDefinition(j);
                this.add(definition);
            }
        }
    }

    @Override
    public int getCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public IDefinitionStore createLargerStore() {
        return this;
    }

    @Override
    public boolean add(IDefinition definition) {
        String baseName = definition.getBaseName();
        IDefinitionSet oldDefinitionSet = (IDefinitionSet)this.get(baseName);
        IDefinitionSet newDefinitionSet = SmallDefinitionStoreBase.addDefinitionToSet(oldDefinitionSet, definition);
        if (newDefinitionSet != oldDefinitionSet) {
            this.put(baseName, newDefinitionSet);
        }
        return true;
    }

    @Override
    public boolean remove(IDefinition definition) {
        String baseName = definition.getBaseName();
        IDefinitionSet oldDefinitionSet = (IDefinitionSet)this.get(baseName);
        if (oldDefinitionSet == null) {
            return false;
        }
        if (SmallDefinitionStoreBase.removeDefinitionFromSet(oldDefinitionSet, definition)) {
            this.remove(baseName);
        }
        return true;
    }

    @Override
    public IDefinitionSet getDefinitionSetByName(String baseName) {
        return (IDefinitionSet)this.get(baseName);
    }

    @Override
    public void putDefinitionSetByName(String baseName, IDefinitionSet set) {
        this.put(baseName, set);
    }

    @Override
    public Collection<String> getAllNames() {
        return this.keySet();
    }

    @Override
    public Collection<IDefinitionSet> getAllDefinitionSets() {
        return this.values();
    }

    @Override
    public Collection<IDefinition> getAllDefinitions() {
        ArrayList<IDefinition> list = new ArrayList<IDefinition>();
        for (IDefinitionSet definitionSet : this.values()) {
            SmallDefinitionStoreBase.addDefinitionsToList(list, definitionSet);
        }
        return list;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        Object[] names = this.getAllNames().toArray(EMPTY_STRING_ARRAY);
        Arrays.sort(names);
        for (Object name : names) {
            sb.append((String)name);
            sb.append('\n');
            IDefinitionSet set = this.getDefinitionSetByName((String)name);
            int n = set.getSize();
            for (int i = 0; i < n; ++i) {
                IDefinition d = set.getDefinition(i);
                sb.append("  ");
                sb.append(d.toString());
                sb.append('\n');
            }
        }
        return sb.toString();
    }
}

