/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.abc.print;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.royale.abc.ABCConstants;
import org.apache.royale.abc.ABCParser;
import org.apache.royale.abc.PoolingABCVisitor;
import org.apache.royale.abc.graph.IBasicBlock;
import org.apache.royale.abc.graph.IFlowgraph;
import org.apache.royale.abc.semantics.ClassInfo;
import org.apache.royale.abc.semantics.ExceptionInfo;
import org.apache.royale.abc.semantics.InstanceInfo;
import org.apache.royale.abc.semantics.Instruction;
import org.apache.royale.abc.semantics.Label;
import org.apache.royale.abc.semantics.Metadata;
import org.apache.royale.abc.semantics.MethodBodyInfo;
import org.apache.royale.abc.semantics.MethodInfo;
import org.apache.royale.abc.semantics.Name;
import org.apache.royale.abc.semantics.Namespace;
import org.apache.royale.abc.semantics.Nsset;
import org.apache.royale.abc.semantics.ScriptInfo;
import org.apache.royale.abc.semantics.Trait;
import org.apache.royale.abc.semantics.Traits;

public class ABCDumpVisitor
extends PoolingABCVisitor {
    private boolean sortOption;
    private IndentingPrinter printer;
    private Set<MethodInfo> dumpedMethods;

    public ABCDumpVisitor(PrintWriter p, boolean sortOption) {
        this.printer = new IndentingPrinter(p, 0, 2);
        this.dumpedMethods = new HashSet<MethodInfo>();
        this.sortOption = sortOption;
    }

    private String qnameToString(Namespace ns, String n) {
        if (ns == null) {
            return n;
        }
        if (ns.getKind() == 22 && ns.getName().length() > 0) {
            return ns.getName() + "::" + n;
        }
        String qual = this.nsQualifierForNamespace(ns);
        if (qual.length() > 0) {
            return n;
        }
        if (ns.getName().length() == 0) {
            return n;
        }
        return ns.getName() + "::" + n;
    }

    private String nssetToString(Nsset nsSet) {
        Object s = "";
        for (Namespace ns : nsSet) {
            if (ns.getKind() != 5) {
                s = (String)s + ns.getName() + ", ";
                continue;
            }
            s = (String)s + "private, ";
        }
        return "{" + (String)s + "}";
    }

    private String nameToString(Name n) {
        if (n == null || n.couldBeAnyType()) {
            return "*";
        }
        switch (n.getKind()) {
            case 7: 
            case 13: {
                return this.qnameToString(n.getSingleQualifier(), n.getBaseName());
            }
            case 9: 
            case 14: {
                Nsset nsset = n.getQualifiers();
                if (nsset.length() == 1) {
                    return this.qnameToString(nsset.iterator().next(), n.getBaseName());
                }
                return this.nssetToString(nsset) + "::" + n.getBaseName();
            }
            case 15: 
            case 16: {
                return "<error> " + n.toString();
            }
            case 27: {
                return "<error> " + n.toString();
            }
            case 29: {
                Name typeName = n.getTypeNameParameter();
                return this.nameToString(n.getTypeNameBase()) + ".<" + this.nameToString(typeName) + ">";
            }
        }
        return "<error> " + n.toString();
    }

    private String nsQualifierForName(Name n) {
        switch (n.getKind()) {
            case 7: 
            case 13: {
                return this.nsQualifierForNamespace(n.getSingleQualifier());
            }
            case 9: 
            case 14: {
                Nsset nsset = n.getQualifiers();
                if (nsset.length() != 1) break;
                return this.nsQualifierForNamespace(nsset.iterator().next());
            }
            case 15: 
            case 16: {
                break;
            }
            case 27: {
                break;
            }
        }
        return "";
    }

    private String nsQualifierForNamespace(Namespace ns) {
        switch (ns.getKind()) {
            case 22: {
                return "public ";
            }
            case 24: 
            case 26: {
                return "protected ";
            }
            case 23: {
                return "internal ";
            }
            case 5: {
                return "private ";
            }
        }
        if (ns.getKind() == 8 && ns.getName().equals("http://adobe.com/AS3/2006/builtin")) {
            return "AS3 ";
        }
        return ns.getName() + " ";
    }

    private String stringToEscapedString(String s) {
        String charsToEscape = "\b\t\n\f\r\"'\\";
        String escapeChars = "btnfr\"'\\";
        Object result = "";
        for (int i = 0; i < s.length(); ++i) {
            char currChar = s.charAt(i);
            int escapeIndex = charsToEscape.indexOf(currChar);
            result = escapeIndex != -1 ? (String)result + "\\" + escapeChars.charAt(escapeIndex) : (String)result + currChar;
        }
        return result;
    }

    public void write() {
        this.traverse();
        this.writeIterable(this.getMethodInfos(), new IWriteFunction(){

            @Override
            public void write(Object v, int index) {
                ABCDumpVisitor.this.writeAnonMethodInfo((MethodInfo)v, index);
            }
        });
    }

    public void traverse() {
        int nScripts = this.getScriptInfos().size();
        if (this.sortOption) {
            ScriptInfo si;
            HashMap<String, ScriptInfo> scripts = new HashMap<String, ScriptInfo>();
            for (int i = 0; i < nScripts; ++i) {
                si = this.getScriptInfos().get(i);
                Iterator<Trait> traits = si.getTraits().iterator();
                Name name = traits.hasNext() ? traits.next().getName() : null;
                String scriptName = name != null ? name.getSingleQualifier().getName() + "." + name.getBaseName() : "";
                scripts.put(scriptName, si);
            }
            ArrayList nameList = new ArrayList();
            nameList.addAll(scripts.keySet());
            Collections.sort(nameList);
            for (int i = 0; i < nScripts; ++i) {
                si = (ScriptInfo)scripts.get(nameList.get(i));
                this.traverseScript(i, si);
            }
        } else {
            for (int i = 0; i < nScripts; ++i) {
                ScriptInfo si = this.getScriptInfos().get(i);
                this.traverseScript(i, si);
            }
        }
    }

    protected void traverseScript(int id, ScriptInfo scriptInfo) {
        this.printer.println("// script " + id);
        this.traverseScriptTraits(scriptInfo.getTraits(), scriptInfo);
        MethodInfo initMethodInfo = scriptInfo.getInit();
        this.traverseScriptInit(initMethodInfo, scriptInfo, id);
        this.printer.println("");
    }

    protected void traverseScriptTraits(Traits traits, ScriptInfo si) {
        for (Trait t : traits) {
            switch (t.getKind()) {
                case 6: {
                    this.traverseScriptConstTrait(t, si);
                    break;
                }
                case 0: {
                    this.traverseScriptSlotTrait(t, si);
                    break;
                }
                case 1: {
                    this.traverseScriptMethodTrait(t, si);
                    break;
                }
                case 2: {
                    this.traverseScriptGetterTrait(t, si);
                    break;
                }
                case 3: {
                    this.traverseScriptSetterTrait(t, si);
                    break;
                }
                case 5: {
                    this.traverseScriptFunctionTrait(t, si);
                    break;
                }
                case 4: {
                    this.traverseScriptClassTrait(t, si);
                }
            }
        }
    }

    protected void traverseInstanceTraits(Traits traits) {
        for (Trait t : traits) {
            switch (t.getKind()) {
                case 6: {
                    this.traverseInstanceConstTrait(t);
                    break;
                }
                case 0: {
                    this.traverseInstanceSlotTrait(t);
                    break;
                }
                case 1: {
                    this.traverseInstanceMethodTrait(t);
                    break;
                }
                case 2: {
                    this.traverseInstanceGetterTrait(t);
                    break;
                }
                case 3: {
                    this.traverseInstanceSetterTrait(t);
                    break;
                }
                case 5: {
                    this.traverseInstanceFunctionTrait(t);
                }
            }
        }
    }

    protected void traverseClassTraits(Traits traits) {
        for (Trait t : traits) {
            switch (t.getKind()) {
                case 6: {
                    this.traverseClassConstTrait(t);
                    break;
                }
                case 0: {
                    this.traverseClassSlotTrait(t);
                    break;
                }
                case 1: {
                    this.traverseClassMethodTrait(t);
                    break;
                }
                case 2: {
                    this.traverseClassGetterTrait(t);
                    break;
                }
                case 3: {
                    this.traverseClassSetterTrait(t);
                    break;
                }
                case 5: {
                    this.traverseClassFunctionTrait(t);
                }
            }
        }
    }

    protected void traverseScriptSlotTrait(Trait trait, ScriptInfo scriptInfo) {
        this.writeSlotTrait("var", trait, false);
    }

    protected void traverseScriptConstTrait(Trait trait, ScriptInfo scriptInfo) {
        this.writeSlotTrait("const", trait, false);
    }

    protected void traverseScriptMethodTrait(Trait trait, ScriptInfo scriptInfo) {
        this.writeMethodTrait("function", trait, false);
    }

    protected void traverseScriptGetterTrait(Trait trait, ScriptInfo scriptInfo) {
        this.writeMethodTrait("function get", trait, false);
    }

    protected void traverseScriptSetterTrait(Trait trait, ScriptInfo scriptInfo) {
        this.writeMethodTrait("function set", trait, false);
    }

    protected void traverseScriptFunctionTrait(Trait trait, ScriptInfo scriptInfo) {
        this.writeMethodTrait("function", trait, false);
    }

    protected void traverseScriptClassTrait(Trait trait, ScriptInfo scriptInfo) {
        ClassInfo ci = (ClassInfo)trait.getAttr("class_id");
        int classIndex = this.getClassId(ci);
        PoolingABCVisitor.ClassVisitor cv = this.getDefinedClasses().get(classIndex);
        InstanceInfo iinfo = cv.getInstanceInfo();
        this.traverseScriptClassTrait(classIndex, iinfo, ci, trait, scriptInfo);
    }

    protected void traverseScriptClassTrait(int classId, InstanceInfo instanceInfo, ClassInfo classInfo, Trait trait, ScriptInfo scriptInfo) {
        Object def;
        this.printer.println("");
        int slotId = 0;
        if (trait.hasAttr("slot_id")) {
            slotId = trait.getIntAttr("slot_id");
        }
        this.printer.println("// class_id=" + classId + " slot_id=" + String.valueOf(slotId));
        if (instanceInfo.isInterface()) {
            def = "interface";
        } else {
            def = "class";
            if (!instanceInfo.isSealed()) {
                def = "dynamic " + (String)def;
            }
            if (instanceInfo.isFinal()) {
                def = "final " + (String)def;
            }
        }
        this.writeMetaData(trait);
        this.printer.println(this.nsQualifierForName(trait.getName()) + (String)def + " " + this.nameToString(trait.getName()) + " extends " + this.nameToString(instanceInfo.superName));
        if (instanceInfo.interfaceNames.length > 0) {
            this.printer.indent();
            ArrayList<String> interfaceNames = new ArrayList<String>();
            for (Name interfaceName : instanceInfo.interfaceNames) {
                interfaceNames.add(this.nameToString(interfaceName));
            }
            this.printer.println(ABCDumpVisitor.joinOn(",", interfaceNames));
            this.printer.unindent();
        }
        this.printer.println("{");
        this.printer.indent();
        this.traverseInstanceInit(instanceInfo.iInit, instanceInfo, trait, scriptInfo);
        this.traverseInstanceTraits(instanceInfo.traits);
        this.traverseClassInit(classInfo.cInit, classInfo, trait, scriptInfo);
        this.traverseClassTraits(classInfo.classTraits);
        this.printer.unindent();
        this.printer.println("}");
    }

    protected void traverseScriptInit(MethodInfo init, ScriptInfo scriptInfo, int scriptId) {
        this.printer.println("");
        this.writeMethodInfo("", "script" + scriptId + "$init", "function", init, false, false, false);
    }

    protected void traverseInstanceInit(MethodInfo init, InstanceInfo instanceInfo, Trait classTrait, ScriptInfo scriptInfo) {
        this.printer.println("");
        this.printer.println("// method_id=" + this.getMethodInfos().getId(instanceInfo.iInit));
        this.writeMethodInfo("public ", this.nameToString(classTrait.getName()), "function", init, false, false, false);
    }

    protected void traverseInstanceSlotTrait(Trait trait) {
        this.writeSlotTrait("var", trait, false);
    }

    protected void traverseInstanceConstTrait(Trait trait) {
        this.writeSlotTrait("const", trait, false);
    }

    protected void traverseInstanceMethodTrait(Trait trait) {
        this.writeMethodTrait("function", trait, false);
    }

    protected void traverseInstanceGetterTrait(Trait trait) {
        this.writeMethodTrait("function get", trait, false);
    }

    protected void traverseInstanceSetterTrait(Trait trait) {
        this.writeMethodTrait("function set", trait, false);
    }

    protected void traverseInstanceFunctionTrait(Trait trait) {
        this.writeMethodTrait("function", trait, false);
    }

    protected void traverseClassInit(MethodInfo init, ClassInfo classInfo, Trait classTrait, ScriptInfo scriptInfo) {
        this.printer.println("");
        this.writeMethodInfo("public ", this.nameToString(classTrait.getName()) + "$", "function", init, true, false, false);
    }

    protected void traverseClassSlotTrait(Trait trait) {
        this.writeSlotTrait("var", trait, true);
    }

    protected void traverseClassConstTrait(Trait trait) {
        this.writeSlotTrait("const", trait, true);
    }

    protected void traverseClassMethodTrait(Trait trait) {
        this.writeMethodTrait("function", trait, true);
    }

    protected void traverseClassGetterTrait(Trait trait) {
        this.writeMethodTrait("function get", trait, true);
    }

    protected void traverseClassSetterTrait(Trait trait) {
        this.writeMethodTrait("function set", trait, true);
    }

    protected void traverseClassFunctionTrait(Trait trait) {
        this.writeMethodTrait("function", trait, true);
    }

    private void writeMetaData(Trait t) {
        if (!t.hasMetadata()) {
            return;
        }
        for (Metadata mid : t.getMetadata()) {
            Vector<CallSite> entries = new Vector<CallSite>();
            String[] keys = mid.getKeys();
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                String value = mid.getValues()[i];
                if (key == null || key.length() == 0) {
                    entries.add((CallSite)((Object)("\"" + value + "\"")));
                    continue;
                }
                entries.add((CallSite)((Object)(key + "=\"" + value + "\"")));
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < entries.size(); ++i) {
                sb.append((String)entries.get(i));
                if (i >= entries.size() - 1) continue;
                sb.append(", ");
            }
            if (this.sortOption && mid.getName().contains("_definition_help")) {
                this.printer.println("[" + mid.getName() + "(xxxx)]");
                continue;
            }
            this.printer.println("[" + mid.getName() + "(" + sb.toString() + ")]");
        }
    }

    private void writeAnonMethodInfo(MethodInfo mi, int id) {
        if (this.dumpedMethods.contains(mi)) {
            return;
        }
        this.printer.println("");
        this.printer.println("// " + id + " " + mi.getMethodName());
        this.writeMethodInfo("", "", "function ", mi, false, false, false);
    }

    private void writeSlotTrait(String kindStr, Trait t, boolean isStatic) {
        this.printer.println("");
        String qual = this.nsQualifierForName(t.getName());
        String nameStr = this.nameToString(t.getName());
        Object value = null;
        if (t.hasAttr("value")) {
            value = t.getAttr("value");
        }
        Object valueStr = "";
        if (value instanceof String) {
            valueStr = " = \"" + value + "\"";
        } else if (value instanceof Namespace) {
            valueStr = " = " + ((Namespace)value).getName();
        } else if (value == ABCConstants.NULL_VALUE) {
            valueStr = " = null";
        } else if (value == ABCConstants.UNDEFINED_VALUE) {
            valueStr = "";
        } else if (value != null) {
            valueStr = " = " + value.toString();
        }
        String staticStr = isStatic ? "static " : "";
        this.writeMetaData(t);
        this.printer.println(qual + staticStr + kindStr + " " + nameStr + ":" + this.nameToString((Name)t.getAttr("type")) + (String)valueStr);
    }

    private String stringForLookupSwitch(Instruction inst, MethodBodyInfo mb, Map<IBasicBlock, String> blockNames, IFlowgraph cfg) {
        int case_size = inst.getOperandCount() - 1;
        String defaultStr = "default: " + blockNames.get(cfg.getBlock((Label)inst.getOperand(case_size)));
        String maxCaseStr = "maxcase: " + case_size;
        Vector<Object> result = new Vector<Object>();
        result.add(defaultStr);
        result.add(maxCaseStr);
        for (int i = 0; i < case_size; ++i) {
            result.add(blockNames.get(cfg.getBlock((Label)inst.getOperand(i))));
        }
        return ABCDumpVisitor.joinOn(" ", result);
    }

    private void writeMethodInfo(String qualStr, String nameStr, String kindStr, MethodInfo methodInfo, boolean isStatic, boolean isOverride, boolean isFinal) {
        this.dumpedMethods.add(methodInfo);
        Vector<String> paramTypeStrings = new Vector<String>();
        for (Name paramTypeName : methodInfo.getParamTypes()) {
            paramTypeStrings.add(this.nameToString(paramTypeName));
        }
        String staticStr = isStatic ? "static " : "";
        String overrideStr = isOverride ? "override " : "";
        String nativeStr = methodInfo.isNative() ? "native " : "";
        String finalStr = isFinal ? "final " : "";
        this.printer.println(qualStr + staticStr + nativeStr + finalStr + overrideStr + kindStr + " " + nameStr + "(" + ABCDumpVisitor.joinOn(",", paramTypeStrings) + "):" + this.nameToString(methodInfo.getReturnType()));
        MethodBodyInfo mb = this.getMethodBodyForMethodInfo(methodInfo);
        if (mb != null) {
            this.printer.println("{");
            this.printer.indent();
            TablePrinter tablePrinter = new TablePrinter(3, 2);
            tablePrinter.addRow(new String[]{"//", "derivedName", methodInfo.getMethodName()});
            tablePrinter.addRow(new String[]{"//", "method_info", String.valueOf(this.getMethodInfos().getId(mb.getMethodInfo()))});
            tablePrinter.addRow(new String[]{"//", "max_stack", String.valueOf(mb.max_stack)});
            tablePrinter.addRow(new String[]{"//", "max_regs", String.valueOf(mb.max_local)});
            tablePrinter.addRow(new String[]{"//", "scope_depth", String.valueOf(mb.initial_scope)});
            tablePrinter.addRow(new String[]{"//", "max_scope", String.valueOf(mb.max_scope)});
            tablePrinter.addRow(new String[]{"//", "code_length", String.valueOf(mb.code_len)});
            tablePrinter.print(this.printer);
            if (mb.getTraits() != null && mb.getTraits().getTraitCount() > 0) {
                this.printer.println("activation_traits {");
                this.printer.indent();
                for (Trait trait : mb.getTraits()) {
                    switch (trait.getKind()) {
                        case 0: {
                            kindStr = "var";
                            break;
                        }
                        case 6: {
                            kindStr = "const";
                            break;
                        }
                        default: {
                            throw new Error("Illegal activation trait in " + methodInfo.getMethodName());
                        }
                    }
                    this.writeSlotTrait(kindStr, trait, false);
                }
                this.printer.unindent();
                this.printer.println("}");
            }
            IFlowgraph cfg = mb.getCfg();
            HashMap<IBasicBlock, String> blockNames = new HashMap<IBasicBlock, String>();
            int i = 0;
            for (IBasicBlock iBasicBlock : cfg.getBlocksInEntryOrder()) {
                blockNames.put(iBasicBlock, "bb" + i++);
            }
            int offset = 0;
            for (IBasicBlock block : cfg.getBlocksInEntryOrder()) {
                this.printer.println((String)blockNames.get(block));
                this.printer.indent();
                Collection<? extends IBasicBlock> succs = block.getSuccessors();
                ArrayList<String> succNames = new ArrayList<String>();
                for (IBasicBlock iBasicBlock : succs) {
                    succNames.add((String)blockNames.get(iBasicBlock));
                }
                if (!this.sortOption) {
                    this.printer.println("succs=[" + ABCDumpVisitor.joinOn(",", succNames) + "]");
                }
                tablePrinter = new TablePrinter(4, 2);
                for (int j = 0; j < block.size(); ++j) {
                    Instruction instruction = block.get(j);
                    Object constantStr = "";
                    if (instruction.hasOperands() && instruction.getOperand(0) instanceof Name) {
                        constantStr = this.nameToString((Name)instruction.getOperand(0));
                    } else if (instruction.isBranch() && instruction.getOpcode() != 27) {
                        constantStr = (String)blockNames.get(cfg.getBlock((Label)instruction.getOperand(0)));
                    } else {
                        switch (instruction.getOpcode()) {
                            case 241: {
                                if (this.sortOption) {
                                    String fileName = (String)instruction.getOperand(0);
                                    fileName = fileName.substring(fileName.indexOf(";"));
                                    fileName = fileName.replace("\\", "/");
                                    constantStr = "\"" + this.stringToEscapedString(fileName) + "\"";
                                    break;
                                }
                                constantStr = "\"" + this.stringToEscapedString((String)instruction.getOperand(0)) + "\"";
                                break;
                            }
                            case 44: {
                                constantStr = "\"" + this.stringToEscapedString((String)instruction.getOperand(0)) + "\"";
                                break;
                            }
                            case 27: {
                                constantStr = this.stringForLookupSwitch(instruction, mb, blockNames, cfg);
                            }
                        }
                    }
                    tablePrinter.addRow(new String[]{offset + "    ", Instruction.decodeOp(instruction.getOpcode()), constantStr, instruction.isImmediate() ? String.valueOf(instruction.getImmediate()) : ""});
                    ++offset;
                }
                tablePrinter.print(this.printer);
                this.printer.unindent();
            }
            this.printer.unindent();
            this.printer.println("}");
            if (mb.getExceptions().size() > 0) {
                tablePrinter = new TablePrinter(7, 2);
                tablePrinter.addRow(new String[]{"//", "exception", "start", "end", "target", "type string", "name string"});
                for (i = 0; i < mb.getExceptions().size(); ++i) {
                    ExceptionInfo exceptionInfo = mb.getExceptions().get(i);
                    tablePrinter.addRow(new String[]{"//", String.valueOf(i), String.valueOf(exceptionInfo.getFrom().getPosition()), String.valueOf(exceptionInfo.getTo().getPosition()), String.valueOf(exceptionInfo.getTarget().getPosition()), this.nameToString(exceptionInfo.getExceptionType()), this.nameToString(exceptionInfo.getCatchVar())});
                }
                tablePrinter.print(this.printer);
                this.printer.println("");
            }
        }
    }

    private void writeMethodTrait(String kindStr, Trait t, boolean isStatic) {
        String qual = this.nsQualifierForName(t.getName());
        String nameStr = this.nameToString(t.getName());
        MethodInfo methodInfo = (MethodInfo)t.getAttr("method_id");
        this.printer.println("");
        this.writeMetaData(t);
        this.writeMethodInfo(qual, nameStr, kindStr, methodInfo, isStatic, t.getBooleanAttr("override"), t.getBooleanAttr("final"));
    }

    private <T> void writeIterable(Iterable<T> p, IWriteFunction writefunc) {
        int i = 0;
        for (T v : p) {
            writefunc.write(v, i++);
        }
    }

    public static void main(String[] args) throws Exception {
        for (String arg : args) {
            File f = new File(arg);
            if (!f.exists()) continue;
            ABCParser parser = new ABCParser(new BufferedInputStream(new FileInputStream(f)));
            ABCDumpVisitor printer = new ABCDumpVisitor(new PrintWriter(System.out), false);
            parser.parseABC(printer);
        }
    }

    @Override
    public void visitEnd() {
        this.write();
        this.printer.flush();
    }

    private static String joinOn(String separator, Collection<? extends Object> items) {
        StringBuilder result = new StringBuilder();
        for (Object object : items) {
            if (result.length() > 0) {
                result.append(separator);
            }
            result.append(object);
        }
        return result.toString();
    }

    private static class IndentingPrinter {
        private PrintWriter delegate;
        private String currentIndent;
        private int indentIncrement;

        public IndentingPrinter(PrintWriter delegate, int initialIndent, int indentIncrement) {
            this.delegate = delegate;
            this.currentIndent = IndentingPrinter.makeIndentStr(initialIndent);
            this.indentIncrement = indentIncrement;
        }

        private static String makeIndentStr(int indent) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < indent; ++i) {
                sb.append(" ");
            }
            String result = sb.toString();
            return result;
        }

        public void println(String s) {
            if (((String)s).length() > 0) {
                s = this.currentIndent + (String)s;
            }
            this.delegate.println((String)s);
        }

        public void indent() {
            int newIndent = this.currentIndent.length() + this.indentIncrement;
            this.currentIndent = IndentingPrinter.makeIndentStr(newIndent);
        }

        public void unindent() {
            int newIndent = this.currentIndent.length() - this.indentIncrement;
            this.currentIndent = IndentingPrinter.makeIndentStr(newIndent);
        }

        public void flush() {
            this.delegate.flush();
        }
    }

    static interface IWriteFunction {
        public void write(Object var1, int var2);
    }

    public static class TablePrinter {
        private int cols;
        private int minPadding;
        private Vector<Row> m_rows;

        public TablePrinter(int nCols, int minPadding) {
            this.cols = nCols;
            this.minPadding = minPadding;
            this.m_rows = new Vector();
        }

        public void addRow(String[] r) {
            if (r.length != this.cols) {
                throw new Error("Invalid row");
            }
            this.m_rows.add(new Row(r));
        }

        public void print(IndentingPrinter p) {
            int[] colWidths = new int[this.cols];
            for (int i = 0; i < this.cols; ++i) {
                colWidths[i] = 0;
            }
            for (Row r : this.m_rows) {
                r.measure(colWidths, this.minPadding);
            }
            for (Row r : this.m_rows) {
                r.print(p, colWidths);
            }
        }

        private class Row {
            private String[] cells;

            public Row(String[] cells) {
                this.cells = cells;
            }

            public void measure(int[] colWidths, int minPadding) {
                for (int i = 0; i < this.cells.length; ++i) {
                    colWidths[i] = Math.max(colWidths[i], this.getRowItemStr(i).length() + minPadding);
                }
            }

            public void print(IndentingPrinter p, int[] colWidths) {
                Object rowStr = "";
                for (int i = 0; i < this.cells.length; ++i) {
                    rowStr = (String)rowStr + this.padString(this.getRowItemStr(i), colWidths[i]);
                }
                p.println((String)rowStr);
            }

            private String getRowItemStr(int i) {
                if (this.cells[i] == null) {
                    return "null";
                }
                if (i < this.cells.length) {
                    return this.cells[i];
                }
                return "error - out of range " + i;
            }

            private String padString(String s, int minLength) {
                while (((String)s).length() < minLength) {
                    s = (String)s + " ";
                }
                return s;
            }
        }
    }
}

