/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.tools.annotate;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.royale.compiler.tools.annotate.AnnotateClass;

public class OrderSwitches {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processFile(File file) throws AnnotateClass.AnnotateClassDeleteException, AnnotateClass.AnnotateClassRenameException {
        if (!file.exists()) {
            System.out.println("Missing file: " + file.getPath());
            return;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            File tmpOutputFile = new File(file.getParentFile(), file.getName() + ".tmp");
            FileOutputStream fileOutputStream = new FileOutputStream(tmpOutputFile);
            PrintStream outputStream = new PrintStream(fileOutputStream);
            try {
                String line;
                ArrayList<String> lines = new ArrayList<String>();
                boolean inSwitch = false;
                while ((line = bufferedReader.readLine()) != null) {
                    int c;
                    if (line.contains("The following code was generated by JFlex ") && (c = line.indexOf(" on ")) != -1) {
                        line = line.substring(0, c) + " */";
                    }
                    if (line.contains("* on ") && line.contains("from the specification file")) {
                        line = " * from the specification file";
                    }
                    if (line.contains("<tt>") && line.contains("compiler/src/main/jflex")) {
                        int t = line.indexOf("<tt>");
                        int rc = line.indexOf("compiler/src/main/jflex");
                        line = line.substring(0, t + 4) + line.substring(rc);
                    }
                    if (line.contains("      switch (zzAction")) {
                        inSwitch = true;
                        System.out.println("Ordering Switch in file: " + file.getPath());
                    }
                    if (inSwitch) {
                        lines.add(line);
                        if (!line.startsWith("      }")) continue;
                        OrderSwitches.orderSwitch(lines);
                        for (String orderedLine : lines) {
                            outputStream.println(orderedLine);
                        }
                        inSwitch = false;
                        continue;
                    }
                    outputStream.println(line);
                }
            }
            finally {
                try {
                    bufferedReader.close();
                }
                catch (Exception line) {}
                try {
                    outputStream.close();
                }
                catch (Exception line) {}
                try {
                    fileOutputStream.close();
                }
                catch (Exception line) {}
                try {
                    inputStreamReader.close();
                }
                catch (Exception line) {}
                try {
                    fileInputStream.close();
                }
                catch (Exception line) {}
            }
            if (!file.delete() && file.exists()) {
                for (int i = 0; i < 6; ++i) {
                    Thread.sleep(500L);
                    System.gc();
                    if (file.delete()) break;
                }
                if (file.exists()) {
                    throw new AnnotateClass.AnnotateClassDeleteException("Error deleting original file at: " + file.getPath());
                }
            }
            if (!tmpOutputFile.renameTo(file)) {
                throw new AnnotateClass.AnnotateClassRenameException("Error renaming the temp file from: " + tmpOutputFile.getPath() + " to: " + file.getPath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void orderSwitch(ArrayList<String> lines) {
        HashMap switchMap = new HashMap();
        ArrayList<String> defaultCase = new ArrayList<String>();
        ArrayList<String> breaks = new ArrayList<String>();
        String line0 = lines.get(0);
        boolean inDefault = false;
        int n = lines.size();
        block0: for (int i = 1; i < n; ++i) {
            String line = lines.get(i);
            int c = line.indexOf(" case ");
            if (!inDefault && c != -1) {
                String cayse = line.substring(c);
                if (line.contains("break;")) {
                    breaks.add(line);
                    continue;
                }
                ArrayList<String> caseLines = new ArrayList<String>();
                for (int j = i + 1; j < n; ++j) {
                    line = lines.get(j);
                    if (line.contains(" case ")) {
                        switchMap.put(cayse, caseLines);
                        i = j - 1;
                        continue block0;
                    }
                    if (line.contains("default:")) {
                        switchMap.put(cayse, caseLines);
                        inDefault = true;
                        i = j;
                        defaultCase.add(line);
                        continue block0;
                    }
                    caseLines.add(line);
                }
                continue;
            }
            if (line.contains("default:")) {
                inDefault = true;
                defaultCase.add(line);
                continue;
            }
            if (!inDefault) continue;
            defaultCase.add(line);
        }
        Set keys = switchMap.keySet();
        ArrayList keyList = new ArrayList();
        keyList.addAll(keys);
        Collections.sort(keyList);
        lines.clear();
        lines.add(line0);
        int breakIndex = 0;
        for (String key : keyList) {
            lines.add("       " + key);
            List caseLines = (List)switchMap.get(key);
            lines.addAll(caseLines);
            lines.add((String)breaks.get(breakIndex++));
        }
        boolean inSwitch = false;
        boolean sawDefault = false;
        ArrayList<String> switchLines = new ArrayList<String>();
        for (String defaultLine : defaultCase) {
            if (defaultLine.contains("switch (zzLexicalState)")) {
                inSwitch = true;
                System.out.println("Ordering Switch in default: ");
            }
            if (inSwitch) {
                switchLines.add(defaultLine);
                if (defaultLine.contains("default:")) {
                    sawDefault = true;
                }
                if (!sawDefault || !defaultLine.startsWith("            }")) continue;
                OrderSwitches.orderSwitch(switchLines);
                for (String orderedLine : switchLines) {
                    lines.add(orderedLine);
                }
                inSwitch = false;
                continue;
            }
            lines.add(defaultLine);
        }
    }

    public static void main(String[] args) {
        File f = new File(args[0]);
        try {
            OrderSwitches.processFile(f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

