/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry;

import com.netflix.config.DynamicPropertyFactory;
import java.util.Collection;
import org.apache.servicecomb.foundation.common.concurrency.SuppressedRunnableWrapper;
import org.apache.servicecomb.registry.api.Registration;
import org.apache.servicecomb.registry.api.registry.BasePath;
import org.apache.servicecomb.registry.api.registry.Microservice;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstanceStatus;
import org.apache.servicecomb.serviceregistry.RegistryUtils;

public class ServiceCenterRegistration
implements Registration {
    public static final String NAME = "service center registration";

    public void init() {
        RegistryUtils.init();
    }

    public void run() {
        RegistryUtils.run();
    }

    public void destroy() {
        RegistryUtils.destroy();
    }

    public int getOrder() {
        return 100;
    }

    public String name() {
        return NAME;
    }

    public MicroserviceInstance getMicroserviceInstance() {
        return RegistryUtils.getMicroserviceInstance();
    }

    public Microservice getMicroservice() {
        return RegistryUtils.getMicroservice();
    }

    public String getAppId() {
        return RegistryUtils.getAppId();
    }

    public boolean updateMicroserviceInstanceStatus(MicroserviceInstanceStatus status) {
        RegistryUtils.executeOnEachServiceRegistry(sr -> new SuppressedRunnableWrapper(() -> {
            MicroserviceInstance selfInstance = sr.getMicroserviceInstance();
            sr.getServiceRegistryClient().updateMicroserviceInstanceStatus(selfInstance.getServiceId(), selfInstance.getInstanceId(), status);
        }).run());
        return true;
    }

    public void addSchema(String schemaId, String content) {
        RegistryUtils.executeOnEachServiceRegistry(sr -> sr.getMicroservice().addSchema(schemaId, content));
    }

    public void addEndpoint(String endpoint) {
        RegistryUtils.executeOnEachServiceRegistry(sr -> {
            Microservice microservice = sr.getMicroservice();
            microservice.getInstance().getEndpoints().add(endpoint);
        });
    }

    public void addBasePath(Collection<BasePath> basePaths) {
        RegistryUtils.executeOnEachServiceRegistry(sr -> sr.getMicroservice().getPaths().addAll(basePaths));
    }

    public boolean enabled() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.service.registry.enabled", true).get();
    }
}

