/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.runtime;

import io.protostuff.runtime.FieldMapEx;
import io.protostuff.runtime.FieldSchema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ArrayFieldMapEx<T>
implements FieldMapEx<T> {
    private final List<FieldSchema<T>> fields;
    private final FieldSchema<T>[] fieldsByNumber;
    private final Map<String, FieldSchema<T>> fieldsByName = new HashMap<String, FieldSchema<T>>();

    public ArrayFieldMapEx(Collection<FieldSchema<T>> fields, int lastFieldNumber) {
        this.fieldsByNumber = new FieldSchema[lastFieldNumber + 1];
        for (FieldSchema<T> f : fields) {
            FieldSchema<T> last = this.fieldsByName.put(f.name, f);
            if (last != null) {
                throw new IllegalStateException(last + " and " + f + " cannot have the same name.");
            }
            if (this.fieldsByNumber[f.getFieldNumber()] != null) {
                throw new IllegalStateException(this.fieldsByNumber[f.getFieldNumber()] + " and " + f + " cannot have the same number.");
            }
            this.fieldsByNumber[f.getFieldNumber()] = f;
        }
        ArrayList<FieldSchema<T>> fieldList = new ArrayList<FieldSchema<T>>(fields.size());
        for (FieldSchema<T> field : this.fieldsByNumber) {
            if (field == null) continue;
            fieldList.add(field);
        }
        this.fields = Collections.unmodifiableList(fieldList);
    }

    @Override
    public FieldSchema<T> getFieldByNumber(int n) {
        return n < this.fieldsByNumber.length ? this.fieldsByNumber[n] : null;
    }

    @Override
    public FieldSchema<T> getFieldByName(String fieldName) {
        return this.fieldsByName.get(fieldName);
    }

    @Override
    public int getFieldCount() {
        return this.fields.size();
    }

    @Override
    public List<FieldSchema<T>> getFields() {
        return this.fields;
    }
}

