/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core;

import io.swagger.annotations.ApiOperation;
import io.swagger.models.Info;
import io.swagger.models.Swagger;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.config.inject.PlaceholderResolver;
import org.apache.servicecomb.swagger.generator.ClassAnnotationProcessor;
import org.apache.servicecomb.swagger.generator.OperationGenerator;
import org.apache.servicecomb.swagger.generator.SwaggerGenerator;
import org.apache.servicecomb.swagger.generator.SwaggerGeneratorUtils;
import org.apache.servicecomb.swagger.generator.core.AbstractOperationGenerator;
import org.apache.servicecomb.swagger.generator.core.utils.MethodUtils;

public abstract class AbstractSwaggerGenerator
implements SwaggerGenerator {
    protected Class<?> cls;
    protected Swagger swagger;
    protected Set<String> methodWhiteList = new HashSet<String>();
    protected Map<String, AbstractOperationGenerator> operationGenerators = new LinkedHashMap<String, AbstractOperationGenerator>();
    protected Set<String> defaultTags = new LinkedHashSet<String>();
    protected String httpMethod;

    public AbstractSwaggerGenerator(Class<?> cls) {
        this.swagger = new Swagger();
        this.cls = cls;
    }

    @Override
    public Swagger getSwagger() {
        return this.swagger;
    }

    @Override
    public Class<?> getClazz() {
        return this.cls;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod.toLowerCase(Locale.US);
    }

    @Override
    public Swagger generate() {
        LOGGER.info("generate schema from [{}]", this.cls);
        this.scanClassAnnotation();
        this.scanMethods();
        this.addOperationsToSwagger();
        this.correctSwagger();
        return this.swagger;
    }

    @Override
    public void scanClassAnnotation() {
        for (Annotation annotation : this.cls.getAnnotations()) {
            ClassAnnotationProcessor<Annotation> processor = SwaggerGeneratorUtils.findClassAnnotationProcessor(annotation.annotationType());
            if (processor == null) continue;
            processor.process(this, annotation);
        }
    }

    protected void correctSwagger() {
        if (StringUtils.isEmpty((CharSequence)this.swagger.getSwagger())) {
            this.swagger.setSwagger("2.0");
        }
        this.correctBasePath();
        this.correctInfo();
        this.correctProduces();
        this.correctConsumes();
    }

    private void correctProduces() {
        List<String> produces = this.swagger.getProduces();
        if (produces == null || produces.isEmpty()) {
            produces = Arrays.asList("application/json");
            this.swagger.setProduces(produces);
        }
    }

    private void correctConsumes() {
        List<String> consumes = this.swagger.getConsumes();
        if (consumes == null || consumes.isEmpty()) {
            consumes = Arrays.asList("application/json");
            this.swagger.setConsumes(consumes);
        }
    }

    protected void correctBasePath() {
        Object basePath = this.swagger.getBasePath();
        if (StringUtils.isEmpty((CharSequence)basePath)) {
            basePath = "/" + this.cls.getSimpleName();
        }
        if (!((String)basePath).startsWith("/")) {
            basePath = "/" + (String)basePath;
        }
        this.swagger.setBasePath((String)basePath);
    }

    private void correctInfo() {
        Info info = this.swagger.getInfo();
        if (info == null) {
            info = new Info();
            this.swagger.setInfo(info);
        }
        if (StringUtils.isEmpty((CharSequence)info.getTitle())) {
            info.setTitle("swagger definition for " + this.cls.getName());
        }
        if (StringUtils.isEmpty((CharSequence)info.getVersion())) {
            info.setVersion("1.0.0");
        }
        this.setJavaInterface(info);
    }

    protected void setJavaInterface(Info info) {
        if (this.cls.isInterface()) {
            info.setVendorExtension("x-java-interface", (Object)this.cls.getName());
        }
    }

    @Override
    public void replaceMethodWhiteList(String ... methodNames) {
        this.methodWhiteList.clear();
        if (methodNames == null || methodNames.length == 0) {
            return;
        }
        this.methodWhiteList.addAll(Arrays.asList(methodNames));
    }

    protected boolean isSkipMethod(Method method) {
        if (method.getDeclaringClass().getName().equals(Object.class.getName())) {
            return true;
        }
        int modifiers = method.getModifiers();
        if (Modifier.isStatic(modifiers)) {
            return true;
        }
        if (method.isBridge()) {
            return true;
        }
        ApiOperation apiOperation = method.getAnnotation(ApiOperation.class);
        if (apiOperation != null && apiOperation.hidden()) {
            return apiOperation.hidden();
        }
        if (!this.methodWhiteList.isEmpty()) {
            return !this.methodWhiteList.contains(MethodUtils.findSwaggerMethodName(method));
        }
        return false;
    }

    protected void scanMethods() {
        List<Method> methods = MethodUtils.findSwaggerMethods(this.cls);
        for (Method method : methods) {
            if (this.isSkipMethod(method)) continue;
            AbstractOperationGenerator operationGenerator = (AbstractOperationGenerator)this.createOperationGenerator(method);
            operationGenerator.setHttpMethod(this.httpMethod);
            try {
                operationGenerator.generate();
            }
            catch (Throwable e) {
                String msg = String.format("generate swagger operation failed, method=%s:%s.", this.cls.getName(), method.getName());
                throw new IllegalStateException(msg, e);
            }
            if (StringUtils.isEmpty((CharSequence)operationGenerator.httpMethod)) {
                throw new IllegalStateException(String.format("HttpMethod must not both be empty in class and method, method=%s:%s.", this.cls.getName(), method.getName()));
            }
            if (this.operationGenerators.putIfAbsent(operationGenerator.getOperationId(), operationGenerator) == null) continue;
            throw new IllegalStateException(String.format("OperationId must be unique. method=%s:%s.", this.cls.getName(), method.getName()));
        }
    }

    protected void addOperationsToSwagger() {
        for (OperationGenerator operationGenerator : this.operationGenerators.values()) {
            operationGenerator.addOperationToSwagger();
        }
    }

    @Override
    public void setBasePath(String basePath) {
        basePath = new PlaceholderResolver().replaceFirst(basePath);
        this.swagger.setBasePath(basePath);
    }

    @Override
    public void addDefaultTag(String tagName) {
        if (StringUtils.isEmpty((CharSequence)tagName)) {
            return;
        }
        this.defaultTags.add(tagName);
    }

    public Set<String> getDefaultTags() {
        return this.defaultTags;
    }
}

