/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.context.internal.classloader;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.osgi.context.internal.classloader.ChainedClassLoader;
import org.springframework.osgi.context.internal.classloader.InternalAopClassLoaderFactory;

class CachingAopClassLoaderFactory
implements InternalAopClassLoaderFactory {
    private static final String CGLIB_CLASS = "net.sf.cglib.proxy.Enhancer";
    private final Class cglibClass;
    private final Map cache = new WeakHashMap();

    CachingAopClassLoaderFactory() {
        ClassLoader springAopClassLoader = ProxyFactory.class.getClassLoader();
        Class<?> clazz = null;
        try {
            clazz = springAopClassLoader.loadClass(CGLIB_CLASS);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.cglibClass = clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChainedClassLoader createClassLoader(ClassLoader classLoader) {
        Map map2 = this.cache;
        synchronized (map2) {
            ChainedClassLoader aopClassLoader = null;
            WeakReference loaderReference = (WeakReference)this.cache.get(classLoader);
            if (loaderReference != null) {
                aopClassLoader = (ChainedClassLoader)loaderReference.get();
            }
            if (aopClassLoader == null) {
                aopClassLoader = this.cglibClass != null ? new ChainedClassLoader(new ClassLoader[]{classLoader, ProxyFactory.class.getClassLoader(), this.cglibClass.getClassLoader(), CachingAopClassLoaderFactory.class.getClassLoader()}) : new ChainedClassLoader(new ClassLoader[]{classLoader, ProxyFactory.class.getClassLoader(), CachingAopClassLoaderFactory.class.getClassLoader()});
                this.cache.put(classLoader, new WeakReference<ChainedClassLoader>(aopClassLoader));
            }
            return aopClassLoader;
        }
    }
}

