/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import javax.measure.Quantity;
import javax.measure.quantity.Length;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.filter.ArithmeticFunction;
import org.apache.sis.filter.BinarySpatialFilter;
import org.apache.sis.filter.ComparisonFilter;
import org.apache.sis.filter.DistanceFilter;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Filter;
import org.apache.sis.filter.FunctionRegister;
import org.apache.sis.filter.IdentifierFilter;
import org.apache.sis.filter.LeafExpression;
import org.apache.sis.filter.LikeFilter;
import org.apache.sis.filter.LogicalFilter;
import org.apache.sis.filter.PropertyValue;
import org.apache.sis.filter.TemporalFilter;
import org.apache.sis.filter.TemporalOperation;
import org.apache.sis.filter.UnaryFunction;
import org.apache.sis.filter.sqlmm.Registry;
import org.apache.sis.geometry.WraparoundMethod;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.pending.geoapi.filter.DistanceOperatorName;
import org.apache.sis.pending.geoapi.filter.MatchAction;
import org.apache.sis.pending.geoapi.filter.SpatialOperatorName;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.iso.AbstractFactory;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.Envelope;

public abstract class DefaultFilterFactory<R, G, T>
extends AbstractFactory {
    private final Geometries<G> library;
    private final Class<T> temporal;
    private final WraparoundMethod wraparound;
    private final Map<String, FunctionRegister> availableFunctions;

    protected DefaultFilterFactory(Class<G> spatial, Class<T> temporal, WraparoundMethod wraparound) {
        ArgumentChecks.ensureNonNull((String)"spatial", spatial);
        ArgumentChecks.ensureNonNull((String)"temporal", temporal);
        ArgumentChecks.ensureNonNull((String)"wraparound", (Object)wraparound);
        if (spatial == Object.class) {
            this.library = Geometries.factory((GeometryLibrary)null);
        } else {
            this.library = Geometries.factory(spatial);
            if (this.library == null || this.library.rootClass != spatial) {
                throw new IllegalArgumentException(Errors.format((short)59, (Object)"spatial", spatial));
            }
        }
        this.temporal = temporal;
        this.wraparound = wraparound;
        this.availableFunctions = new HashMap<String, FunctionRegister>();
    }

    public static DefaultFilterFactory<AbstractFeature, Object, Object> forFeatures() {
        return Features.DEFAULT;
    }

    public static <R> Optional<DefaultFilterFactory<R, Object, Object>> forResources(Class<R> type) {
        if (type.equals(AbstractFeature.class)) {
            return Optional.of(DefaultFilterFactory.forFeatures());
        }
        return Optional.empty();
    }

    public abstract Filter<R> resourceId(String var1);

    public Expression<R, ?> property(String xpath) {
        return this.property(xpath, Object.class);
    }

    public abstract <V> Expression<R, V> property(String var1, Class<V> var2);

    public <V> Expression<R, V> literal(V value) {
        return new LeafExpression.Literal(value);
    }

    public Filter<R> equal(Expression<R, ?> expression1, Expression<R, ?> expression2) {
        return new ComparisonFilter.EqualTo<R>(expression1, expression2, true, MatchAction.ANY);
    }

    public Filter<R> notEqual(Expression<R, ?> expression1, Expression<R, ?> expression2) {
        return new ComparisonFilter.NotEqualTo<R>(expression1, expression2, true, MatchAction.ANY);
    }

    public Filter<R> less(Expression<R, ?> expression1, Expression<R, ?> expression2) {
        return new ComparisonFilter.LessThan<R>(expression1, expression2, true, MatchAction.ANY);
    }

    public Filter<R> greater(Expression<R, ?> expression1, Expression<R, ?> expression2) {
        return new ComparisonFilter.GreaterThan<R>(expression1, expression2, true, MatchAction.ANY);
    }

    public Filter<R> lessOrEqual(Expression<R, ?> expression1, Expression<R, ?> expression2) {
        return new ComparisonFilter.LessThanOrEqualTo<R>(expression1, expression2, true, MatchAction.ANY);
    }

    public Filter<R> greaterOrEqual(Expression<R, ?> expression1, Expression<R, ?> expression2) {
        return new ComparisonFilter.GreaterThanOrEqualTo<R>(expression1, expression2, true, MatchAction.ANY);
    }

    public Filter<R> between(Expression<R, ?> expression, Expression<R, ?> lowerBoundary, Expression<R, ?> upperBoundary) {
        return new ComparisonFilter.Between<R>(expression, lowerBoundary, upperBoundary);
    }

    public Filter<R> like(Expression<R, ?> expression, String pattern) {
        return this.like(expression, pattern, '%', '_', '\\', true);
    }

    public Filter<R> like(Expression<R, ?> expression, String pattern, char wildcard, char singleChar, char escape, boolean isMatchingCase) {
        return new LikeFilter<R>(expression, pattern, wildcard, singleChar, escape, isMatchingCase);
    }

    public Filter<R> isNull(Expression<R, ?> expression) {
        return new UnaryFunction.IsNull<R>(expression);
    }

    public Filter<R> isNil(Expression<R, ?> expression, String nilReason) {
        return new UnaryFunction.IsNil<R>(expression, nilReason);
    }

    public Filter<R> and(Filter<R> operand1, Filter<R> operand2) {
        ArgumentChecks.ensureNonNull((String)"operand1", operand1);
        ArgumentChecks.ensureNonNull((String)"operand2", operand2);
        return new LogicalFilter.And<R>(operand1, operand2);
    }

    public Filter<R> and(Collection<? extends Filter<R>> operands) {
        return new LogicalFilter.And(operands);
    }

    public Filter<R> or(Filter<R> operand1, Filter<R> operand2) {
        ArgumentChecks.ensureNonNull((String)"operand1", operand1);
        ArgumentChecks.ensureNonNull((String)"operand2", operand2);
        return new LogicalFilter.Or<R>(operand1, operand2);
    }

    public Filter<R> or(Collection<? extends Filter<R>> operands) {
        return new LogicalFilter.Or(operands);
    }

    public Filter<R> not(Filter<R> operand) {
        return new LogicalFilter.Not<R>(operand);
    }

    public Filter<R> bbox(Expression<R, ? extends G> geometry, Envelope bounds) {
        return new BinarySpatialFilter<R>(this.library, geometry, bounds, this.wraparound);
    }

    public Filter<R> equals(Expression<R, ? extends G> geometry1, Expression<R, ? extends G> geometry2) {
        return new BinarySpatialFilter<R>(SpatialOperatorName.EQUALS, this.library, geometry1, geometry2);
    }

    public Filter<R> disjoint(Expression<R, ? extends G> geometry1, Expression<R, ? extends G> geometry2) {
        return new BinarySpatialFilter<R>(SpatialOperatorName.DISJOINT, this.library, geometry1, geometry2);
    }

    public Filter<R> intersects(Expression<R, ? extends G> geometry1, Expression<R, ? extends G> geometry2) {
        return new BinarySpatialFilter<R>(SpatialOperatorName.INTERSECTS, this.library, geometry1, geometry2);
    }

    public Filter<R> touches(Expression<R, ? extends G> geometry1, Expression<R, ? extends G> geometry2) {
        return new BinarySpatialFilter<R>(SpatialOperatorName.TOUCHES, this.library, geometry1, geometry2);
    }

    public Filter<R> crosses(Expression<R, ? extends G> geometry1, Expression<R, ? extends G> geometry2) {
        return new BinarySpatialFilter<R>(SpatialOperatorName.CROSSES, this.library, geometry1, geometry2);
    }

    public Filter<R> within(Expression<R, ? extends G> geometry1, Expression<R, ? extends G> geometry2) {
        return new BinarySpatialFilter<R>(SpatialOperatorName.WITHIN, this.library, geometry1, geometry2);
    }

    public Filter<R> contains(Expression<R, ? extends G> geometry1, Expression<R, ? extends G> geometry2) {
        return new BinarySpatialFilter<R>(SpatialOperatorName.CONTAINS, this.library, geometry1, geometry2);
    }

    public Filter<R> overlaps(Expression<R, ? extends G> geometry1, Expression<R, ? extends G> geometry2) {
        return new BinarySpatialFilter<R>(SpatialOperatorName.OVERLAPS, this.library, geometry1, geometry2);
    }

    public Filter<R> beyond(Expression<R, ? extends G> geometry1, Expression<R, ? extends G> geometry2, Quantity<Length> distance) {
        return new DistanceFilter<R>(DistanceOperatorName.BEYOND, this.library, geometry1, geometry2, distance);
    }

    public Filter<R> within(Expression<R, ? extends G> geometry1, Expression<R, ? extends G> geometry2, Quantity<Length> distance) {
        return new DistanceFilter<R>(DistanceOperatorName.WITHIN, this.library, geometry1, geometry2, distance);
    }

    public Filter<R> after(Expression<R, ? extends T> time1, Expression<R, ? extends T> time2) {
        return TemporalFilter.create(this.temporal, TemporalOperation.After::new, time1, time2);
    }

    public Filter<R> before(Expression<R, ? extends T> time1, Expression<R, ? extends T> time2) {
        return TemporalFilter.create(this.temporal, TemporalOperation.Before::new, time1, time2);
    }

    public Filter<R> begins(Expression<R, ? extends T> time1, Expression<R, ? extends T> time2) {
        return TemporalFilter.create(this.temporal, TemporalOperation.Begins::new, time1, time2);
    }

    public Filter<R> begunBy(Expression<R, ? extends T> time1, Expression<R, ? extends T> time2) {
        return TemporalFilter.create(this.temporal, TemporalOperation.BegunBy::new, time1, time2);
    }

    public Filter<R> tcontains(Expression<R, ? extends T> time1, Expression<R, ? extends T> time2) {
        return TemporalFilter.create(this.temporal, TemporalOperation.Contains::new, time1, time2);
    }

    public Filter<R> during(Expression<R, ? extends T> time1, Expression<R, ? extends T> time2) {
        return TemporalFilter.create(this.temporal, TemporalOperation.During::new, time1, time2);
    }

    public Filter<R> tequals(Expression<R, ? extends T> time1, Expression<R, ? extends T> time2) {
        return TemporalFilter.create(this.temporal, TemporalOperation.Equals::new, time1, time2);
    }

    public Filter<R> toverlaps(Expression<R, ? extends T> time1, Expression<R, ? extends T> time2) {
        return TemporalFilter.create(this.temporal, TemporalOperation.Overlaps::new, time1, time2);
    }

    public Filter<R> meets(Expression<R, ? extends T> time1, Expression<R, ? extends T> time2) {
        return TemporalFilter.create(this.temporal, TemporalOperation.Meets::new, time1, time2);
    }

    public Filter<R> ends(Expression<R, ? extends T> time1, Expression<R, ? extends T> time2) {
        return TemporalFilter.create(this.temporal, TemporalOperation.Ends::new, time1, time2);
    }

    public Filter<R> overlappedBy(Expression<R, ? extends T> time1, Expression<R, ? extends T> time2) {
        return TemporalFilter.create(this.temporal, TemporalOperation.OverlappedBy::new, time1, time2);
    }

    public Filter<R> metBy(Expression<R, ? extends T> time1, Expression<R, ? extends T> time2) {
        return TemporalFilter.create(this.temporal, TemporalOperation.MetBy::new, time1, time2);
    }

    public Filter<R> endedBy(Expression<R, ? extends T> time1, Expression<R, ? extends T> time2) {
        return TemporalFilter.create(this.temporal, TemporalOperation.EndedBy::new, time1, time2);
    }

    public Filter<R> anyInteracts(Expression<R, ? extends T> time1, Expression<R, ? extends T> time2) {
        return TemporalFilter.create(this.temporal, TemporalOperation.AnyInteracts::new, time1, time2);
    }

    public Expression<R, Number> add(Expression<R, ? extends Number> operand1, Expression<R, ? extends Number> operand2) {
        return new ArithmeticFunction.Add<R>(operand1, operand2);
    }

    public Expression<R, Number> subtract(Expression<R, ? extends Number> operand1, Expression<R, ? extends Number> operand2) {
        return new ArithmeticFunction.Subtract<R>(operand1, operand2);
    }

    public Expression<R, Number> multiply(Expression<R, ? extends Number> operand1, Expression<R, ? extends Number> operand2) {
        return new ArithmeticFunction.Multiply<R>(operand1, operand2);
    }

    public Expression<R, Number> divide(Expression<R, ? extends Number> operand1, Expression<R, ? extends Number> operand2) {
        return new ArithmeticFunction.Divide<R>(operand1, operand2);
    }

    public Expression<R, ?> function(String name, Expression<? super R, ?> parameter) {
        return this.function(name, new Expression[]{parameter});
    }

    public Expression<R, ?> function(String name, Expression<? super R, ?> param1, Expression<? super R, ?> param2) {
        return this.function(name, new Expression[]{param1, param2});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FunctionRegister register(String name) {
        FunctionRegister register;
        Map<String, FunctionRegister> map = this.availableFunctions;
        synchronized (map) {
            if (this.availableFunctions.isEmpty()) {
                Registry r = new Registry(this.library);
                for (String fn : r.getNames()) {
                    this.availableFunctions.put(fn, r);
                }
                for (FunctionRegister er : ServiceLoader.load(FunctionRegister.class)) {
                    for (String fn : er.getNames()) {
                        this.availableFunctions.putIfAbsent(fn, er);
                    }
                }
            }
            register = this.availableFunctions.get(name);
        }
        return register;
    }

    public Expression<R, ?> function(String name, Expression<R, ?>[] parameters) {
        ArgumentChecks.ensureNonNull((String)"name", (Object)name);
        ArgumentChecks.ensureNonNull((String)"parameters", parameters);
        parameters = (Expression[])parameters.clone();
        for (int i = 0; i < parameters.length; ++i) {
            ArgumentChecks.ensureNonNullElement((String)"parameters", (int)i, parameters[i]);
        }
        FunctionRegister register = this.register(name);
        if (register == null) {
            throw new IllegalArgumentException(Resources.format((short)70, name));
        }
        return register.create(name, parameters);
    }

    public static class Features<G, T>
    extends DefaultFilterFactory<AbstractFeature, G, T> {
        static final DefaultFilterFactory<AbstractFeature, Object, Object> DEFAULT = new Features<Object, Object>(Object.class, Object.class, WraparoundMethod.SPLIT);

        public Features(Class<G> spatial, Class<T> temporal, WraparoundMethod wraparound) {
            super(spatial, temporal, wraparound);
        }

        @Override
        public Filter<AbstractFeature> resourceId(String identifier) {
            return new IdentifierFilter(identifier);
        }

        @Override
        public <V> Expression<AbstractFeature, V> property(String xpath, Class<V> type) {
            ArgumentChecks.ensureNonEmpty((String)"xpath", (CharSequence)xpath);
            ArgumentChecks.ensureNonNull((String)"type", type);
            return PropertyValue.create(xpath, type);
        }
    }
}

