/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter.sqlmm;

import java.util.Collection;
import java.util.EnumMap;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.feature.internal.shared.FeatureExpression;
import org.apache.sis.feature.internal.shared.FeatureProjectionBuilder;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Optimization;
import org.apache.sis.filter.base.Node;
import org.apache.sis.filter.sqlmm.SQLMM;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.iso.Names;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.GenericName;
import org.opengis.util.LocalName;
import org.opengis.util.ScopedName;

abstract class SpatialFunction<R>
extends Node
implements FeatureExpression<R, Object>,
Optimization.OnExpression<R, Object> {
    private static final long serialVersionUID = 6933519274722660893L;
    private static final LocalName SCOPE = Names.createLocalName((CharSequence)"ISO", null, (CharSequence)"sqlmm");
    final SQLMM operation;
    private static final EnumMap<SQLMM, ScopedName> NAMES = new EnumMap(SQLMM.class);

    SpatialFunction(SQLMM operation, Expression<R, ?>[] parameters) {
        this.operation = operation;
        ArgumentChecks.ensureCountBetween((String)"parameters", (boolean)false, (int)operation.minParamCount, (int)operation.maxParamCount, (int)parameters.length);
    }

    abstract Geometries<?> getGeometryLibrary();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ScopedName getFunctionName() {
        EnumMap<SQLMM, ScopedName> enumMap = NAMES;
        synchronized (enumMap) {
            return NAMES.computeIfAbsent(this.operation, SpatialFunction::createName);
        }
    }

    private static ScopedName createName(SQLMM operation) {
        return Names.createScopedName((GenericName)SCOPE, null, (CharSequence)operation.name());
    }

    @Override
    protected final Collection<?> getChildren() {
        return this.getParameters();
    }

    public String getSyntax() {
        byte minParamCount = this.operation.minParamCount;
        int maxParamCount = this.operation.maxParamCount;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFunctionName().tip()).append('(');
        for (int i = 0; i < maxParamCount; ++i) {
            if (i == minParamCount) {
                sb.append('[');
            }
            if (i != 0) {
                sb.append(", ");
            }
            sb.append("param").append(i + 1);
        }
        if (maxParamCount > minParamCount) {
            sb.append(']');
        }
        return sb.append(')').toString();
    }

    @Override
    public final Class<?> getResultClass() {
        return this.operation.getReturnType(this.getGeometryLibrary());
    }

    @Override
    public final <N> Expression<R, N> toValueType(Class<N> target) {
        if (target.isAssignableFrom(this.getResultClass())) {
            return this;
        }
        throw new ClassCastException(Errors.format((short)12, (Object)this.getFunctionName(), target));
    }

    @Override
    public FeatureProjectionBuilder.Item expectedType(FeatureProjectionBuilder addTo) {
        if (this.operation.isGeometryInOut()) {
            FeatureExpression fex = FeatureExpression.castOrCopy(this.getParameters().get(0));
            if (fex != null) {
                boolean accept;
                FeatureProjectionBuilder.Item item = addTo.addTemplateProperty(fex);
                boolean bl = accept = item == null || item.replaceValueClass(c -> {
                    Geometries<?> library = Geometries.factory(c);
                    return library == null ? null : this.operation.getReturnType(library);
                });
                if (accept) {
                    return item;
                }
            }
            throw new IllegalArgumentException(Resources.format((short)52));
        }
        return addTo.addComputedProperty(addTo.addAttribute(this.getResultClass()).setName((GenericName)this.getFunctionName()), false);
    }
}

