/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.gps;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public enum Fix {
    NONE("none"),
    TWO_DIMENSIONAL("2d"),
    THREE_DIMENSIONAL("3d"),
    DIFFERENTIAL("dgps"),
    PRECISE("pps");

    private final String gpx;
    private static final Map<String, Fix> VALUES;

    private Fix(String gpx) {
        this.gpx = gpx;
    }

    public static Fix fromGPX(String name) {
        if (name == null) {
            return null;
        }
        return VALUES.get(name.toLowerCase(Locale.US));
    }

    public String toGPX() {
        return this.gpx;
    }

    static {
        VALUES = new HashMap<String, Fix>(6);
        for (Fix fix : Fix.values()) {
            VALUES.put(fix.gpx, fix);
        }
    }
}

