/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.resource.observation;

import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ConsumerType;

@ConsumerType
public class ResourceChange {
    private final String path;
    private final ChangeType changeType;
    private final boolean isExternal;
    private final Set<String> addedPropertyNames;
    private final Set<String> changedPropertyNames;
    private final Set<String> removedPropertyNames;

    public ResourceChange(@NotNull ChangeType changeType, @NotNull String path, boolean isExternal) {
        this.path = path;
        this.changeType = changeType;
        this.isExternal = isExternal;
        this.addedPropertyNames = null;
        this.changedPropertyNames = null;
        this.removedPropertyNames = null;
    }

    @Deprecated
    public ResourceChange(@NotNull ChangeType changeType, @NotNull String path, boolean isExternal, Set<String> addedPropertyNames, Set<String> changedPropertyNames, Set<String> removedPropertyNames) {
        this.path = path;
        this.changeType = changeType;
        this.isExternal = isExternal;
        this.addedPropertyNames = addedPropertyNames;
        this.changedPropertyNames = changedPropertyNames;
        this.removedPropertyNames = removedPropertyNames;
    }

    @NotNull
    public String getPath() {
        return this.path;
    }

    @Nullable
    public String getUserId() {
        return null;
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    @NotNull
    public ChangeType getType() {
        return this.changeType;
    }

    @Deprecated
    @Nullable
    public Set<String> getChangedPropertyNames() {
        return this.changedPropertyNames;
    }

    @Deprecated
    @Nullable
    public Set<String> getAddedPropertyNames() {
        return this.addedPropertyNames;
    }

    @Deprecated
    @Nullable
    public Set<String> getRemovedPropertyNames() {
        return this.removedPropertyNames;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ResourceChange[type=").append((Object)this.getType()).append(", path=").append(this.getPath()).append(", external=").append(this.isExternal).append("]");
        return b.toString();
    }

    public static enum ChangeType {
        ADDED,
        REMOVED,
        CHANGED,
        PROVIDER_ADDED,
        PROVIDER_REMOVED;

    }
}

