/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.DateFormat;
import java.text.NumberFormat;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataSourceProvider;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRCsvDataSource;

public class JRCsvDataSourceProvider
implements JRDataSourceProvider {
    public static final String EXCEPTION_MESSAGE_KEY_CANNOT_FIND_SOURCE = "data.csv.cannot.find.source";
    private Reader reader;
    private DateFormat dateFormat;
    private char fieldDelimiter;
    private String recordDelimiter;
    private String[] columnNames;
    private NumberFormat numberFormat;

    public JRCsvDataSourceProvider(InputStream stream) {
        this(new InputStreamReader(stream));
    }

    public JRCsvDataSourceProvider(File file) throws FileNotFoundException {
        this(new FileReader(file));
    }

    public JRCsvDataSourceProvider(Reader reader) {
        this.reader = reader;
    }

    @Override
    public boolean supportsGetFieldsOperation() {
        return false;
    }

    @Override
    public JRField[] getFields(JasperReport report) throws JRException, UnsupportedOperationException {
        return null;
    }

    @Override
    public JRDataSource create(JasperReport report) throws JRException {
        if (this.reader == null) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_CANNOT_FIND_SOURCE, (Object[])null);
        }
        JRCsvDataSource ds = new JRCsvDataSource(this.reader);
        ds.setDateFormat(this.dateFormat);
        ds.setNumberFormat(this.numberFormat);
        ds.setFieldDelimiter(this.fieldDelimiter);
        ds.setRecordDelimiter(this.recordDelimiter);
        ds.setColumnNames(this.columnNames);
        return ds;
    }

    @Override
    public void dispose(JRDataSource dataSource) throws JRException {
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String[] colNames) {
        if (colNames == null) {
            this.columnNames = null;
        } else {
            this.columnNames = new String[colNames.length];
            System.arraycopy(colNames, 0, this.columnNames, 0, colNames.length);
        }
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public char getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public void setFieldDelimiter(char fieldDelimiter) {
        this.fieldDelimiter = fieldDelimiter;
    }

    public String getRecordDelimiter() {
        return this.recordDelimiter;
    }

    public void setRecordDelimiter(String recordDelimiter) {
        this.recordDelimiter = recordDelimiter;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }
}

