/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class AdditionalEntryMap<K, V>
extends AbstractMap<K, V> {
    private Map<K, V> decorated;
    private K additionalKey;
    private V additionalValue;
    private AdditionalEntrySet entrySet;
    private AdditionalKeySet keySet;
    private AdditionalValueCollection valueCollection;

    public AdditionalEntryMap(Map<K, V> decorated, K additionalKey, V additionalValue) {
        if (decorated == null || additionalKey == null || additionalValue == null) {
            throw new IllegalArgumentException("The arguments cannot be null");
        }
        if (decorated.containsKey(additionalKey)) {
            throw new IllegalArgumentException("The additional key should not be present in the map");
        }
        this.decorated = decorated;
        this.additionalKey = additionalKey;
        this.additionalValue = additionalValue;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        AdditionalEntrySet set = this.entrySet;
        if (set == null) {
            set = this.entrySet = new AdditionalEntrySet();
        }
        return set;
    }

    @Override
    public int size() {
        return this.decorated.size() + 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.decorated.containsValue(value) || this.additionalValue.equals(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.decorated.containsKey(key) || this.additionalKey.equals(key);
    }

    @Override
    public V get(Object key) {
        if (this.additionalKey.equals(key)) {
            return this.additionalValue;
        }
        return this.decorated.get(key);
    }

    @Override
    public Set<K> keySet() {
        AdditionalKeySet set = this.keySet;
        if (set == null) {
            set = this.keySet = new AdditionalKeySet();
        }
        return set;
    }

    @Override
    public Collection<V> values() {
        AdditionalValueCollection collection = this.valueCollection;
        if (collection == null) {
            collection = this.valueCollection = new AdditionalValueCollection();
        }
        return collection;
    }

    protected class AdditionalEntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private Set<Map.Entry<K, V>> decoratedSet;

        protected AdditionalEntrySet() {
            this.decoratedSet = AdditionalEntryMap.this.decorated.entrySet();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            Iterator decoratedIterator = this.decoratedSet.iterator();
            AbstractMap.SimpleImmutableEntry<Object, Object> additionalEntry = new AbstractMap.SimpleImmutableEntry<Object, Object>(AdditionalEntryMap.this.additionalKey, AdditionalEntryMap.this.additionalValue);
            return new AdditionalIterator(decoratedIterator, additionalEntry);
        }

        @Override
        public int size() {
            return this.decoratedSet.size() + 1;
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (this.decoratedSet.contains(o)) {
                return true;
            }
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            Object value = entry.getValue();
            return AdditionalEntryMap.this.additionalKey.equals(key) && AdditionalEntryMap.this.additionalValue.equals(value);
        }
    }

    protected class AdditionalKeySet
    extends AbstractSet<K> {
        private Set<K> decoratedSet;

        protected AdditionalKeySet() {
            this.decoratedSet = AdditionalEntryMap.this.decorated.keySet();
        }

        @Override
        public Iterator<K> iterator() {
            Iterator decoratedIterator = this.decoratedSet.iterator();
            return new AdditionalIterator<Object>(decoratedIterator, AdditionalEntryMap.this.additionalKey);
        }

        @Override
        public int size() {
            return this.decoratedSet.size() + 1;
        }

        @Override
        public boolean contains(Object o) {
            if (this.decoratedSet.contains(o)) {
                return true;
            }
            return AdditionalEntryMap.this.additionalKey.equals(o);
        }
    }

    protected class AdditionalValueCollection
    extends AbstractCollection<V> {
        private Collection<V> decoratedCollection;

        protected AdditionalValueCollection() {
            this.decoratedCollection = AdditionalEntryMap.this.decorated.values();
        }

        @Override
        public Iterator<V> iterator() {
            Iterator decoratedIterator = this.decoratedCollection.iterator();
            return new AdditionalIterator<Object>(decoratedIterator, AdditionalEntryMap.this.additionalValue);
        }

        @Override
        public int size() {
            return this.decoratedCollection.size() + 1;
        }

        @Override
        public boolean contains(Object o) {
            if (this.decoratedCollection.contains(o)) {
                return true;
            }
            return AdditionalEntryMap.this.additionalValue.equals(o);
        }
    }

    protected static class AdditionalIterator<E>
    implements Iterator<E> {
        private Iterator<E> decoratedIterator;
        private E additional;
        private boolean additionalReturned;

        protected AdditionalIterator(Iterator<E> decoratedIterator, E additional) {
            this.decoratedIterator = decoratedIterator;
            this.additional = additional;
        }

        @Override
        public boolean hasNext() {
            if (this.decoratedIterator.hasNext()) {
                return true;
            }
            return !this.additionalReturned;
        }

        @Override
        public E next() {
            if (this.decoratedIterator.hasNext()) {
                return this.decoratedIterator.next();
            }
            if (this.additionalReturned) {
                throw new NoSuchElementException();
            }
            this.additionalReturned = true;
            return this.additional;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

