/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.keymaster.client.self;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import jakarta.xml.ws.WebServiceException;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.jaxrs.client.ResponseExceptionMapper;
import org.apache.syncope.common.keymaster.client.api.KeymasterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class SelfKeymasterClientExceptionMapper
implements ResponseExceptionMapper<Exception> {
    private static final Logger LOG = LoggerFactory.getLogger(SelfKeymasterClientExceptionMapper.class);

    public Exception fromResponse(Response response) {
        int statusCode = response.getStatus();
        String message = (String)response.readEntity(String.class);
        Object ex = statusCode == Response.Status.UNAUTHORIZED.getStatusCode() ? new NotAuthorizedException((Object)(StringUtils.isBlank((CharSequence)message) ? "Remote unauthorized exception" : message), new Object[0]) : (statusCode == Response.Status.FORBIDDEN.getStatusCode() ? new ForbiddenException(StringUtils.isBlank((CharSequence)message) ? "Remote forbidden exception" : message) : (statusCode == Response.Status.NOT_FOUND.getStatusCode() ? (StringUtils.isBlank((CharSequence)message) ? new NotFoundException() : new NotFoundException(message)) : (statusCode == Response.Status.BAD_REQUEST.getStatusCode() ? (StringUtils.isBlank((CharSequence)message) ? new BadRequestException() : (message.contains(KeymasterException.class.getSimpleName()) ? new KeymasterException(message) : new BadRequestException(message))) : new WebServiceException(String.format("Remote exception with status code: %s", Response.Status.fromStatusCode((int)statusCode).name())))));
        LOG.error("Exception thrown", (Throwable)ex);
        return ex;
    }
}

