/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.api.entity.policy;

import org.apache.syncope.common.lib.types.PolicyType;
import org.apache.syncope.core.persistence.api.entity.policy.AccessPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.AccountPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.AttrReleasePolicy;
import org.apache.syncope.core.persistence.api.entity.policy.AuthPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.InboundPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PasswordPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.Policy;
import org.apache.syncope.core.persistence.api.entity.policy.PropagationPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PushPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.TicketExpirationPolicy;

public class PolicyUtils {
    protected final PolicyType type;

    public PolicyUtils(PolicyType type) {
        this.type = type;
    }

    public PolicyType getType() {
        return this.type;
    }

    public Class<? extends Policy> policyClass() {
        switch (this.type) {
            case ACCOUNT: {
                return AccountPolicy.class;
            }
            case PASSWORD: {
                return PasswordPolicy.class;
            }
            case AUTH: {
                return AuthPolicy.class;
            }
            case ATTR_RELEASE: {
                return AttrReleasePolicy.class;
            }
            case ACCESS: {
                return AccessPolicy.class;
            }
            case TICKET_EXPIRATION: {
                return TicketExpirationPolicy.class;
            }
            case PROPAGATION: {
                return PropagationPolicy.class;
            }
            case INBOUND: {
                return InboundPolicy.class;
            }
        }
        return PushPolicy.class;
    }
}

