/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.authn;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.oidc.discovery.OidcServerDiscoverySettings;
import org.apereo.cas.oidc.issuer.OidcIssuerService;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyStoreUtils;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyUsage;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20ClientAuthenticationMethods;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.ticket.code.OAuth20Code;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.jooq.lambda.Unchecked;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ResourceLoader;

public class OidcJwtAuthenticator
implements Authenticator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcJwtAuthenticator.class);
    protected final OidcIssuerService issuerService;
    protected final ServicesManager servicesManager;
    protected final AuditableExecution registeredServiceAccessStrategyEnforcer;
    protected final TicketRegistry ticketRegistry;
    protected final ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory;
    protected final CasConfigurationProperties casProperties;
    protected final ApplicationContext applicationContext;
    protected final OidcServerDiscoverySettings oidcServerDiscoverySettings;

    protected JWT verifyCredentials(UsernamePasswordCredentials credentials, WebContext webContext) {
        if (!StringUtils.equalsIgnoreCase((CharSequence)"urn:ietf:params:oauth:client-assertion-type:jwt-bearer", (CharSequence)credentials.getUsername())) {
            LOGGER.debug("client assertion type is not set to [{}]", (Object)"urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
            return null;
        }
        if (StringUtils.isBlank((CharSequence)credentials.getPassword())) {
            LOGGER.debug("No assertion is available in the provided credentials");
            return null;
        }
        try {
            JWT jwt = JWTParser.parse((String)credentials.getPassword());
            Algorithm alg = jwt.getHeader().getAlgorithm();
            if (!this.validateJwtAlgorithm(alg)) {
                LOGGER.debug("No assertion is available in the provided credentials");
                return null;
            }
            return jwt;
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return null;
        }
    }

    public Optional<Credentials> validate(CallContext callContext, Credentials creds) {
        return (Optional)FunctionUtils.doAndHandle(() -> {
            boolean authMethodDisabled;
            OidcRegisteredService registeredService = this.getOidcRegisteredService(callContext);
            RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((RegisteredService)registeredService);
            if (OAuth20Utils.isAccessTokenRequest((WebContext)callContext.webContext()) && ((authMethodDisabled = this.oidcServerDiscoverySettings.getTokenEndpointAuthMethodsSupported().stream().map(OAuth20ClientAuthenticationMethods::parse).noneMatch(method -> method == OAuth20ClientAuthenticationMethods.CLIENT_SECRET_JWT || method == OAuth20ClientAuthenticationMethods.PRIVATE_KEY_JWT)) || !OAuth20Utils.isTokenAuthenticationMethodSupportedFor((CallContext)callContext, (OAuthRegisteredService)registeredService, (OAuth20ClientAuthenticationMethods[])new OAuth20ClientAuthenticationMethods[]{OAuth20ClientAuthenticationMethods.CLIENT_SECRET_JWT, OAuth20ClientAuthenticationMethods.PRIVATE_KEY_JWT}))) {
                LOGGER.warn("Private key JWT authentication method is not enabled for CAS, or is not supported for service [{}]", (Object)registeredService.getName());
                return Optional.empty();
            }
            UsernamePasswordCredentials credentials = (UsernamePasswordCredentials)creds;
            JWT jwt = this.verifyCredentials(credentials, callContext.webContext());
            if (jwt == null) {
                LOGGER.warn("Unable to verify credentials");
                return Optional.empty();
            }
            Optional<JsonWebKeySet> keys = OidcJsonWebKeyStoreUtils.getJsonWebKeySet(registeredService, (ResourceLoader)this.applicationContext, Optional.of(OidcJsonWebKeyUsage.SIGNING));
            keys.ifPresent(Unchecked.consumer(jwks -> jwks.getJsonWebKeys().forEach(Unchecked.consumer(jsonWebKey -> {
                JwtConsumer consumer = new JwtConsumerBuilder().setVerificationKey(jsonWebKey.getKey()).setRequireJwtId().setRequireExpirationTime().setRequireSubject().setExpectedIssuer(true, this.issuerService.determineIssuer(Optional.of(registeredService))).setExpectedAudience(true, new String[]{registeredService.getClientId()}).build();
                this.determineUserProfile(credentials, consumer);
            }))));
            return Optional.of(credentials);
        }, e -> {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return Optional.empty();
        }).get();
    }

    protected OidcRegisteredService getOidcRegisteredService(CallContext callContext) throws Throwable {
        WebContext webContext = callContext.webContext();
        String code = webContext.getRequestParameter("code").map(String::valueOf).orElse("");
        OAuth20Code oauthCode = (OAuth20Code)FunctionUtils.doAndHandle(() -> {
            OAuth20Code givenCode = (OAuth20Code)this.ticketRegistry.getTicket(code, OAuth20Code.class);
            return givenCode == null || givenCode.isExpired() ? null : givenCode;
        });
        String clientId = oauthCode == null ? (String)webContext.getRequestParameter("client_id").orElse(null) : oauthCode.getClientId();
        OidcRegisteredService registeredService = (OidcRegisteredService)OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)this.servicesManager, (String)clientId, OidcRegisteredService.class);
        AuditableContext audit = AuditableContext.builder().registeredService((RegisteredService)registeredService).build();
        AuditableExecutionResult accessResult = this.registeredServiceAccessStrategyEnforcer.execute(audit);
        return accessResult.isExecutionFailure() ? null : registeredService;
    }

    protected void determineUserProfile(UsernamePasswordCredentials credentials, JwtConsumer consumer) {
        FunctionUtils.doAndHandle(__ -> {
            JwtClaims jwt = consumer.processToClaims(credentials.getPassword());
            CommonProfile userProfile = new CommonProfile(true);
            userProfile.setId(jwt.getSubject());
            userProfile.addAttributes(jwt.getClaimsMap());
            credentials.setUserProfile((UserProfile)userProfile);
        });
    }

    protected boolean validateJwtAlgorithm(Algorithm alg) {
        return JWSAlgorithm.Family.HMAC_SHA.contains((Object)alg) || JWSAlgorithm.Family.RSA.contains((Object)alg) || JWSAlgorithm.Family.EC.contains((Object)alg);
    }

    @Generated
    public OidcJwtAuthenticator(OidcIssuerService issuerService, ServicesManager servicesManager, AuditableExecution registeredServiceAccessStrategyEnforcer, TicketRegistry ticketRegistry, ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory, CasConfigurationProperties casProperties, ApplicationContext applicationContext, OidcServerDiscoverySettings oidcServerDiscoverySettings) {
        this.issuerService = issuerService;
        this.servicesManager = servicesManager;
        this.registeredServiceAccessStrategyEnforcer = registeredServiceAccessStrategyEnforcer;
        this.ticketRegistry = ticketRegistry;
        this.webApplicationServiceServiceFactory = webApplicationServiceServiceFactory;
        this.casProperties = casProperties;
        this.applicationContext = applicationContext;
        this.oidcServerDiscoverySettings = oidcServerDiscoverySettings;
    }
}

