/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.jwks;

import com.github.benmanes.caffeine.cache.CacheLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyCacheKey;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyStoreUtils;
import org.apereo.cas.oidc.jwks.generator.OidcJsonWebKeystoreGeneratorService;
import org.apereo.cas.oidc.jwks.rotation.OidcJsonWebKeystoreRotationService;
import org.apereo.cas.util.LoggingUtils;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.PublicJsonWebKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public record OidcDefaultJsonWebKeystoreCacheLoader(OidcJsonWebKeystoreGeneratorService oidcJsonWebKeystoreGeneratorService) implements CacheLoader<OidcJsonWebKeyCacheKey, JsonWebKeySet>
{
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcDefaultJsonWebKeystoreCacheLoader.class);

    private static JsonWebKeySet getJsonWebKeysFromJwks(JsonWebKeySet jwks, OidcJsonWebKeyCacheKey cacheKey) {
        List keys = OidcJsonWebKeyStoreUtils.getJsonWebKeyFromJsonWebKeySet(jwks, Optional.empty(), Optional.of(cacheKey.getUsage())).map(JsonWebKeySet::getJsonWebKeys).orElseGet(ArrayList::new);
        return new JsonWebKeySet(keys.stream().filter(key -> OidcJsonWebKeystoreRotationService.JsonWebKeyLifecycleStates.getJsonWebKeyState(key).isCurrent()).map(PublicJsonWebKey.class::cast).filter(key -> key.getPrivateKey() != null).collect(Collectors.toList()));
    }

    public JsonWebKeySet load(OidcJsonWebKeyCacheKey cacheKey) {
        Optional<JsonWebKeySet> jwks = this.buildJsonWebKeySet(cacheKey);
        if (jwks.isEmpty()) {
            LOGGER.warn("JSON web keystore retrieved is empty for issuer [{}]", (Object)cacheKey.getIssuer());
            return null;
        }
        JsonWebKeySet keySet = jwks.get();
        if (keySet.getJsonWebKeys().isEmpty()) {
            LOGGER.warn("JSON web keystore retrieved [{}] contains no JSON web keys", (Object)keySet);
            return null;
        }
        JsonWebKeySet keys = OidcDefaultJsonWebKeystoreCacheLoader.getJsonWebKeysFromJwks(keySet, cacheKey);
        LOGGER.debug("Found JSON web key as [{}]", (Object)keys);
        return keys.getJsonWebKeys().isEmpty() ? null : keys;
    }

    JsonWebKeySet buildJsonWebKeySet(Resource resource, OidcJsonWebKeyCacheKey cacheKey) throws Throwable {
        JsonWebKeySet jsonWebKeySet = OidcJsonWebKeystoreGeneratorService.toJsonWebKeyStore(resource);
        return OidcDefaultJsonWebKeystoreCacheLoader.getJsonWebKeysFromJwks(jsonWebKeySet, cacheKey);
    }

    Optional<JsonWebKeySet> buildJsonWebKeySet(OidcJsonWebKeyCacheKey cacheKey) {
        try {
            Resource resource = this.generateJwksResource();
            if (resource == null) {
                LOGGER.warn("Unable to load or generate a JWKS resource");
                return Optional.empty();
            }
            LOGGER.trace("Retrieving default JSON web key from [{}]", (Object)resource);
            JsonWebKeySet jsonWebKeySet = this.buildJsonWebKeySet(resource, cacheKey);
            if (jsonWebKeySet == null || jsonWebKeySet.getJsonWebKeys().isEmpty()) {
                LOGGER.warn("No JSON web keys could be found");
                return Optional.empty();
            }
            long badKeysCount = jsonWebKeySet.getJsonWebKeys().stream().filter(key -> StringUtils.isBlank((CharSequence)key.getAlgorithm()) && StringUtils.isBlank((CharSequence)key.getKeyId()) && StringUtils.isBlank((CharSequence)key.getKeyType())).count();
            if (badKeysCount == (long)jsonWebKeySet.getJsonWebKeys().size()) {
                LOGGER.warn("No valid JSON web keys could be found. The keys that are found in the keystore do not define an algorithm, key id or key type and cannot be used for JWKS operations.");
                return Optional.empty();
            }
            return Optional.of(jsonWebKeySet);
        }
        catch (Throwable e) {
            LoggingUtils.warn((Logger)LOGGER, (Throwable)e);
            return Optional.empty();
        }
    }

    Resource generateJwksResource() throws Throwable {
        Resource resource = this.oidcJsonWebKeystoreGeneratorService().generate();
        LOGGER.debug("Loading default JSON web key from [{}]", (Object)resource);
        return resource;
    }
}

