/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.jwks.generator;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.hc.core5.http.HttpEntityContainer;
import org.apache.hc.core5.http.HttpResponse;
import org.apereo.cas.configuration.model.support.oidc.OidcProperties;
import org.apereo.cas.configuration.model.support.oidc.jwks.RestfulOidcJsonWebKeystoreProperties;
import org.apereo.cas.oidc.jwks.generator.OidcJsonWebKeystoreGeneratorService;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.http.HttpExecutionRequest;
import org.apereo.cas.util.http.HttpUtils;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;

@Order(value=-2147483648)
public class OidcRestfulJsonWebKeystoreGeneratorService
implements OidcJsonWebKeystoreGeneratorService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcRestfulJsonWebKeystoreGeneratorService.class);
    private final OidcProperties oidcProperties;

    @Override
    public Optional<Resource> find() throws Exception {
        return Optional.ofNullable(this.generate());
    }

    @Override
    public Resource generate() throws Exception {
        RestfulOidcJsonWebKeystoreProperties rest = this.oidcProperties.getJwks().getRest();
        HttpExecutionRequest exec = HttpExecutionRequest.builder().basicAuthPassword(rest.getBasicAuthPassword()).basicAuthUsername(rest.getBasicAuthUsername()).method(HttpMethod.GET).headers(rest.getHeaders()).url(rest.getUrl()).build();
        HttpResponse response = HttpUtils.execute((HttpExecutionRequest)exec);
        if (response == null || !HttpStatus.valueOf((int)response.getCode()).is2xxSuccessful()) {
            LOGGER.warn("Unable to successfully fetch JWKS resource from [{}]", (Object)rest.getUrl());
            return null;
        }
        try (InputStream content = ((HttpEntityContainer)response).getEntity().getContent();){
            String result = IOUtils.toString((InputStream)content, (Charset)StandardCharsets.UTF_8);
            LOGGER.debug("Received payload result from [{}] as [{}]", (Object)rest.getUrl(), (Object)result);
            ByteArrayResource byteArrayResource = new ByteArrayResource(result.getBytes(StandardCharsets.UTF_8), "OIDC JWKS");
            return byteArrayResource;
        }
    }

    @Override
    public JsonWebKeySet store(JsonWebKeySet jsonWebKeySet) {
        RestfulOidcJsonWebKeystoreProperties rest = this.oidcProperties.getJwks().getRest();
        Map headers = CollectionUtils.wrap((String)"Content-Type", (Object)"application/json");
        headers.putAll(rest.getHeaders());
        HttpExecutionRequest exec = HttpExecutionRequest.builder().basicAuthPassword(rest.getBasicAuthPassword()).basicAuthUsername(rest.getBasicAuthUsername()).method(HttpMethod.POST).url(rest.getUrl()).headers(headers).entity(jsonWebKeySet.toJson(JsonWebKey.OutputControlLevel.INCLUDE_PRIVATE)).build();
        HttpResponse response = HttpUtils.execute((HttpExecutionRequest)exec);
        FunctionUtils.doIfNotNull((Object)response, httpResponse -> LOGGER.debug("Storing JWKS resource via [{}] returned [{}]", (Object)rest.getUrl(), (Object)response.getReasonPhrase()));
        return jsonWebKeySet;
    }

    @Generated
    public OidcRestfulJsonWebKeystoreGeneratorService(OidcProperties oidcProperties) {
        this.oidcProperties = oidcProperties;
    }
}

