/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.io;

import jakarta.annotation.Nonnull;
import java.io.Closeable;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;

public class TemporaryFileSystemResource
extends FileSystemResource {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TemporaryFileSystemResource.class);

    public TemporaryFileSystemResource(File file) {
        super(file);
    }

    @Nonnull
    public InputStream getInputStream() throws IOException {
        return new FilterInputStream(super.getInputStream()){

            @Override
            public void close() throws IOException {
                TemporaryFileSystemResource.this.closeThenDeleteFile(this.in);
            }
        };
    }

    public boolean isFile() {
        return false;
    }

    @Nonnull
    public ReadableByteChannel readableChannel() throws IOException {
        final ReadableByteChannel readableChannel = super.readableChannel();
        return new ReadableByteChannel(){

            @Override
            public boolean isOpen() {
                return readableChannel.isOpen();
            }

            @Override
            public void close() throws IOException {
                TemporaryFileSystemResource.this.closeThenDeleteFile(readableChannel);
            }

            @Override
            public int read(ByteBuffer dst) throws IOException {
                return readableChannel.read(dst);
            }
        };
    }

    private void closeThenDeleteFile(Closeable closeable) throws IOException {
        try {
            closeable.close();
        }
        finally {
            this.deleteFile();
        }
    }

    private void deleteFile() {
        try {
            Files.delete(this.getFile().toPath());
        }
        catch (IOException ex) {
            String msg = String.format("Failed to delete temporary heap dump file %s", this.getFile());
            LOGGER.warn(msg, (Throwable)ex);
        }
    }
}

