/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mustache;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Supplier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.http.MediaType;
import org.springframework.util.MimeType;

@ConfigurationProperties(prefix="spring.mustache")
public class MustacheProperties {
    private static final MimeType DEFAULT_CONTENT_TYPE = MimeType.valueOf((String)"text/html");
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    public static final String DEFAULT_PREFIX = "classpath:/templates/";
    public static final String DEFAULT_SUFFIX = ".mustache";
    private final Servlet servlet = new Servlet(this::getCharset);
    private final Reactive reactive = new Reactive();
    private String[] viewNames;
    private String requestContextAttribute;
    private boolean enabled = true;
    private Charset charset = DEFAULT_CHARSET;
    private boolean checkTemplateLocation = true;
    private String prefix = "classpath:/templates/";
    private String suffix = ".mustache";

    public Servlet getServlet() {
        return this.servlet;
    }

    public Reactive getReactive() {
        return this.reactive;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String[] getViewNames() {
        return this.viewNames;
    }

    public void setViewNames(String[] viewNames) {
        this.viewNames = viewNames;
    }

    public String getRequestContextAttribute() {
        return this.requestContextAttribute;
    }

    public void setRequestContextAttribute(String requestContextAttribute) {
        this.requestContextAttribute = requestContextAttribute;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getCharsetName() {
        return this.charset != null ? this.charset.name() : null;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public boolean isCheckTemplateLocation() {
        return this.checkTemplateLocation;
    }

    public void setCheckTemplateLocation(boolean checkTemplateLocation) {
        this.checkTemplateLocation = checkTemplateLocation;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public static class Servlet {
        private boolean allowRequestOverride;
        private boolean allowSessionOverride;
        private boolean cache;
        private MimeType contentType = DEFAULT_CONTENT_TYPE;
        private boolean exposeRequestAttributes;
        private boolean exposeSessionAttributes;
        private boolean exposeSpringMacroHelpers = true;
        private final Supplier<Charset> charset;

        public Servlet() {
            this.charset = () -> null;
        }

        private Servlet(Supplier<Charset> charset) {
            this.charset = charset;
        }

        public boolean isAllowRequestOverride() {
            return this.allowRequestOverride;
        }

        public void setAllowRequestOverride(boolean allowRequestOverride) {
            this.allowRequestOverride = allowRequestOverride;
        }

        public boolean isAllowSessionOverride() {
            return this.allowSessionOverride;
        }

        public void setAllowSessionOverride(boolean allowSessionOverride) {
            this.allowSessionOverride = allowSessionOverride;
        }

        public boolean isCache() {
            return this.cache;
        }

        public void setCache(boolean cache) {
            this.cache = cache;
        }

        public MimeType getContentType() {
            Charset charset;
            if (this.contentType != null && this.contentType.getCharset() == null && (charset = this.charset.get()) != null) {
                LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
                parameters.put("charset", charset.name());
                parameters.putAll(this.contentType.getParameters());
                return new MimeType(this.contentType, parameters);
            }
            return this.contentType;
        }

        public void setContentType(MimeType contentType) {
            this.contentType = contentType;
        }

        public boolean isExposeRequestAttributes() {
            return this.exposeRequestAttributes;
        }

        public void setExposeRequestAttributes(boolean exposeRequestAttributes) {
            this.exposeRequestAttributes = exposeRequestAttributes;
        }

        public boolean isExposeSessionAttributes() {
            return this.exposeSessionAttributes;
        }

        public void setExposeSessionAttributes(boolean exposeSessionAttributes) {
            this.exposeSessionAttributes = exposeSessionAttributes;
        }

        public boolean isExposeSpringMacroHelpers() {
            return this.exposeSpringMacroHelpers;
        }

        public void setExposeSpringMacroHelpers(boolean exposeSpringMacroHelpers) {
            this.exposeSpringMacroHelpers = exposeSpringMacroHelpers;
        }
    }

    public static class Reactive {
        private List<MediaType> mediaTypes;

        public List<MediaType> getMediaTypes() {
            return this.mediaTypes;
        }

        public void setMediaTypes(List<MediaType> mediaTypes) {
            this.mediaTypes = mediaTypes;
        }
    }
}

