/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.auth.ext;

import java.time.Clock;
import java.time.Period;
import java.time.ZonedDateTime;
import org.ldaptive.AbstractFreezable;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.auth.AuthenticationResponse;
import org.ldaptive.auth.AuthenticationResponseHandler;
import org.ldaptive.auth.ext.EDirectoryAccountState;
import org.ldaptive.transcode.GeneralizedTimeValueTranscoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EDirectoryAuthenticationResponseHandler
extends AbstractFreezable
implements AuthenticationResponseHandler {
    public static final String[] ATTRIBUTES = new String[]{"passwordExpirationTime", "loginGraceRemaining"};
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Clock expirationClock;
    private Period warningPeriod;

    EDirectoryAuthenticationResponseHandler(Clock clock) {
        this.expirationClock = clock;
    }

    public EDirectoryAuthenticationResponseHandler() {
        this.expirationClock = Clock.systemDefaultZone();
    }

    public EDirectoryAuthenticationResponseHandler(Period warning) {
        this.expirationClock = Clock.systemDefaultZone();
        this.setWarningPeriod(warning);
    }

    @Override
    public void handle(AuthenticationResponse response) {
        if (response.getDiagnosticMessage() != null && !response.getDiagnosticMessage().isEmpty()) {
            this.logger.debug("Parsing response diagnostic message: {}", (Object)response.getDiagnosticMessage());
            EDirectoryAccountState.Error edError = EDirectoryAccountState.Error.parse(response.getDiagnosticMessage());
            if (edError != null) {
                this.logger.debug("Translated response diagnostic message to: {}", (Object)edError);
                response.setAccountState(new EDirectoryAccountState(edError));
            }
        } else if (response.isSuccess()) {
            LdapEntry entry = response.getLdapEntry();
            LdapAttribute expTime = entry != null ? entry.getAttribute("passwordExpirationTime") : null;
            LdapAttribute loginRemaining = entry != null ? entry.getAttribute("loginGraceRemaining") : null;
            int loginRemainingValue = loginRemaining != null ? Integer.parseInt(loginRemaining.getStringValue()) : 0;
            this.logger.debug("Read attributes passwordExpirationTime: {}, loginGraceRemaining: {}", (Object)expTime, (Object)loginRemaining);
            if (expTime != null) {
                ZonedDateTime exp = (ZonedDateTime)expTime.getValue(new GeneralizedTimeValueTranscoder().decoder());
                this.logger.debug("Transcoded passwordExpirationTime to {}", (Object)exp);
                if (this.warningPeriod != null) {
                    ZonedDateTime warn = exp.minus(this.warningPeriod);
                    ZonedDateTime now = ZonedDateTime.now(this.expirationClock);
                    this.logger.debug("Warning period is: {}, current datetime is {}", (Object)warn, (Object)now);
                    if (now.isAfter(warn)) {
                        response.setAccountState(new EDirectoryAccountState(exp, loginRemainingValue));
                    }
                } else {
                    this.logger.debug("No warning period is defined");
                    response.setAccountState(new EDirectoryAccountState(exp, loginRemainingValue));
                }
            } else if (loginRemaining != null) {
                this.logger.debug("Using loginGraceRemaining: {}", (Object)loginRemainingValue);
                response.setAccountState(new EDirectoryAccountState(null, loginRemainingValue));
            }
        }
        this.logger.debug("Configured authentication response: {}", (Object)response);
    }

    public Period getWarningPeriod() {
        return this.warningPeriod;
    }

    public void setWarningPeriod(Period period) {
        this.assertMutable();
        this.warningPeriod = period;
    }

    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::warningPeriod=" + this.warningPeriod + "]";
    }
}

