/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.ui.commons.markup.html.form;

import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.syncope.client.ui.commons.markup.html.form.AbstractFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.FieldPanel;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.to.AttributableTO;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.ResourceReference;
import org.springframework.util.StringUtils;
import org.wicketstuff.kendo.ui.resource.KendoCultureResourceReference;

public abstract class DateFieldPanel
extends FieldPanel<Date> {
    private static final long serialVersionUID = -428975732068281726L;
    protected final FastDateFormat fmt;

    protected DateFieldPanel(String id, String name, IModel<Date> model, FastDateFormat fmt) {
        super(id, name, model);
        this.fmt = fmt;
    }

    @Override
    public FieldPanel<Date> setNewModel(final List<Serializable> list) {
        this.setNewModel(new Model<Date>(){
            private static final long serialVersionUID = 527651414610325237L;

            public Date getObject() {
                Date date = null;
                if (list != null && !list.isEmpty() && StringUtils.hasText((String)((Serializable)list.getFirst()).toString())) {
                    try {
                        date = DateFieldPanel.this.fmt.parse(((Serializable)list.getFirst()).toString());
                    }
                    catch (ParseException e) {
                        AbstractFieldPanel.LOG.error("invalid parse exception", (Throwable)e);
                    }
                }
                return date;
            }

            public void setObject(Date object) {
                list.clear();
                if (object != null) {
                    list.add(DateFieldPanel.this.fmt.format(object));
                }
            }
        });
        return this;
    }

    @Override
    public FieldPanel<Date> setNewModel(final ListItem item) {
        Model<Date> model = new Model<Date>(){
            private static final long serialVersionUID = 6799404673615637845L;

            public Date getObject() {
                Date date = null;
                Object obj = item.getModelObject();
                if (obj != null && !obj.toString().isEmpty()) {
                    if (obj instanceof String) {
                        try {
                            date = DateFieldPanel.this.fmt.parse(obj.toString());
                        }
                        catch (ParseException e) {
                            AbstractFieldPanel.LOG.error("While parsing date", (Throwable)e);
                        }
                    } else {
                        Date date1;
                        date = obj instanceof Date ? (date1 = (Date)obj) : new Date((Long)obj);
                    }
                }
                return date;
            }

            public void setObject(Date object) {
                item.setModelObject(Optional.ofNullable(object).map(arg_0 -> ((FastDateFormat)DateFieldPanel.this.fmt).format(arg_0)).orElse(null));
            }
        };
        this.field.setModel((IModel)model);
        return this;
    }

    @Override
    public FieldPanel<Date> setNewModel(final AttributableTO attributable, final String schema) {
        this.field.setModel((IModel)new Model<Date>(){
            private static final long serialVersionUID = -4214654722524358000L;

            public Date getObject() {
                return attributable.getPlainAttr(schema).map(Attr::getValues).filter(Predicate.not(List::isEmpty)).map(values -> {
                    try {
                        return DateFieldPanel.this.fmt.parse((String)values.getFirst());
                    }
                    catch (ParseException e) {
                        AbstractFieldPanel.LOG.error("While parsing date", (Throwable)e);
                        return null;
                    }
                }).orElse(null);
            }

            public void setObject(Date object) {
                attributable.getPlainAttr(schema).ifPresent(plainAttr -> {
                    plainAttr.getValues().clear();
                    Optional.ofNullable(object).ifPresent(o -> plainAttr.getValues().add(DateFieldPanel.this.fmt.format(object)));
                });
            }
        });
        return this;
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new KendoCultureResourceReference(this.getLocale())));
    }
}

