/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.configurer.plan;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apereo.cas.util.concurrent.CasReentrantLock;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlan;
import org.apereo.cas.web.flow.CasWebflowLoginContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.web.servlet.HandlerInterceptor;

public class DefaultCasWebflowExecutionPlan
implements CasWebflowExecutionPlan {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCasWebflowExecutionPlan.class);
    private final CasReentrantLock lock = new CasReentrantLock();
    private final List<CasWebflowConfigurer> webflowConfigurers = new ArrayList<CasWebflowConfigurer>();
    private final List<HandlerInterceptor> webflowInterceptors = new ArrayList<HandlerInterceptor>();
    private final List<CasWebflowLoginContextProvider> webflowLoginContextProviders = new ArrayList<CasWebflowLoginContextProvider>();
    private final ConfigurableApplicationContext applicationContext;
    private boolean initialized;

    public void registerWebflowLoginContextProvider(CasWebflowLoginContextProvider provider) {
        if (BeanSupplier.isNotProxy((Object)provider)) {
            LOGGER.trace("Registering webflow login context provider [{}]", (Object)provider.getName());
            this.webflowLoginContextProviders.add(provider);
        }
    }

    public void registerWebflowConfigurer(CasWebflowConfigurer cfg) {
        if (BeanSupplier.isNotProxy((Object)cfg)) {
            LOGGER.trace("Registering webflow configurer [{}]", (Object)cfg.getName());
            this.webflowConfigurers.add(cfg);
        }
    }

    public void registerWebflowInterceptor(HandlerInterceptor interceptor) {
        if (BeanSupplier.isNotProxy((Object)interceptor)) {
            LOGGER.trace("Registering webflow interceptor [{}]", (Object)interceptor.getClass().getSimpleName());
            this.webflowInterceptors.add(interceptor);
        }
    }

    public CasWebflowExecutionPlan execute() {
        this.lock.tryLock(__ -> {
            if (!this.initialized) {
                AnnotationAwareOrderComparator.sortIfNecessary(this.webflowConfigurers);
                AnnotationAwareOrderComparator.sortIfNecessary(this.webflowLoginContextProviders);
                this.webflowConfigurers.stream().filter(BeanSupplier::isNotProxy).forEach(cfg -> {
                    LOGGER.trace("Registering webflow configurer [{}]", (Object)cfg.getName());
                    cfg.initialize();
                });
                this.webflowConfigurers.stream().filter(BeanSupplier::isNotProxy).forEach(cfg -> cfg.postInitialization(this.applicationContext));
                this.initialized = true;
            }
        });
        return this;
    }

    @Generated
    public CasReentrantLock getLock() {
        return this.lock;
    }

    @Generated
    public List<CasWebflowConfigurer> getWebflowConfigurers() {
        return this.webflowConfigurers;
    }

    @Generated
    public List<HandlerInterceptor> getWebflowInterceptors() {
        return this.webflowInterceptors;
    }

    @Generated
    public List<CasWebflowLoginContextProvider> getWebflowLoginContextProviders() {
        return this.webflowLoginContextProviders;
    }

    @Generated
    public ConfigurableApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Generated
    public boolean isInitialized() {
        return this.initialized;
    }

    @Generated
    public DefaultCasWebflowExecutionPlan(ConfigurableApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

