/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.logout;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.logout.LogoutExecutionPlan;
import org.apereo.cas.logout.LogoutRequestStatus;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.flow.logout.AbstractLogoutAction;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.cas.web.support.WebUtils;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class LogoutAction
extends AbstractLogoutAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LogoutAction.class);

    public LogoutAction(TicketRegistry ticketRegistry, CasCookieBuilder ticketGrantingTicketCookieGenerator, ArgumentExtractor argumentExtractor, ServicesManager servicesManager, LogoutExecutionPlan logoutExecutionPlan, CasConfigurationProperties casProperties) {
        super(ticketRegistry, ticketGrantingTicketCookieGenerator, argumentExtractor, servicesManager, logoutExecutionPlan, casProperties);
    }

    @Override
    protected Event doInternalExecute(RequestContext requestContext) {
        List logoutRequests = WebUtils.getLogoutRequests((RequestContext)requestContext);
        Boolean needFrontSlo = (Boolean)FunctionUtils.doIf((logoutRequests != null ? 1 : 0) != 0, () -> Objects.requireNonNull(logoutRequests).stream().anyMatch(logoutRequest -> logoutRequest.getStatus() == LogoutRequestStatus.NOT_ATTEMPTED), () -> Boolean.FALSE).get();
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
        this.logoutExecutionPlan.getLogoutRedirectionStrategies().stream().filter(strategy -> strategy.supports(request, response)).map(Unchecked.function(strategy -> strategy.handle(request, response))).filter(Objects::nonNull).forEach(logoutResponse -> {
            LOGGER.debug("Logout response is [{}]", logoutResponse);
            logoutResponse.getService().ifPresent(service -> WebUtils.putServiceIntoFlowScope((RequestContext)requestContext, (Service)service));
            logoutResponse.getLogoutRedirectUrl().ifPresent(url -> WebUtils.putLogoutRedirectUrl((RequestContext)requestContext, (String)url));
            logoutResponse.getLogoutPostUrl().ifPresent(url -> WebUtils.putLogoutPostUrl((RequestContext)requestContext, (String)url));
            if (!logoutResponse.getLogoutPostData().isEmpty()) {
                WebUtils.putLogoutPostData((RequestContext)requestContext, (Map)logoutResponse.getLogoutPostData());
            }
        });
        if (needFrontSlo.booleanValue()) {
            LOGGER.trace("Proceeding forward with front-channel single logout");
            return new Event((Object)this, "front");
        }
        LOGGER.trace("Moving forward to finish the logout process");
        return new Event((Object)this, "finish");
    }
}

