/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.Collections;
import java.util.Objects;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.request.Response;
import org.apache.wicket.util.lang.Args;

public class StringHeaderItem
extends HeaderItem {
    private final CharSequence string;

    public static StringHeaderItem forString(CharSequence string) {
        return new StringHeaderItem(string);
    }

    public StringHeaderItem(CharSequence string) {
        this.string = (CharSequence)Args.notNull((Object)string, (String)"string");
    }

    public CharSequence getString() {
        return this.string;
    }

    @Override
    public void render(Response response) {
        response.write(this.getString());
    }

    @Override
    public Iterable<?> getRenderTokens() {
        return Collections.singletonList(this.getString());
    }

    public String toString() {
        return "StringHeaderItem(" + String.valueOf(this.getString()) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringHeaderItem that = (StringHeaderItem)o;
        return Objects.equals(this.string, that.string);
    }

    public int hashCode() {
        return Objects.hash(this.string);
    }
}

