/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.test;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.flowable.common.engine.api.management.TablePage;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandConfig;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.common.engine.impl.persistence.entity.TableDataManager;
import org.flowable.common.engine.impl.persistence.entity.TablePageQueryImpl;
import org.flowable.common.engine.impl.test.EnsureCleanDb;
import org.flowable.common.engine.impl.util.IoUtil;
import org.slf4j.Logger;

public class EnsureCleanDbUtils {
    protected static final String DB_CHANGELOG_TABLE = "DATABASECHANGELOG";

    public static void assertAndEnsureCleanDb(String testName, Logger logger, AbstractEngineConfiguration engineConfiguration, EnsureCleanDb ensureCleanDb, boolean hasNoException, Command<Void> dropAndRecreateDbCommand) {
        HashSet<String> tableNamesExcludedFromDbCleanCheck = new HashSet<String>(Arrays.asList(ensureCleanDb.excludeTables()));
        Command<Void> dropAndRecreateDbCommandToUse = ensureCleanDb.dropDb() ? dropAndRecreateDbCommand : null;
        EnsureCleanDbUtils.assertAndEnsureCleanDb(testName, logger, engineConfiguration, tableNamesExcludedFromDbCleanCheck, hasNoException, dropAndRecreateDbCommandToUse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertAndEnsureCleanDb(String testName, Logger logger, AbstractEngineConfiguration engineConfiguration, Collection<String> tableNamesExcludedFromDbCleanCheck, boolean hasNoException, Command<Void> dropAndRecreateDbCommand) {
        logger.debug("verifying that db is clean after test");
        TableDataManager tableDataManager = engineConfiguration.getTableDataManager();
        Map tableCounts = engineConfiguration.getCommandExecutor().execute(commandContext -> tableDataManager.getTableCount());
        StringBuilder outputMessage = new StringBuilder();
        for (String tableName : tableCounts.keySet()) {
            Long count;
            String tableNameWithoutPrefix = tableName.replace(engineConfiguration.getDatabaseTablePrefix(), "");
            if (tableNamesExcludedFromDbCleanCheck.contains(tableNameWithoutPrefix) || tableNameWithoutPrefix.contains(DB_CHANGELOG_TABLE) || (count = (Long)tableCounts.get(tableName)) == 0L) continue;
            outputMessage.append("  ").append(tableName).append(": ").append(count).append(" record(s) : \n");
            TablePage tableData = engineConfiguration.getCommandExecutor().execute(commandContext -> tableDataManager.getTablePage(new TablePageQueryImpl().tableName(tableName), 0, count.intValue()));
            if (tableData == null || tableData.getRows() == null) continue;
            for (Map row : tableData.getRows()) {
                StringJoiner stringJoiner = new StringJoiner(", ", "{", "}");
                outputMessage.append("    ");
                for (String key : row.keySet()) {
                    Object value = row.get(key);
                    Object stringValue = null;
                    if (value instanceof byte[]) {
                        stringValue = new String((byte[])value);
                    } else if (value instanceof InputStream) {
                        try (InputStream stream = (InputStream)value;){
                            stringValue = new String(IoUtil.readInputStream(stream, "row value for " + key));
                        }
                        catch (Exception exception) {
                            stringValue = "Failed to read stream: " + Objects.toString(value, null) + ". Error: " + ExceptionUtils.getStackTrace((Throwable)exception);
                        }
                    } else {
                        stringValue = Objects.toString(value, null);
                    }
                    stringJoiner.add(key + " = " + (String)stringValue);
                }
                outputMessage.append(stringJoiner);
                outputMessage.append("\n");
            }
        }
        if (outputMessage.length() > 0) {
            outputMessage.insert(0, "DB NOT CLEAN for " + testName + ": \n");
            logger.error("\n");
            logger.error(outputMessage.toString());
            logger.info("dropping and recreating db");
            if (dropAndRecreateDbCommand != null) {
                String originalDatabaseSchemaUpdate = engineConfiguration.getDatabaseSchemaUpdate();
                try {
                    engineConfiguration.setDatabaseSchemaUpdate("drop-create");
                    CommandExecutor commandExecutor = engineConfiguration.getCommandExecutor();
                    CommandConfig config = new CommandConfig().transactionNotSupported();
                    commandExecutor.execute(config, dropAndRecreateDbCommand);
                }
                finally {
                    engineConfiguration.setDatabaseSchemaUpdate(originalDatabaseSchemaUpdate);
                }
            }
            if (hasNoException) {
                throw new AssertionError((Object)outputMessage.toString());
            }
        } else {
            logger.info("database was clean");
        }
    }
}

