/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.util;

import java.util.Map;
import org.apache.openjpa.util.AbstractChangeTracker;
import org.apache.openjpa.util.MapChangeTracker;

public class MapChangeTrackerImpl
extends AbstractChangeTracker
implements MapChangeTracker {
    private final Map _map;
    private boolean _keys = true;

    public MapChangeTrackerImpl(Map map, boolean autoOff) {
        this._map = map;
        this.setAutoOff(autoOff);
    }

    @Override
    public boolean getTrackKeys() {
        return this._keys;
    }

    @Override
    public void setTrackKeys(boolean keys) {
        this._keys = keys;
    }

    @Override
    public void added(Object key, Object val) {
        if (this._keys) {
            super.added(key);
        } else {
            super.added(val);
        }
    }

    @Override
    public void removed(Object key, Object val) {
        if (this._keys) {
            super.removed(key);
        } else {
            super.removed(val);
        }
    }

    @Override
    public void changed(Object key, Object oldVal, Object newVal) {
        if (this._keys) {
            super.changed(key);
        } else {
            super.removed(oldVal);
            super.added(newVal);
        }
    }

    @Override
    protected void add(Object obj) {
        if (this.rem != null && this.rem.remove(obj)) {
            if (this.change == null) {
                this.change = this.newSet();
            }
            this.change.add(obj);
        } else if (this.getAutoOff() && this.getAdded().size() + this.getChanged().size() + this.getRemoved().size() >= this._map.size()) {
            this.stopTracking();
        } else {
            if (this.add == null) {
                this.add = this.newSet();
            }
            this.add.add(obj);
        }
    }

    @Override
    protected void remove(Object obj) {
        if (this.change != null) {
            this.change.remove(obj);
        }
        if (this.add == null || !this.add.remove(obj)) {
            if (this.getAutoOff() && this.getAdded().size() + this.getChanged().size() + this.getRemoved().size() >= this._map.size()) {
                this.stopTracking();
            } else {
                if (this.rem == null) {
                    this.rem = this.newSet();
                }
                this.rem.add(obj);
            }
        }
    }

    @Override
    protected void change(Object key) {
        if (this.change != null && this.change.contains(key) || this.add != null && this.add.contains(key)) {
            return;
        }
        if (this.getAutoOff() && this.getAdded().size() + this.getChanged().size() + this.getRemoved().size() >= this._map.size()) {
            this.stopTracking();
        } else {
            if (this.change == null) {
                this.change = this.newSet();
            }
            this.change.add(key);
        }
    }
}

