/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.query.parser.sql.support;

import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.QueryFactory;
import com.googlecode.cqengine.query.logical.And;
import com.googlecode.cqengine.query.logical.Or;
import com.googlecode.cqengine.query.option.AttributeOrder;
import com.googlecode.cqengine.query.option.OrderByOption;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.query.parser.common.ParserUtils;
import com.googlecode.cqengine.query.parser.common.QueryParser;
import com.googlecode.cqengine.query.parser.sql.grammar.SQLGrammarBaseListener;
import com.googlecode.cqengine.query.parser.sql.grammar.SQLGrammarParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class SQLAntlrListener<O>
extends SQLGrammarBaseListener {
    protected final QueryParser<O> queryParser;
    protected final Map<ParserRuleContext, Collection<Query<O>>> childQueries = new HashMap<ParserRuleContext, Collection<Query<O>>>();
    protected OrderByOption<O> orderByOption = null;
    protected int numQueriesEncountered = 0;
    protected int numQueriesParsed = 0;

    public SQLAntlrListener(QueryParser<O> queryParser) {
        this.queryParser = queryParser;
    }

    @Override
    public void exitAndQuery(SQLGrammarParser.AndQueryContext ctx) {
        this.addParsedQuery(ctx, new And<O>(this.childQueries.get((Object)ctx)));
    }

    @Override
    public void exitOrQuery(SQLGrammarParser.OrQueryContext ctx) {
        this.addParsedQuery(ctx, new Or<O>(this.childQueries.get((Object)ctx)));
    }

    @Override
    public void exitNotQuery(SQLGrammarParser.NotQueryContext ctx) {
        this.addParsedQuery(ctx, QueryFactory.not(this.childQueries.get((Object)ctx).iterator().next()));
    }

    @Override
    public void exitEqualQuery(SQLGrammarParser.EqualQueryContext ctx) {
        Attribute<O, Object> attribute = this.queryParser.getAttribute((ParseTree)ctx.attributeName(), Object.class);
        Object value = this.queryParser.parseValue(attribute, (ParseTree)ctx.queryParameter());
        this.addParsedQuery(ctx, QueryFactory.equal(attribute, value));
    }

    @Override
    public void exitNotEqualQuery(SQLGrammarParser.NotEqualQueryContext ctx) {
        Attribute<O, Object> attribute = this.queryParser.getAttribute((ParseTree)ctx.attributeName(), Object.class);
        Object value = this.queryParser.parseValue(attribute, (ParseTree)ctx.queryParameter());
        this.addParsedQuery(ctx, QueryFactory.not(QueryFactory.equal(attribute, value)));
    }

    @Override
    public void exitLessThanOrEqualToQuery(SQLGrammarParser.LessThanOrEqualToQueryContext ctx) {
        Attribute<O, Comparable> attribute = this.queryParser.getAttribute((ParseTree)ctx.attributeName(), Comparable.class);
        Comparable value = this.queryParser.parseValue(attribute, (ParseTree)ctx.queryParameter());
        this.addParsedQuery(ctx, QueryFactory.lessThanOrEqualTo(attribute, value));
    }

    @Override
    public void exitLessThanQuery(SQLGrammarParser.LessThanQueryContext ctx) {
        Attribute<O, Comparable> attribute = this.queryParser.getAttribute((ParseTree)ctx.attributeName(), Comparable.class);
        Comparable value = this.queryParser.parseValue(attribute, (ParseTree)ctx.queryParameter());
        this.addParsedQuery(ctx, QueryFactory.lessThan(attribute, value));
    }

    @Override
    public void exitGreaterThanOrEqualToQuery(SQLGrammarParser.GreaterThanOrEqualToQueryContext ctx) {
        Attribute<O, Comparable> attribute = this.queryParser.getAttribute((ParseTree)ctx.attributeName(), Comparable.class);
        Comparable value = this.queryParser.parseValue(attribute, (ParseTree)ctx.queryParameter());
        this.addParsedQuery(ctx, QueryFactory.greaterThanOrEqualTo(attribute, value));
    }

    @Override
    public void exitGreaterThanQuery(SQLGrammarParser.GreaterThanQueryContext ctx) {
        Attribute<O, Comparable> attribute = this.queryParser.getAttribute((ParseTree)ctx.attributeName(), Comparable.class);
        Comparable value = this.queryParser.parseValue(attribute, (ParseTree)ctx.queryParameter());
        this.addParsedQuery(ctx, QueryFactory.greaterThan(attribute, value));
    }

    @Override
    public void exitBetweenQuery(SQLGrammarParser.BetweenQueryContext ctx) {
        Attribute<O, Comparable> attribute = this.queryParser.getAttribute((ParseTree)ctx.attributeName(), Comparable.class);
        List<SQLGrammarParser.QueryParameterContext> queryParameters = ctx.queryParameter();
        Comparable lowerValue = this.queryParser.parseValue(attribute, (ParseTree)queryParameters.get(0));
        Comparable upperValue = this.queryParser.parseValue(attribute, (ParseTree)queryParameters.get(1));
        this.addParsedQuery(ctx, QueryFactory.between(attribute, lowerValue, upperValue));
    }

    @Override
    public void exitNotBetweenQuery(SQLGrammarParser.NotBetweenQueryContext ctx) {
        Attribute<O, Comparable> attribute = this.queryParser.getAttribute((ParseTree)ctx.attributeName(), Comparable.class);
        List<SQLGrammarParser.QueryParameterContext> queryParameters = ctx.queryParameter();
        Comparable lowerValue = this.queryParser.parseValue(attribute, (ParseTree)queryParameters.get(0));
        Comparable upperValue = this.queryParser.parseValue(attribute, (ParseTree)queryParameters.get(1));
        this.addParsedQuery(ctx, QueryFactory.not(QueryFactory.between(attribute, lowerValue, upperValue)));
    }

    @Override
    public void exitInQuery(SQLGrammarParser.InQueryContext ctx) {
        Attribute<O, Object> attribute = this.queryParser.getAttribute((ParseTree)ctx.attributeName(), Object.class);
        List<SQLGrammarParser.QueryParameterContext> queryParameters = ctx.queryParameter();
        ArrayList<Object> values = new ArrayList<Object>(queryParameters.size());
        for (ParseTree parseTree : queryParameters) {
            Object value = this.queryParser.parseValue(attribute, parseTree);
            values.add(value);
        }
        this.addParsedQuery(ctx, QueryFactory.in(attribute, values));
    }

    @Override
    public void exitNotInQuery(SQLGrammarParser.NotInQueryContext ctx) {
        Attribute<O, Object> attribute = this.queryParser.getAttribute((ParseTree)ctx.attributeName(), Object.class);
        List<SQLGrammarParser.QueryParameterContext> queryParameters = ctx.queryParameter();
        ArrayList<Object> values = new ArrayList<Object>(queryParameters.size());
        for (ParseTree parseTree : queryParameters) {
            Object value = this.queryParser.parseValue(attribute, parseTree);
            values.add(value);
        }
        this.addParsedQuery(ctx, QueryFactory.not(QueryFactory.in(attribute, values)));
    }

    @Override
    public void exitStartsWithQuery(SQLGrammarParser.StartsWithQueryContext ctx) {
        Attribute<O, String> attribute = this.queryParser.getAttribute((ParseTree)ctx.attributeName(), String.class);
        String value = this.queryParser.parseValue(attribute, (ParseTree)ctx.queryParameterTrailingPercent());
        value = value.substring(0, value.length() - 1);
        this.addParsedQuery(ctx, QueryFactory.startsWith(attribute, value));
    }

    @Override
    public void exitIsPrefixOfQuery(SQLGrammarParser.IsPrefixOfQueryContext ctx) {
        Attribute<O, String> attribute = this.queryParser.getAttribute((ParseTree)ctx.attributeName(), String.class);
        String value = this.queryParser.parseValue(attribute, (ParseTree)ctx.queryParameter());
        this.addParsedQuery(ctx, QueryFactory.isPrefixOf(attribute, value));
    }

    @Override
    public void exitEndsWithQuery(SQLGrammarParser.EndsWithQueryContext ctx) {
        Attribute<O, String> attribute = this.queryParser.getAttribute((ParseTree)ctx.attributeName(), String.class);
        String value = this.queryParser.parseValue(attribute, (ParseTree)ctx.queryParameterLeadingPercent());
        value = value.substring(1, value.length());
        this.addParsedQuery(ctx, QueryFactory.endsWith(attribute, value));
    }

    @Override
    public void exitContainsQuery(SQLGrammarParser.ContainsQueryContext ctx) {
        Attribute<O, String> attribute = this.queryParser.getAttribute((ParseTree)ctx.attributeName(), String.class);
        String value = this.queryParser.parseValue(attribute, (ParseTree)ctx.queryParameterLeadingAndTrailingPercent());
        value = value.substring(1, value.length() - 1);
        this.addParsedQuery(ctx, QueryFactory.contains(attribute, value));
    }

    @Override
    public void exitHasQuery(SQLGrammarParser.HasQueryContext ctx) {
        Attribute<O, Object> attribute = this.queryParser.getAttribute((ParseTree)ctx.attributeName(), Object.class);
        this.addParsedQuery(ctx, QueryFactory.has(attribute));
    }

    @Override
    public void exitNotHasQuery(SQLGrammarParser.NotHasQueryContext ctx) {
        Attribute<O, Object> attribute = this.queryParser.getAttribute((ParseTree)ctx.attributeName(), Object.class);
        this.addParsedQuery(ctx, QueryFactory.not(QueryFactory.has(attribute)));
    }

    @Override
    public void exitQuery(SQLGrammarParser.QueryContext ctx) {
        ++this.numQueriesEncountered;
        ParserUtils.validateAllQueriesParsed(this.numQueriesEncountered, this.numQueriesParsed);
    }

    @Override
    public void exitOrderByClause(SQLGrammarParser.OrderByClauseContext ctx) {
        ArrayList attributeOrders = new ArrayList();
        for (SQLGrammarParser.AttributeOrderContext orderContext : ctx.attributeOrder()) {
            Attribute<O, Comparable> attribute = this.queryParser.getAttribute((ParseTree)orderContext.attributeName(), Comparable.class);
            boolean descending = orderContext.direction() != null && orderContext.direction().K_DESC() != null;
            attributeOrders.add(new AttributeOrder<O>(attribute, descending));
        }
        this.orderByOption = QueryFactory.orderBy(attributeOrders);
    }

    void addParsedQuery(ParserRuleContext currentContext, Query<O> parsedQuery) {
        ParserRuleContext parentContext = ParserUtils.getParentContextOfType(currentContext, this.getAndOrNotContextClasses());
        Collection<Query<O>> childrenOfParent = this.childQueries.get(parentContext);
        if (childrenOfParent == null) {
            childrenOfParent = new ArrayList<Query<O>>();
            this.childQueries.put(parentContext, childrenOfParent);
        }
        childrenOfParent.add(parsedQuery);
        ++this.numQueriesParsed;
    }

    public Query<O> getParsedQuery() {
        Collection<Query<O>> rootQuery = this.childQueries.get(null);
        if (rootQuery == null) {
            return QueryFactory.all(this.queryParser.getObjectType());
        }
        ParserUtils.validateExpectedNumberOfChildQueries(1, rootQuery.size());
        return rootQuery.iterator().next();
    }

    public QueryOptions getQueryOptions() {
        OrderByOption<O> orderByOption = this.orderByOption;
        return orderByOption != null ? QueryFactory.queryOptions(orderByOption) : QueryFactory.noQueryOptions();
    }

    protected Class[] getAndOrNotContextClasses() {
        return new Class[]{SQLGrammarParser.AndQueryContext.class, SQLGrammarParser.OrQueryContext.class, SQLGrammarParser.NotQueryContext.class};
    }
}

