/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import lombok.Generated;
import org.apereo.cas.acct.AccountProfileServiceTicketGeneratorAuthority;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationPostProcessor;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.MultifactorAuthenticationContextValidator;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderSelector;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.config.MultifactorAuthnTrustConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.captcha.GoogleRecaptchaProperties;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.pm.PasswordResetUrlBuilder;
import org.apereo.cas.pm.PasswordStrengthAuthenticationPostProcessor;
import org.apereo.cas.pm.PasswordValidationService;
import org.apereo.cas.pm.web.PasswordManagementEndpoint;
import org.apereo.cas.pm.web.flow.PasswordManagementAccountProfileWebflowConfigurer;
import org.apereo.cas.pm.web.flow.PasswordManagementCaptchaWebflowConfigurer;
import org.apereo.cas.pm.web.flow.PasswordManagementMultifactorTrustWebflowConfigurer;
import org.apereo.cas.pm.web.flow.PasswordManagementSingleSignOnParticipationStrategy;
import org.apereo.cas.pm.web.flow.PasswordManagementWebflowConfigurer;
import org.apereo.cas.pm.web.flow.WeakPasswordWebflowExceptionHandler;
import org.apereo.cas.pm.web.flow.actions.AccountProfilePasswordChangeRequestAction;
import org.apereo.cas.pm.web.flow.actions.AccountProfilePreparePasswordManagementAction;
import org.apereo.cas.pm.web.flow.actions.AccountProfileUpdateSecurityQuestionsAction;
import org.apereo.cas.pm.web.flow.actions.AccountUnlockStatusAction;
import org.apereo.cas.pm.web.flow.actions.AccountUnlockStatusPrepareAction;
import org.apereo.cas.pm.web.flow.actions.HandlePasswordExpirationWarningMessagesAction;
import org.apereo.cas.pm.web.flow.actions.InitPasswordChangeAction;
import org.apereo.cas.pm.web.flow.actions.InitPasswordResetAction;
import org.apereo.cas.pm.web.flow.actions.PasswordChangeAction;
import org.apereo.cas.pm.web.flow.actions.SendPasswordResetInstructionsAction;
import org.apereo.cas.pm.web.flow.actions.ValidatePasswordResetTokenAction;
import org.apereo.cas.pm.web.flow.actions.VerifyPasswordResetRequestAction;
import org.apereo.cas.pm.web.flow.actions.VerifySecurityQuestionsAction;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.ServiceTicketGeneratorAuthority;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.CaptchaActivationStrategy;
import org.apereo.cas.web.CaptchaValidator;
import org.apereo.cas.web.DefaultCaptchaActivationStrategy;
import org.apereo.cas.web.flow.CasFlowHandlerAdapter;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlan;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.InitializeCaptchaAction;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategyConfigurer;
import org.apereo.cas.web.flow.ValidateCaptchaAction;
import org.apereo.cas.web.flow.actions.StaticEventExecutionAction;
import org.apereo.cas.web.flow.actions.WebflowActionBeanSupplier;
import org.apereo.cas.web.flow.authentication.CasWebflowExceptionHandler;
import org.apereo.cas.web.flow.configurer.CasMultifactorWebflowCustomizer;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.executor.FlowExecutor;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Configuration(value="PasswordManagementWebflowConfiguration", proxyBeanMethods=false)
class PasswordManagementWebflowConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PasswordManagementWebflowConfiguration.class);

    PasswordManagementWebflowConfiguration() {
    }

    @ConditionalOnClass(value={MultifactorAuthnTrustConfiguration.class})
    @Configuration(value="PasswordManagementMultifactorTrustConfiguration", proxyBeanMethods=false)
    @DependsOn(value={"passwordManagementWebflowConfigurer"})
    @ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.MultifactorAuthenticationTrustedDevices})
    public static class PasswordManagementMultifactorTrustConfiguration {
        @ConditionalOnMissingBean(name={"passwordManagementMfaTrustWebflowConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowConfigurer passwordManagementMfaTrustWebflowConfigurer(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="flowDefinitionRegistry") FlowDefinitionRegistry flowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
            return new PasswordManagementMultifactorTrustWebflowConfigurer(flowBuilderServices, flowDefinitionRegistry, applicationContext, casProperties);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"passwordManagementMfaTrustWebflowExecutionPlanConfigurer"})
        public CasWebflowExecutionPlanConfigurer passwordManagementMfaTrustWebflowExecutionPlanConfigurer(@Qualifier(value="passwordManagementMfaTrustWebflowConfigurer") CasWebflowConfigurer passwordManagementMfaTrustWebflowConfigurer) {
            return plan -> plan.registerWebflowConfigurer(passwordManagementMfaTrustWebflowConfigurer);
        }
    }

    @Configuration(value="PasswordManagementEndpointsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class PasswordManagementEndpointsConfiguration {
        PasswordManagementEndpointsConfiguration() {
        }

        @Bean
        @ConditionalOnAvailableEndpoint
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PasswordManagementEndpoint passwordManagementEndpoint(@Qualifier(value="webApplicationServiceFactory") ObjectProvider<ServiceFactory<WebApplicationService>> webApplicationServiceFactory, @Qualifier(value="servicesManager") ObjectProvider<ServicesManager> servicesManager, @Qualifier(value="defaultAuthenticationSystemSupport") ObjectProvider<AuthenticationSystemSupport> authenticationSystemSupport, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="passwordChangeService") ObjectProvider<PasswordManagementService> passwordManagementService, @Qualifier(value="defaultPrincipalResolver") ObjectProvider<PrincipalResolver> defaultPrincipalResolver, @Qualifier(value="communicationsManager") ObjectProvider<CommunicationsManager> communicationsManager, @Qualifier(value="passwordResetUrlBuilder") ObjectProvider<PasswordResetUrlBuilder> passwordResetUrlBuilder, @Qualifier(value="registeredServiceAccessStrategyEnforcer") ObjectProvider<AuditableExecution> registeredServiceAccessStrategyEnforcer) {
            return new PasswordManagementEndpoint(casProperties, applicationContext, communicationsManager, passwordManagementService, passwordResetUrlBuilder, webApplicationServiceFactory, servicesManager, defaultPrincipalResolver, authenticationSystemSupport, registeredServiceAccessStrategyEnforcer);
        }
    }

    @Configuration(value="PasswordManagementAccountProfileConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.AccountManagement}, enabledByDefault=false)
    static class PasswordManagementAccountProfileConfiguration {
        PasswordManagementAccountProfileConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"accountProfileServiceTicketGeneratorAuthority"})
        public ServiceTicketGeneratorAuthority accountProfileServiceTicketGeneratorAuthority(CasConfigurationProperties casProperties) {
            return new AccountProfileServiceTicketGeneratorAuthority(casProperties);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"accountProfileUpdateSecurityQuestionsAction"})
        public Action accountProfileUpdateSecurityQuestionsAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="passwordChangeService") PasswordManagementService passwordManagementService) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new AccountProfileUpdateSecurityQuestionsAction(passwordManagementService, casProperties)).withId("accountProfileUpdateSecurityQuestionsAction").build().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"accountProfilePasswordChangeRequestAction"})
        public Action accountProfilePasswordChangeRequestAction(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="passwordResetUrlBuilder") PasswordResetUrlBuilder passwordResetUrlBuilder) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new AccountProfilePasswordChangeRequestAction(ticketRegistry, passwordResetUrlBuilder)).withId("accountProfilePasswordChangeRequestAction").build().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"prepareAccountProfilePasswordMgmtAction"})
        public Action prepareAccountProfilePasswordMgmtAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="passwordChangeService") PasswordManagementService passwordManagementService) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new AccountProfilePreparePasswordManagementAction(passwordManagementService, casProperties)).withId("prepareAccountProfilePasswordMgmtAction").build().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"passwordManagementAccountProfileWebflowConfigurer"})
        @DependsOn(value={"accountProfileWebflowConfigurer"})
        public CasWebflowConfigurer passwordManagementAccountProfileWebflowConfigurer(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="flowDefinitionRegistry") FlowDefinitionRegistry flowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
            return new PasswordManagementAccountProfileWebflowConfigurer(flowBuilderServices, flowDefinitionRegistry, applicationContext, casProperties);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"passwordManagementAccountProfileWebflowExecutionPlanConfigurer"})
        public CasWebflowExecutionPlanConfigurer passwordManagementAccountProfileWebflowExecutionPlanConfigurer(@Qualifier(value="passwordManagementAccountProfileWebflowConfigurer") CasWebflowConfigurer passwordManagementAccountProfileWebflowConfigurer) {
            return plan -> plan.registerWebflowConfigurer(passwordManagementAccountProfileWebflowConfigurer);
        }
    }

    @Configuration(value="PasswordManagementCaptchaConfiguration", proxyBeanMethods=false)
    @ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.PasswordManagement}, module="captcha")
    static class PasswordManagementCaptchaConfiguration {
        private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.authn.pm.google-recaptcha.enabled").isTrue();

        PasswordManagementCaptchaConfiguration() {
        }

        @ConditionalOnMissingBean(name={"passwordManagementCaptchaWebflowConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public CasWebflowConfigurer passwordManagementCaptchaWebflowConfigurer(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="flowDefinitionRegistry") FlowDefinitionRegistry flowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
            return (CasWebflowConfigurer)BeanSupplier.of(CasWebflowConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                PasswordManagementCaptchaWebflowConfigurer configurer = new PasswordManagementCaptchaWebflowConfigurer(flowBuilderServices, flowDefinitionRegistry, applicationContext, casProperties);
                configurer.setOrder(casProperties.getAuthn().getPm().getWebflow().getOrder() + 1);
                return configurer;
            }).otherwiseProxy().get();
        }

        @ConditionalOnMissingBean(name={"passwordResetValidateCaptchaAction"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public Action passwordResetValidateCaptchaAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="passwordResetCaptchaActivationStrategy") CaptchaActivationStrategy passwordResetCaptchaActivationStrategy) {
            return (Action)BeanSupplier.of(Action.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                GoogleRecaptchaProperties recaptcha = casProperties.getAuthn().getPm().getGoogleRecaptcha();
                return new ValidateCaptchaAction(CaptchaValidator.getInstance((GoogleRecaptchaProperties)recaptcha), passwordResetCaptchaActivationStrategy);
            }).otherwiseProxy().get();
        }

        @Bean
        @ConditionalOnMissingBean(name={"passwordResetCaptchaActivationStrategy"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CaptchaActivationStrategy passwordResetCaptchaActivationStrategy(ConfigurableApplicationContext applicationContext, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return (CaptchaActivationStrategy)BeanSupplier.of(CaptchaActivationStrategy.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new DefaultCaptchaActivationStrategy(servicesManager)).otherwiseProxy().get();
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"passwordResetInitializeCaptchaAction"})
        public Action passwordResetInitializeCaptchaAction(ConfigurableApplicationContext applicationContext, @Qualifier(value="passwordResetCaptchaActivationStrategy") CaptchaActivationStrategy passwordResetCaptchaActivationStrategy, CasConfigurationProperties casProperties) {
            return (Action)BeanSupplier.of(Action.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                GoogleRecaptchaProperties recaptcha = casProperties.getAuthn().getPm().getGoogleRecaptcha();
                return new InitializeCaptchaAction(passwordResetCaptchaActivationStrategy, requestContext -> WebUtils.putRecaptchaPasswordManagementEnabled((RequestContext)requestContext, (GoogleRecaptchaProperties)recaptcha), recaptcha);
            }).otherwiseProxy().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"passwordManagementCaptchaWebflowExecutionPlanConfigurer"})
        public CasWebflowExecutionPlanConfigurer passwordManagementCaptchaWebflowExecutionPlanConfigurer(ConfigurableApplicationContext applicationContext, @Qualifier(value="passwordManagementCaptchaWebflowConfigurer") CasWebflowConfigurer cfg) {
            return (CasWebflowExecutionPlanConfigurer)BeanSupplier.of(CasWebflowExecutionPlanConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> plan.registerWebflowConfigurer(cfg)).otherwiseProxy().get();
        }
    }

    @Configuration(value="PasswordManagementPolicyConfiguration", proxyBeanMethods=false)
    static class PasswordManagementPolicyConfiguration {
        private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.authn.pm.core.password-policy-pattern");

        PasswordManagementPolicyConfiguration() {
        }

        @ConditionalOnMissingBean(name={"passwordStrengthAuthenticationPostProcessor"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationPostProcessor passwordStrengthAuthenticationPostProcessor(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="passwordValidationService") PasswordValidationService passwordValidationService) {
            return (AuthenticationPostProcessor)BeanSupplier.of(AuthenticationPostProcessor.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new PasswordStrengthAuthenticationPostProcessor(passwordValidationService)).otherwiseProxy().get();
        }

        @ConditionalOnMissingBean(name={"passwordManagementAuthenticationExecutionPlanConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationEventExecutionPlanConfigurer passwordManagementAuthenticationExecutionPlanConfigurer(@Qualifier(value="passwordStrengthAuthenticationPostProcessor") AuthenticationPostProcessor passwordStrengthAuthenticationPostProcessor, ConfigurableApplicationContext applicationContext) {
            return (AuthenticationEventExecutionPlanConfigurer)BeanSupplier.of(AuthenticationEventExecutionPlanConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> plan.registerAuthenticationPostProcessor(passwordStrengthAuthenticationPostProcessor)).otherwiseProxy().get();
        }

        @ConditionalOnMissingBean(name={"weakPasswordWebflowExceptionHandler"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowExceptionHandler weakPasswordWebflowExceptionHandler(ConfigurableApplicationContext applicationContext) {
            return (CasWebflowExceptionHandler)BeanSupplier.of(CasWebflowExceptionHandler.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(WeakPasswordWebflowExceptionHandler::new).otherwiseProxy().get();
        }
    }

    @Configuration(value="PasswordManagementWebflowActionsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class PasswordManagementWebflowActionsConfiguration {
        PasswordManagementWebflowActionsConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"accountUnlockStatusPrepareAction"})
        public Action accountUnlockStatusPrepareAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> (Action)BeanSupplier.of(Action.class).alwaysMatch().supply(AccountUnlockStatusPrepareAction::new).get()).withId("accountUnlockStatusPrepareAction").build().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"accountUnlockStatusAction"})
        public Action accountUnlockStatusAction(@Qualifier(value="passwordChangeService") PasswordManagementService passwordManagementService, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> (Action)BeanSupplier.of(Action.class).alwaysMatch().supply(() -> new AccountUnlockStatusAction(passwordManagementService)).get()).withId("accountUnlockStatusAction").build().get();
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"initPasswordChangeAction"})
        public Action initPasswordChangeAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> (Action)BeanSupplier.of(Action.class).alwaysMatch().supply(() -> new InitPasswordChangeAction(casProperties)).get()).withId("initPasswordChangeAction").build().get();
        }

        @ConditionalOnMissingBean(name={"initPasswordResetAction"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public Action initPasswordResetAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="defaultAuthenticationSystemSupport") AuthenticationSystemSupport authenticationSystemSupport, @Qualifier(value="passwordChangeService") PasswordManagementService passwordManagementService, @Qualifier(value="multifactorAuthenticationProviderSelector") MultifactorAuthenticationProviderSelector multifactorAuthenticationProviderSelector, @Qualifier(value="defaultPrincipalResolver") PrincipalResolver defaultPrincipalResolver, @Qualifier(value="authenticationContextValidator") MultifactorAuthenticationContextValidator multifactorAuthenticationContextValidator) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> (Action)BeanSupplier.of(Action.class).alwaysMatch().supply(() -> new InitPasswordResetAction(passwordManagementService, casProperties, defaultPrincipalResolver, multifactorAuthenticationProviderSelector, authenticationSystemSupport, multifactorAuthenticationContextValidator)).get()).withId("initPasswordResetAction").build().get();
        }

        @ConditionalOnMissingBean(name={"passwordChangeAction"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public Action passwordChangeAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="passwordChangeService") PasswordManagementService passwordManagementService, @Qualifier(value="passwordValidationService") PasswordValidationService passwordValidationService) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> (Action)BeanSupplier.of(Action.class).alwaysMatch().supply(() -> new PasswordChangeAction(passwordManagementService, passwordValidationService)).get()).withId("passwordChangeAction").build().get();
        }

        @ConditionalOnMissingBean(name={"sendPasswordResetInstructionsAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action sendPasswordResetInstructionsAction(@Qualifier(value="defaultAuthenticationSystemSupport") AuthenticationSystemSupport authenticationSystemSupport, @Qualifier(value="multifactorAuthenticationProviderSelector") MultifactorAuthenticationProviderSelector multifactorAuthenticationProviderSelector, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="passwordChangeService") PasswordManagementService passwordManagementService, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="defaultPrincipalResolver") PrincipalResolver defaultPrincipalResolver, @Qualifier(value="communicationsManager") CommunicationsManager communicationsManager, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="defaultTicketFactory") TicketFactory ticketFactory, @Qualifier(value="passwordResetUrlBuilder") PasswordResetUrlBuilder passwordResetUrlBuilder) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> (Action)BeanSupplier.of(Action.class).alwaysMatch().supply(() -> new SendPasswordResetInstructionsAction(casProperties, communicationsManager, passwordManagementService, ticketRegistry, ticketFactory, defaultPrincipalResolver, passwordResetUrlBuilder, multifactorAuthenticationProviderSelector, authenticationSystemSupport, servicesManager)).get()).withId("sendPasswordResetInstructionsAction").build().get();
        }

        @ConditionalOnMissingBean(name={"verifyPasswordResetRequestAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action verifyPasswordResetRequestAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="passwordChangeService") PasswordManagementService passwordManagementService, @Qualifier(value="defaultTicketRegistrySupport") TicketRegistrySupport ticketRegistrySupport) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> (Action)BeanSupplier.of(Action.class).alwaysMatch().supply(() -> new VerifyPasswordResetRequestAction(casProperties, passwordManagementService, ticketRegistrySupport)).get()).withId("verifyPasswordResetRequestAction").build().get();
        }

        @ConditionalOnMissingBean(name={"handlePasswordExpirationWarningMessagesAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action handlePasswordExpirationWarningMessagesAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(HandlePasswordExpirationWarningMessagesAction::new).withId("handlePasswordExpirationWarningMessagesAction").build().get();
        }

        @ConditionalOnMissingBean(name={"verifySecurityQuestionsAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action verifySecurityQuestionsAction(CasConfigurationProperties casProperties, @Qualifier(value="passwordChangeService") PasswordManagementService passwordManagementService) {
            if (!casProperties.getAuthn().getPm().getReset().isSecurityQuestionsEnabled()) {
                LOGGER.debug("Functionality to handle security questions for password management is not enabled");
                return new StaticEventExecutionAction("success");
            }
            return new VerifySecurityQuestionsAction(passwordManagementService);
        }

        @ConditionalOnMissingBean(name={"validatePasswordResetTokenAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action validatePasswordResetTokenAction(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="passwordChangeService") PasswordManagementService passwordManagementService) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> (Action)BeanSupplier.of(Action.class).alwaysMatch().supply(() -> new ValidatePasswordResetTokenAction(passwordManagementService, ticketRegistry)).get()).withId("validatePasswordResetTokenAction").build().get();
        }
    }

    @Configuration(value="PasswordManagementWebflowBaseConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class PasswordManagementWebflowBaseConfiguration {
        PasswordManagementWebflowBaseConfiguration() {
        }

        @ConditionalOnMissingBean(name={"passwordManagementWebflowConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowConfigurer passwordManagementWebflowConfigurer(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="flowDefinitionRegistry") FlowDefinitionRegistry flowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
            return new PasswordManagementWebflowConfigurer(flowBuilderServices, flowDefinitionRegistry, applicationContext, casProperties);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"passwordManagementCasWebflowExecutionPlanConfigurer"})
        public CasWebflowExecutionPlanConfigurer passwordManagementCasWebflowExecutionPlanConfigurer(@Qualifier(value="passwordManagementWebflowConfigurer") CasWebflowConfigurer passwordManagementWebflowConfigurer) {
            return plan -> plan.registerWebflowConfigurer(passwordManagementWebflowConfigurer);
        }

        @Bean
        @ConditionalOnMissingBean(name={"passwordManagementMultifactorWebflowCustomizer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasMultifactorWebflowCustomizer passwordManagementMultifactorWebflowCustomizer() {
            return new CasMultifactorWebflowCustomizer(this){

                public List<String> getWebflowAttributeMappings() {
                    return List.of("passwordManagementQuery", "passwordResetRequest", "authenticationResultBuilder", "authentication", "mfaDeviceRegistrationEnabled", "multifactorTrustedDevicesDisabled");
                }
            };
        }
    }

    @Configuration(value="PasswordManagementWebflowAdapterConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class PasswordManagementWebflowAdapterConfiguration {
        PasswordManagementWebflowAdapterConfiguration() {
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"passwordResetHandlerAdapter"})
        public HandlerAdapter passwordResetHandlerAdapter(ConfigurableApplicationContext applicationContext, @Qualifier(value="casWebflowExecutionPlan") CasWebflowExecutionPlan webflowExecutionPlan, @Qualifier(value="loginFlowExecutor") FlowExecutor loginFlowExecutor) {
            CasFlowHandlerAdapter handler = new CasFlowHandlerAdapter("pswdreset", webflowExecutionPlan);
            handler.setFlowExecutor(loginFlowExecutor);
            return handler;
        }
    }

    @Configuration(value="PasswordManagementWebflowSingleSignOnConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class PasswordManagementWebflowSingleSignOnConfiguration {
        PasswordManagementWebflowSingleSignOnConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"passwordManagementSingleSignOnParticipationStrategy"})
        public SingleSignOnParticipationStrategy passwordManagementSingleSignOnParticipationStrategy(@Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationServiceSelectionPlan, @Qualifier(value="defaultTicketRegistrySupport") TicketRegistrySupport ticketRegistrySupport, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new PasswordManagementSingleSignOnParticipationStrategy(servicesManager, ticketRegistrySupport, authenticationServiceSelectionPlan);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"passwordManagementSingleSignOnParticipationStrategyConfigurer"})
        public SingleSignOnParticipationStrategyConfigurer passwordManagementSingleSignOnParticipationStrategyConfigurer(@Qualifier(value="passwordManagementSingleSignOnParticipationStrategy") SingleSignOnParticipationStrategy passwordManagementSingleSignOnParticipationStrategy) {
            return chain -> chain.addStrategy(passwordManagementSingleSignOnParticipationStrategy);
        }
    }
}

