/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.openfga.client.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.syncope.ext.openfga.client.ApiClient;
import org.apache.syncope.ext.openfga.client.ApiException;
import org.apache.syncope.ext.openfga.client.ApiResponse;
import org.apache.syncope.ext.openfga.client.Configuration;
import org.apache.syncope.ext.openfga.client.model.ReadAssertionsResponse;
import org.apache.syncope.ext.openfga.client.model.WriteAssertionsRequest;

public class AssertionsApi {
    private final HttpClient memberVarHttpClient;
    private final ObjectMapper memberVarObjectMapper;
    private final String memberVarBaseUri;
    private final Consumer<HttpRequest.Builder> memberVarInterceptor;
    private final Duration memberVarReadTimeout;
    private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
    private final Consumer<HttpResponse<InputStream>> memberVarAsyncResponseInterceptor;

    public AssertionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AssertionsApi(ApiClient apiClient) {
        this.memberVarHttpClient = apiClient.getHttpClient();
        this.memberVarObjectMapper = apiClient.getObjectMapper();
        this.memberVarBaseUri = apiClient.getBaseUri();
        this.memberVarInterceptor = apiClient.getRequestInterceptor();
        this.memberVarReadTimeout = apiClient.getReadTimeout();
        this.memberVarResponseInterceptor = apiClient.getResponseInterceptor();
        this.memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ApiException getApiException(String operationId, HttpResponse<InputStream> response) throws IOException {
        String body = null;
        try (InputStream responseBody = ApiClient.getResponseBody(response);){
            body = responseBody == null ? null : new String(responseBody.readAllBytes());
        }
        String message = this.formatExceptionMessage(operationId, response.statusCode(), body);
        return new ApiException(response.statusCode(), message, response.headers(), body);
    }

    private String formatExceptionMessage(String operationId, int statusCode, String body) {
        if (body == null || body.isEmpty()) {
            body = "[no body]";
        }
        return operationId + " call failed with: " + statusCode + " - " + body;
    }

    public File downloadFileFromResponse(HttpResponse<InputStream> response, InputStream responseBody) throws ApiException {
        if (responseBody == null) {
            throw new ApiException(new IOException("Response body is empty"));
        }
        try {
            File file = this.prepareDownloadFile(response);
            Files.copy(responseBody, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return file;
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    private File prepareDownloadFile(HttpResponse<InputStream> response) throws IOException {
        Pattern pattern;
        Matcher matcher;
        String filename = null;
        Optional<String> contentDisposition = response.headers().firstValue("Content-Disposition");
        if (contentDisposition.isPresent() && !"".equals(contentDisposition.get()) && (matcher = (pattern = Pattern.compile("filename=['\"]?([^'\"\\s]+)['\"]?")).matcher(contentDisposition.get())).find()) {
            filename = matcher.group(1);
        }
        File file = null;
        if (filename != null) {
            Path tempDir = Files.createTempDirectory("swagger-gen-native", new FileAttribute[0]);
            Path filePath = Files.createFile(tempDir.resolve(filename), new FileAttribute[0]);
            file = filePath.toFile();
            tempDir.toFile().deleteOnExit();
            file.deleteOnExit();
        } else {
            file = Files.createTempFile("download-", "", new FileAttribute[0]).toFile();
            file.deleteOnExit();
        }
        return file;
    }

    public ReadAssertionsResponse readAssertions(@Nonnull String storeId, @Nonnull String authorizationModelId) throws ApiException {
        return this.readAssertions(storeId, authorizationModelId, null);
    }

    public ReadAssertionsResponse readAssertions(@Nonnull String storeId, @Nonnull String authorizationModelId, Map<String, String> headers) throws ApiException {
        ApiResponse<ReadAssertionsResponse> localVarResponse = this.readAssertionsWithHttpInfo(storeId, authorizationModelId, headers);
        return localVarResponse.getData();
    }

    public ApiResponse<ReadAssertionsResponse> readAssertionsWithHttpInfo(@Nonnull String storeId, @Nonnull String authorizationModelId) throws ApiException {
        return this.readAssertionsWithHttpInfo(storeId, authorizationModelId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ApiResponse<ReadAssertionsResponse> readAssertionsWithHttpInfo(@Nonnull String storeId, @Nonnull String authorizationModelId, Map<String, String> headers) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.readAssertionsRequestBuilder(storeId, authorizationModelId, headers);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            try (InputStream localVarResponseBody = null;){
                if (localVarResponse.statusCode() / 100 != 2) {
                    throw this.getApiException("readAssertions", localVarResponse);
                }
                localVarResponseBody = ApiClient.getResponseBody(localVarResponse);
                if (localVarResponseBody == null) {
                    ApiResponse<Object> apiResponse2 = new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
                    return apiResponse2;
                }
                String responseBody = new String(localVarResponseBody.readAllBytes());
                ReadAssertionsResponse responseValue = responseBody.isBlank() ? null : (ReadAssertionsResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<ReadAssertionsResponse>(this){});
                ApiResponse<ReadAssertionsResponse> apiResponse = new ApiResponse<ReadAssertionsResponse>(localVarResponse.statusCode(), localVarResponse.headers().map(), responseValue);
                return apiResponse;
            }
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder readAssertionsRequestBuilder(@Nonnull String storeId, @Nonnull String authorizationModelId, Map<String, String> headers) throws ApiException {
        if (storeId == null) {
            throw new ApiException(400, "Missing the required parameter 'storeId' when calling readAssertions");
        }
        if (authorizationModelId == null) {
            throw new ApiException(400, "Missing the required parameter 'authorizationModelId' when calling readAssertions");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/stores/{store_id}/assertions/{authorization_model_id}".replace("{store_id}", ApiClient.urlEncode(storeId.toString())).replace("{authorization_model_id}", ApiClient.urlEncode(authorizationModelId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public void writeAssertions(@Nonnull String storeId, @Nonnull String authorizationModelId, @Nonnull WriteAssertionsRequest body) throws ApiException {
        this.writeAssertions(storeId, authorizationModelId, body, null);
    }

    public void writeAssertions(@Nonnull String storeId, @Nonnull String authorizationModelId, @Nonnull WriteAssertionsRequest body, Map<String, String> headers) throws ApiException {
        this.writeAssertionsWithHttpInfo(storeId, authorizationModelId, body, headers);
    }

    public ApiResponse<Void> writeAssertionsWithHttpInfo(@Nonnull String storeId, @Nonnull String authorizationModelId, @Nonnull WriteAssertionsRequest body) throws ApiException {
        return this.writeAssertionsWithHttpInfo(storeId, authorizationModelId, body, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiResponse<Void> writeAssertionsWithHttpInfo(@Nonnull String storeId, @Nonnull String authorizationModelId, @Nonnull WriteAssertionsRequest body, Map<String, String> headers) throws ApiException {
        ApiResponse<Object> apiResponse;
        block10: {
            HttpRequest.Builder localVarRequestBuilder = this.writeAssertionsRequestBuilder(storeId, authorizationModelId, body, headers);
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            InputStream localVarResponseBody = null;
            try {
                if (localVarResponse.statusCode() / 100 != 2) {
                    throw this.getApiException("writeAssertions", localVarResponse);
                }
                localVarResponseBody = ApiClient.getResponseBody(localVarResponse);
                if (localVarResponseBody != null) {
                    localVarResponseBody.readAllBytes();
                }
                apiResponse = new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
                if (localVarResponseBody == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (localVarResponseBody != null) {
                        localVarResponseBody.close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ApiException(e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new ApiException(e);
                }
            }
            localVarResponseBody.close();
        }
        return apiResponse;
    }

    private HttpRequest.Builder writeAssertionsRequestBuilder(@Nonnull String storeId, @Nonnull String authorizationModelId, @Nonnull WriteAssertionsRequest body, Map<String, String> headers) throws ApiException {
        if (storeId == null) {
            throw new ApiException(400, "Missing the required parameter 'storeId' when calling writeAssertions");
        }
        if (authorizationModelId == null) {
            throw new ApiException(400, "Missing the required parameter 'authorizationModelId' when calling writeAssertions");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling writeAssertions");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/stores/{store_id}/assertions/{authorization_model_id}".replace("{store_id}", ApiClient.urlEncode(storeId.toString())).replace("{authorization_model_id}", ApiClient.urlEncode(authorizationModelId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)body);
            localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    private static class HttpRequestBuilderExtensions {
        private HttpRequestBuilderExtensions() {
        }

        static HttpRequest.Builder withAdditionalHeaders(HttpRequest.Builder builder, Map<String, String> headers) {
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    builder.header(entry.getKey(), entry.getValue());
                }
            }
            return builder;
        }
    }
}

