/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.to;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.ws.rs.PathParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.OrgUnit;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.types.ConnConfProperty;
import org.apache.syncope.common.lib.types.ConnectorCapability;
import org.apache.syncope.common.lib.types.TraceLevel;

public class ResourceTO
implements EntityTO {
    private static final long serialVersionUID = -9193551354041698963L;
    private String key;
    private String connector;
    private String connectorDisplayName;
    private final List<Provision> provisions = new ArrayList<Provision>();
    private OrgUnit orgUnit;
    private Integer propagationPriority;
    private boolean enforceMandatoryCondition;
    private TraceLevel createTraceLevel = TraceLevel.ALL;
    private TraceLevel updateTraceLevel = TraceLevel.ALL;
    private TraceLevel deleteTraceLevel = TraceLevel.ALL;
    private TraceLevel provisioningTraceLevel = TraceLevel.ALL;
    private String passwordPolicy;
    private String accountPolicy;
    private String propagationPolicy;
    private String inboundPolicy;
    private String pushPolicy;
    private String provisionSorter;
    private String authPolicy;
    private String accessPolicy;
    @JsonProperty
    private boolean confOverrideFlag = false;
    @JsonProperty
    private List<ConnConfProperty> confOverrideValue;
    @JsonProperty
    private boolean capabilitiesOverrideFlag = false;
    @JsonProperty
    private Set<ConnectorCapability> capabilitiesOverrideValue;
    private final List<String> propagationActions = new ArrayList<String>();

    public String getKey() {
        return this.key;
    }

    @PathParam(value="key")
    public void setKey(String key) {
        this.key = key;
    }

    public boolean isEnforceMandatoryCondition() {
        return this.enforceMandatoryCondition;
    }

    public void setEnforceMandatoryCondition(boolean enforceMandatoryCondition) {
        this.enforceMandatoryCondition = enforceMandatoryCondition;
    }

    public String getConnector() {
        return this.connector;
    }

    public void setConnector(String connector) {
        this.connector = connector;
    }

    public String getConnectorDisplayName() {
        return this.connectorDisplayName;
    }

    public void setConnectorDisplayName(String connectorDisplayName) {
        this.connectorDisplayName = connectorDisplayName;
    }

    public Integer getPropagationPriority() {
        return this.propagationPriority;
    }

    public void setPropagationPriority(Integer propagationPriority) {
        this.propagationPriority = propagationPriority;
    }

    public TraceLevel getCreateTraceLevel() {
        return this.createTraceLevel;
    }

    public void setCreateTraceLevel(TraceLevel createTraceLevel) {
        this.createTraceLevel = createTraceLevel;
    }

    public TraceLevel getUpdateTraceLevel() {
        return this.updateTraceLevel;
    }

    public void setUpdateTraceLevel(TraceLevel updateTraceLevel) {
        this.updateTraceLevel = updateTraceLevel;
    }

    public TraceLevel getDeleteTraceLevel() {
        return this.deleteTraceLevel;
    }

    public void setDeleteTraceLevel(TraceLevel deleteTraceLevel) {
        this.deleteTraceLevel = deleteTraceLevel;
    }

    public TraceLevel getProvisioningTraceLevel() {
        return this.provisioningTraceLevel;
    }

    public void setProvisioningTraceLevel(TraceLevel provisioningTraceLevel) {
        this.provisioningTraceLevel = provisioningTraceLevel;
    }

    public String getPasswordPolicy() {
        return this.passwordPolicy;
    }

    public void setPasswordPolicy(String passwordPolicy) {
        this.passwordPolicy = passwordPolicy;
    }

    public String getAccountPolicy() {
        return this.accountPolicy;
    }

    public void setAccountPolicy(String accountPolicy) {
        this.accountPolicy = accountPolicy;
    }

    public String getPropagationPolicy() {
        return this.propagationPolicy;
    }

    public void setPropagationPolicy(String propagationPolicy) {
        this.propagationPolicy = propagationPolicy;
    }

    public String getInboundPolicy() {
        return this.inboundPolicy;
    }

    public void setInboundPolicy(String inboundPolicy) {
        this.inboundPolicy = inboundPolicy;
    }

    public String getPushPolicy() {
        return this.pushPolicy;
    }

    public void setPushPolicy(String pushPolicy) {
        this.pushPolicy = pushPolicy;
    }

    public String getAuthPolicy() {
        return this.authPolicy;
    }

    public void setAuthPolicy(String authPolicy) {
        this.authPolicy = authPolicy;
    }

    public String getAccessPolicy() {
        return this.accessPolicy;
    }

    public void setAccessPolicy(String accessPolicy) {
        this.accessPolicy = accessPolicy;
    }

    public String getProvisionSorter() {
        return this.provisionSorter;
    }

    public void setProvisionSorter(String provisionSorter) {
        this.provisionSorter = provisionSorter;
    }

    @JsonIgnore
    public Optional<Provision> getProvision(String anyType) {
        return this.provisions.stream().filter(provision -> anyType != null && anyType.equals(provision.getAnyType())).findFirst();
    }

    public List<Provision> getProvisions() {
        return this.provisions;
    }

    public OrgUnit getOrgUnit() {
        return this.orgUnit;
    }

    public void setOrgUnit(OrgUnit orgUnit) {
        this.orgUnit = orgUnit;
    }

    @JsonIgnore
    public Optional<List<ConnConfProperty>> getConfOverride() {
        return this.confOverrideFlag ? Optional.ofNullable(this.confOverrideValue) : Optional.empty();
    }

    @JsonIgnore
    public void setConfOverride(Optional<List<ConnConfProperty>> confOverride) {
        if (confOverride == null || confOverride.isEmpty()) {
            this.confOverrideFlag = false;
            this.confOverrideValue = null;
        } else {
            this.confOverrideFlag = true;
            this.confOverrideValue = new ArrayList<ConnConfProperty>((Collection)confOverride.orElseThrow());
        }
    }

    @JsonIgnore
    public Optional<Set<ConnectorCapability>> getCapabilitiesOverride() {
        return this.capabilitiesOverrideFlag ? Optional.ofNullable(this.capabilitiesOverrideValue) : Optional.empty();
    }

    @JsonIgnore
    public void setCapabilitiesOverride(Optional<Set<ConnectorCapability>> capabilitiesOverride) {
        if (capabilitiesOverride == null || capabilitiesOverride.isEmpty()) {
            this.capabilitiesOverrideFlag = false;
            this.capabilitiesOverrideValue = null;
        } else {
            this.capabilitiesOverrideFlag = true;
            this.capabilitiesOverrideValue = new HashSet<ConnectorCapability>((Collection)capabilitiesOverride.orElseThrow());
        }
    }

    public List<String> getPropagationActions() {
        return this.propagationActions;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceTO other = (ResourceTO)obj;
        return new EqualsBuilder().append(this.enforceMandatoryCondition, other.enforceMandatoryCondition).append((Object)this.key, (Object)other.key).append((Object)this.connector, (Object)other.connector).append((Object)this.connectorDisplayName, (Object)other.connectorDisplayName).append(this.provisions, other.provisions).append((Object)this.orgUnit, (Object)other.orgUnit).append((Object)this.propagationPriority, (Object)other.propagationPriority).append((Object)this.createTraceLevel, (Object)other.createTraceLevel).append((Object)this.updateTraceLevel, (Object)other.updateTraceLevel).append((Object)this.deleteTraceLevel, (Object)other.deleteTraceLevel).append((Object)this.provisioningTraceLevel, (Object)other.provisioningTraceLevel).append((Object)this.passwordPolicy, (Object)other.passwordPolicy).append((Object)this.accountPolicy, (Object)other.accountPolicy).append((Object)this.propagationPolicy, (Object)other.propagationPolicy).append((Object)this.inboundPolicy, (Object)other.inboundPolicy).append((Object)this.pushPolicy, (Object)other.pushPolicy).append((Object)this.authPolicy, (Object)other.authPolicy).append((Object)this.accessPolicy, (Object)other.accessPolicy).append(this.confOverrideFlag, other.confOverrideFlag).append(this.confOverrideValue, other.confOverrideValue).append(this.capabilitiesOverrideFlag, other.capabilitiesOverrideFlag).append(this.capabilitiesOverrideValue, other.capabilitiesOverrideValue).append(this.propagationActions, other.propagationActions).append((Object)this.provisionSorter, (Object)other.provisionSorter).build();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.key).append((Object)this.connector).append((Object)this.connectorDisplayName).append(this.provisions).append((Object)this.orgUnit).append((Object)this.propagationPriority).append(this.enforceMandatoryCondition).append((Object)this.createTraceLevel).append((Object)this.updateTraceLevel).append((Object)this.deleteTraceLevel).append((Object)this.provisioningTraceLevel).append((Object)this.passwordPolicy).append((Object)this.accountPolicy).append((Object)this.propagationPolicy).append((Object)this.inboundPolicy).append((Object)this.pushPolicy).append((Object)this.authPolicy).append((Object)this.accessPolicy).append(this.confOverrideFlag).append(this.confOverrideValue).append(this.capabilitiesOverrideFlag).append(this.capabilitiesOverrideValue).append(this.propagationActions).append((Object)this.provisionSorter).build();
    }
}

