/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hunspell;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.Operations;

class TrigramAutomaton {
    private static final int N = 3;
    private final CharacterRunAutomaton automaton;
    private final int[] state2Score;
    private final FixedBitSet countedSubstrings;
    private final char minChar;
    private final char maxChar;

    TrigramAutomaton(String s1) {
        int state;
        HashMap<String, Integer> substringCounts = new HashMap<String, Integer>();
        Automaton.Builder builder = new Automaton.Builder(s1.length() * 3, s1.length() * 3);
        int initialState = builder.createState();
        this.minChar = (char)s1.chars().min().orElseThrow();
        this.maxChar = (char)s1.chars().max().orElseThrow();
        for (int start = 0; start < s1.length(); ++start) {
            int limit = Math.min(s1.length(), start + 3);
            for (int end = start + 1; end <= limit; ++end) {
                substringCounts.merge(s1.substring(start, end), 1, Integer::sum);
            }
            state = initialState;
            for (int i = start; i < limit; ++i) {
                int next = builder.createState();
                builder.addTransition(state, next, s1.charAt(i) - this.minChar);
                state = next;
            }
        }
        this.automaton = new CharacterRunAutomaton(Operations.determinize(builder.finish(), 10000));
        this.state2Score = new int[this.automaton.getSize()];
        for (Map.Entry entry : substringCounts.entrySet()) {
            state = this.runAutomatonOnStringChars((String)entry.getKey());
            assert (this.state2Score[state] == 0);
            this.state2Score[state] = (Integer)entry.getValue();
        }
        this.countedSubstrings = new FixedBitSet(this.state2Score.length);
    }

    private int runAutomatonOnStringChars(String s) {
        int state = 0;
        for (int i = 0; i < s.length(); ++i) {
            state = this.automaton.step(state, s.charAt(i) - this.minChar);
        }
        return state;
    }

    int ngramScore(CharsRef s2) {
        this.countedSubstrings.clear();
        int score = 0;
        int state1 = -1;
        int state2 = -1;
        int limit = s2.length + s2.offset;
        for (int i = s2.offset; i < limit; ++i) {
            int state3;
            char c = this.transformChar(s2.chars[i]);
            if (c < this.minChar || c > this.maxChar) {
                state2 = -1;
                state1 = -1;
                continue;
            }
            c = (char)(c - this.minChar);
            int n = state3 = state2 <= 0 ? 0 : this.automaton.step(state2, c);
            if (state3 > 0) {
                score += this.substringScore(state3, this.countedSubstrings);
            }
            int n2 = state2 = state1 <= 0 ? 0 : this.automaton.step(state1, c);
            if (state2 > 0) {
                score += this.substringScore(state2, this.countedSubstrings);
            }
            if ((state1 = this.automaton.step(0, c)) <= 0) continue;
            score += this.substringScore(state1, this.countedSubstrings);
        }
        return score;
    }

    char transformChar(char c) {
        return c;
    }

    private int substringScore(int state, FixedBitSet countedSubstrings) {
        if (countedSubstrings.getAndSet(state)) {
            return 0;
        }
        int score = this.state2Score[state];
        assert (score > 0);
        return score;
    }
}

