/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Period;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import org.hsqldb.HsqlException;
import org.hsqldb.jdbc.JDBCArray;
import org.hsqldb.jdbc.JDBCBlobClient;
import org.hsqldb.jdbc.JDBCClobClient;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCPreparedStatement;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class JDBCCallableStatement
extends JDBCPreparedStatement
implements CallableStatement {
    private IntValueHashMap<String> parameterNameMap = new IntValueHashMap();
    private boolean wasNullValue;

    @Override
    public synchronized void registerOutParameter(int n, int n2) throws SQLException {
        this.checkGetParameterIndex(n);
        if (this.parameterModes[--n] == 1) {
            throw JDBCUtil.invalidArgument();
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.resultIn.mode == 43 && this.resultIn.getChainedResult() != null) {
            this.getMoreResults();
        }
        return super.getResultSet();
    }

    @Override
    public synchronized void registerOutParameter(int n, int n2, int n3) throws SQLException {
        this.registerOutParameter(n, n2);
    }

    @Override
    public synchronized boolean wasNull() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return this.wasNullValue;
    }

    @Override
    public synchronized String getString(int n) throws SQLException {
        return (String)this.getColumnInType(n, Type.SQL_VARCHAR);
    }

    @Override
    public synchronized boolean getBoolean(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_BOOLEAN);
        return object != null && (Boolean)object != false;
    }

    @Override
    public synchronized byte getByte(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.TINYINT);
        return object == null ? (byte)0 : ((Number)object).byteValue();
    }

    @Override
    public synchronized short getShort(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_SMALLINT);
        return object == null ? (short)0 : ((Number)object).shortValue();
    }

    @Override
    public synchronized int getInt(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_INTEGER);
        return object == null ? 0 : ((Number)object).intValue();
    }

    @Override
    public synchronized long getLong(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_BIGINT);
        return object == null ? 0L : ((Number)object).longValue();
    }

    @Override
    public synchronized float getFloat(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_DOUBLE);
        return object == null ? 0.0f : ((Number)object).floatValue();
    }

    @Override
    public synchronized double getDouble(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_DOUBLE);
        return object == null ? 0.0 : ((Number)object).doubleValue();
    }

    @Override
    @Deprecated
    public synchronized BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (n2 < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
        BigDecimal bigDecimal = this.getBigDecimal(n);
        if (bigDecimal != null) {
            bigDecimal = bigDecimal.setScale(n2, RoundingMode.DOWN);
        }
        return bigDecimal;
    }

    @Override
    public synchronized byte[] getBytes(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_VARBINARY);
        if (object == null) {
            return null;
        }
        return ((BinaryData)object).getBytes();
    }

    @Override
    public synchronized Date getDate(int n) throws SQLException {
        TimestampData timestampData = (TimestampData)this.getColumnInType(n, Type.SQL_DATE);
        if (timestampData == null) {
            return null;
        }
        return (Date)Type.SQL_DATE.convertSQLToJava(this.session, timestampData);
    }

    @Override
    public synchronized Time getTime(int n) throws SQLException {
        TimeData timeData = (TimeData)this.getColumnInType(n, Type.SQL_TIME);
        if (timeData == null) {
            return null;
        }
        return (Time)Type.SQL_TIME.convertSQLToJava(this.session, timeData);
    }

    @Override
    public synchronized Timestamp getTimestamp(int n) throws SQLException {
        Object object = this.getColumnValue(n);
        if (object == null) {
            return null;
        }
        if (this.parameterTypes[n - 1].typeCode == 95) {
            TimestampData timestampData = (TimestampData)object;
            Timestamp timestamp = new Timestamp(timestampData.getMillis());
            timestamp.setNanos(timestampData.getNanos());
            return timestamp;
        }
        TimestampData timestampData = (TimestampData)this.getColumnInType(n, Type.SQL_TIMESTAMP);
        return (Timestamp)Type.SQL_TIMESTAMP.convertSQLToJava(this.session, timestampData);
    }

    @Override
    public synchronized Object getObject(int n) throws SQLException {
        this.checkGetParameterIndex(n);
        Type type = this.parameterTypes[n - 1];
        switch (type.typeCode) {
            case 50: {
                return this.getArray(n);
            }
            case 91: {
                return this.getDate(n);
            }
            case 92: {
                return this.getTime(n);
            }
            case 94: {
                return this.getTimeWithZone(n);
            }
            case 93: {
                return this.getTimestamp(n);
            }
            case 95: {
                return this.getTimestampWithZone(n);
            }
            case 60: 
            case 61: {
                return this.getBytes(n);
            }
            case 14: {
                boolean bl = this.getBoolean(n);
                return this.wasNull() ? null : (bl ? Boolean.TRUE : Boolean.FALSE);
            }
            case 40: {
                return this.getClob(n);
            }
            case 30: {
                return this.getBlob(n);
            }
            case 1111: 
            case 2000: {
                Object object = this.getColumnInType(n, type);
                if (object == null) {
                    return null;
                }
                try {
                    return ((JavaObjectData)object).getObject();
                }
                catch (HsqlException hsqlException) {
                    throw JDBCUtil.sqlException(hsqlException);
                }
            }
        }
        return this.getColumnInType(n, type);
    }

    @Override
    public synchronized BigDecimal getBigDecimal(int n) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        Type type = this.parameterMetaData.columnTypes[n - 1];
        switch (type.typeCode) {
            case 2: 
            case 3: {
                break;
            }
            case -6: 
            case 4: 
            case 5: 
            case 25: {
                type = Type.SQL_DECIMAL;
                break;
            }
            default: {
                type = Type.SQL_DECIMAL_DEFAULT;
            }
        }
        return (BigDecimal)this.getColumnInType(n, type);
    }

    @Override
    public Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
        this.checkGetParameterIndex(n);
        throw JDBCUtil.notSupported();
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        this.checkGetParameterIndex(n);
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized Blob getBlob(int n) throws SQLException {
        this.checkGetParameterIndex(n);
        Type type = this.parameterMetaData.columnTypes[n - 1];
        Object object = this.getColumnInType(n, type);
        if (object == null) {
            return null;
        }
        if (object instanceof BlobDataID) {
            return new JDBCBlobClient(this.session, (BlobDataID)object);
        }
        throw JDBCUtil.sqlException(5561);
    }

    @Override
    public synchronized Clob getClob(int n) throws SQLException {
        this.checkGetParameterIndex(n);
        Type type = this.parameterMetaData.columnTypes[n - 1];
        Object object = this.getColumnInType(n, type);
        if (object == null) {
            return null;
        }
        if (object instanceof ClobDataID) {
            return new JDBCClobClient(this.session, (ClobDataID)object);
        }
        throw JDBCUtil.sqlException(5561);
    }

    @Override
    public Array getArray(int n) throws SQLException {
        this.checkGetParameterIndex(n);
        Type type = this.parameterMetaData.columnTypes[n - 1];
        if (!type.isArrayType()) {
            throw JDBCUtil.sqlException(5561);
        }
        Object[] objectArray = (Object[])this.parameterValues[n - 1];
        if (objectArray == null) {
            return null;
        }
        return new JDBCArray(objectArray, type.collectionBaseType(), type, this.connection);
    }

    @Override
    public synchronized Date getDate(int n, Calendar calendar) throws SQLException {
        TimestampData timestampData = (TimestampData)this.getColumnInType(n, Type.SQL_DATE);
        if (timestampData == null) {
            return null;
        }
        return (Date)Type.SQL_DATE.convertSQLToJava(this.session, timestampData, calendar);
    }

    @Override
    public synchronized Time getTime(int n, Calendar calendar) throws SQLException {
        Object object = this.getColumnValue(n);
        if (object == null) {
            return null;
        }
        return (Time)Type.SQL_TIME.convertSQLToJava(this.session, object, calendar);
    }

    @Override
    public synchronized Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        Object object = this.getColumnValue(n);
        if (object == null) {
            return null;
        }
        if (this.parameterTypes[n - 1].typeCode == 95) {
            TimestampData timestampData = (TimestampData)object;
            Timestamp timestamp = new Timestamp(timestampData.getMillis());
            timestamp.setNanos(timestampData.getNanos());
            return timestamp;
        }
        TimestampData timestampData = (TimestampData)this.getColumnInType(n, Type.SQL_TIMESTAMP);
        return (Timestamp)Type.SQL_TIMESTAMP.convertSQLToJava(this.session, timestampData, calendar);
    }

    @Override
    public synchronized void registerOutParameter(int n, int n2, String string) throws SQLException {
        this.registerOutParameter(n, n2);
    }

    @Override
    public synchronized void registerOutParameter(String string, int n) throws SQLException {
        this.registerOutParameter(this.findParameterIndex(string), n);
    }

    @Override
    public synchronized void registerOutParameter(String string, int n, int n2) throws SQLException {
        this.registerOutParameter(this.findParameterIndex(string), n);
    }

    @Override
    public synchronized void registerOutParameter(String string, int n, String string2) throws SQLException {
        this.registerOutParameter(this.findParameterIndex(string), n);
    }

    @Override
    public URL getURL(int n) throws SQLException {
        this.checkGetParameterIndex(n);
        throw JDBCUtil.notSupported();
    }

    @Override
    public void setURL(String string, URL uRL) throws SQLException {
        this.setURL(this.findParameterIndex(string), uRL);
    }

    @Override
    public synchronized void setNull(String string, int n) throws SQLException {
        this.setNull(this.findParameterIndex(string), n);
    }

    @Override
    public synchronized void setBoolean(String string, boolean bl) throws SQLException {
        this.setBoolean(this.findParameterIndex(string), bl);
    }

    @Override
    public synchronized void setByte(String string, byte by) throws SQLException {
        this.setByte(this.findParameterIndex(string), by);
    }

    @Override
    public synchronized void setShort(String string, short s) throws SQLException {
        this.setShort(this.findParameterIndex(string), s);
    }

    @Override
    public synchronized void setInt(String string, int n) throws SQLException {
        this.setInt(this.findParameterIndex(string), n);
    }

    @Override
    public synchronized void setLong(String string, long l) throws SQLException {
        this.setLong(this.findParameterIndex(string), l);
    }

    @Override
    public synchronized void setFloat(String string, float f) throws SQLException {
        this.setFloat(this.findParameterIndex(string), f);
    }

    @Override
    public synchronized void setDouble(String string, double d) throws SQLException {
        this.setDouble(this.findParameterIndex(string), d);
    }

    @Override
    public synchronized void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.setBigDecimal(this.findParameterIndex(string), bigDecimal);
    }

    @Override
    public synchronized void setString(String string, String string2) throws SQLException {
        this.setString(this.findParameterIndex(string), string2);
    }

    @Override
    public synchronized void setBytes(String string, byte[] byArray) throws SQLException {
        this.setBytes(this.findParameterIndex(string), byArray);
    }

    @Override
    public synchronized void setDate(String string, Date date) throws SQLException {
        this.setDate(this.findParameterIndex(string), date);
    }

    @Override
    public synchronized void setTime(String string, Time time) throws SQLException {
        this.setTime(this.findParameterIndex(string), time);
    }

    @Override
    public synchronized void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.setTimestamp(this.findParameterIndex(string), timestamp);
    }

    @Override
    public synchronized void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.setAsciiStream(this.findParameterIndex(string), inputStream, n);
    }

    @Override
    public synchronized void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.setBinaryStream(this.findParameterIndex(string), inputStream, n);
    }

    @Override
    public synchronized void setObject(String string, Object object, int n, int n2) throws SQLException {
        this.setObject(this.findParameterIndex(string), object, n, n2);
    }

    @Override
    public synchronized void setObject(String string, Object object, int n) throws SQLException {
        this.setObject(this.findParameterIndex(string), object, n);
    }

    @Override
    public synchronized void setObject(String string, Object object) throws SQLException {
        this.setObject(this.findParameterIndex(string), object);
    }

    @Override
    public synchronized void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.setCharacterStream(this.findParameterIndex(string), reader, n);
    }

    @Override
    public synchronized void setDate(String string, Date date, Calendar calendar) throws SQLException {
        this.setDate(this.findParameterIndex(string), date, calendar);
    }

    @Override
    public synchronized void setTime(String string, Time time, Calendar calendar) throws SQLException {
        this.setTime(this.findParameterIndex(string), time, calendar);
    }

    @Override
    public synchronized void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTimestamp(this.findParameterIndex(string), timestamp, calendar);
    }

    @Override
    public synchronized void setNull(String string, int n, String string2) throws SQLException {
        this.setNull(this.findParameterIndex(string), n, string2);
    }

    @Override
    public synchronized String getString(String string) throws SQLException {
        return this.getString(this.findParameterIndex(string));
    }

    @Override
    public synchronized boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findParameterIndex(string));
    }

    @Override
    public synchronized byte getByte(String string) throws SQLException {
        return this.getByte(this.findParameterIndex(string));
    }

    @Override
    public synchronized short getShort(String string) throws SQLException {
        return this.getShort(this.findParameterIndex(string));
    }

    @Override
    public synchronized int getInt(String string) throws SQLException {
        return this.getInt(this.findParameterIndex(string));
    }

    @Override
    public synchronized long getLong(String string) throws SQLException {
        return this.getLong(this.findParameterIndex(string));
    }

    @Override
    public synchronized float getFloat(String string) throws SQLException {
        return this.getFloat(this.findParameterIndex(string));
    }

    @Override
    public synchronized double getDouble(String string) throws SQLException {
        return this.getDouble(this.findParameterIndex(string));
    }

    @Override
    public synchronized byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findParameterIndex(string));
    }

    @Override
    public synchronized Date getDate(String string) throws SQLException {
        return this.getDate(this.findParameterIndex(string));
    }

    @Override
    public synchronized Time getTime(String string) throws SQLException {
        return this.getTime(this.findParameterIndex(string));
    }

    @Override
    public synchronized Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findParameterIndex(string));
    }

    @Override
    public synchronized Object getObject(String string) throws SQLException {
        return this.getObject(this.findParameterIndex(string));
    }

    @Override
    public synchronized BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findParameterIndex(string));
    }

    @Override
    public synchronized Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findParameterIndex(string), map);
    }

    @Override
    public synchronized Ref getRef(String string) throws SQLException {
        return this.getRef(this.findParameterIndex(string));
    }

    @Override
    public synchronized Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findParameterIndex(string));
    }

    @Override
    public synchronized Clob getClob(String string) throws SQLException {
        return this.getClob(this.findParameterIndex(string));
    }

    @Override
    public synchronized Array getArray(String string) throws SQLException {
        return this.getArray(this.findParameterIndex(string));
    }

    @Override
    public synchronized Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findParameterIndex(string), calendar);
    }

    @Override
    public synchronized Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findParameterIndex(string), calendar);
    }

    @Override
    public synchronized Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findParameterIndex(string), calendar);
    }

    @Override
    public URL getURL(String string) throws SQLException {
        return this.getURL(this.findParameterIndex(string));
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        this.checkGetParameterIndex(n);
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized RowId getRowId(String string) throws SQLException {
        return this.getRowId(this.findParameterIndex(string));
    }

    @Override
    public synchronized void setRowId(String string, RowId rowId) throws SQLException {
        super.setRowId(this.findParameterIndex(string), rowId);
    }

    @Override
    public synchronized void setNString(String string, String string2) throws SQLException {
        super.setNString(this.findParameterIndex(string), string2);
    }

    @Override
    public synchronized void setNCharacterStream(String string, Reader reader, long l) throws SQLException {
        super.setNCharacterStream(this.findParameterIndex(string), reader, l);
    }

    @Override
    public synchronized void setNClob(String string, NClob nClob) throws SQLException {
        super.setNClob(this.findParameterIndex(string), nClob);
    }

    @Override
    public synchronized void setClob(String string, Reader reader, long l) throws SQLException {
        super.setClob(this.findParameterIndex(string), reader, l);
    }

    @Override
    public synchronized void setBlob(String string, InputStream inputStream, long l) throws SQLException {
        super.setBlob(this.findParameterIndex(string), inputStream, l);
    }

    @Override
    public synchronized void setNClob(String string, Reader reader, long l) throws SQLException {
        super.setNClob(this.findParameterIndex(string), reader, l);
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        this.checkGetParameterIndex(n);
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized NClob getNClob(String string) throws SQLException {
        return this.getNClob(this.findParameterIndex(string));
    }

    @Override
    public synchronized void setSQLXML(String string, SQLXML sQLXML) throws SQLException {
        super.setSQLXML(this.findParameterIndex(string), sQLXML);
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        this.checkGetParameterIndex(n);
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized SQLXML getSQLXML(String string) throws SQLException {
        return this.getSQLXML(this.findParameterIndex(string));
    }

    @Override
    public String getNString(int n) throws SQLException {
        this.checkGetParameterIndex(n);
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized String getNString(String string) throws SQLException {
        return this.getNString(this.findParameterIndex(string));
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        this.checkGetParameterIndex(n);
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized Reader getNCharacterStream(String string) throws SQLException {
        return this.getNCharacterStream(this.findParameterIndex(string));
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        this.checkGetParameterIndex(n);
        Type type = this.parameterMetaData.columnTypes[n - 1];
        Object object = this.getColumnInType(n, type);
        if (object == null) {
            return null;
        }
        if (object instanceof ClobDataID) {
            return ((ClobDataID)object).getCharacterStream(this.session);
        }
        if (object instanceof Clob) {
            return ((Clob)object).getCharacterStream();
        }
        if (object instanceof String) {
            return new StringReader((String)object);
        }
        throw JDBCUtil.sqlException(5561);
    }

    @Override
    public synchronized Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findParameterIndex(string));
    }

    @Override
    public synchronized void setBlob(String string, Blob blob) throws SQLException {
        super.setBlob(this.findParameterIndex(string), blob);
    }

    @Override
    public synchronized void setClob(String string, Clob clob) throws SQLException {
        super.setClob(this.findParameterIndex(string), clob);
    }

    @Override
    public synchronized void setAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            String string2 = "Maximum ASCII input octet length exceeded: " + l;
            throw JDBCUtil.sqlException(422, string2);
        }
        this.setAsciiStream(string, inputStream, (int)l);
    }

    @Override
    public synchronized void setBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            String string2 = "Maximum Binary input octet length exceeded: " + l;
            throw JDBCUtil.sqlException(422, string2);
        }
        this.setBinaryStream(string, inputStream, (int)l);
    }

    @Override
    public synchronized void setCharacterStream(String string, Reader reader, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            String string2 = "Maximum character input length exceeded: " + l;
            throw JDBCUtil.sqlException(422, string2);
        }
        this.setCharacterStream(string, reader, (int)l);
    }

    @Override
    public synchronized void setAsciiStream(String string, InputStream inputStream) throws SQLException {
        super.setAsciiStream(this.findParameterIndex(string), inputStream);
    }

    @Override
    public synchronized void setBinaryStream(String string, InputStream inputStream) throws SQLException {
        super.setBinaryStream(this.findParameterIndex(string), inputStream);
    }

    @Override
    public synchronized void setCharacterStream(String string, Reader reader) throws SQLException {
        super.setCharacterStream(this.findParameterIndex(string), reader);
    }

    @Override
    public synchronized void setNCharacterStream(String string, Reader reader) throws SQLException {
        super.setNCharacterStream(this.findParameterIndex(string), reader);
    }

    @Override
    public synchronized void setClob(String string, Reader reader) throws SQLException {
        super.setClob(this.findParameterIndex(string), reader);
    }

    @Override
    public synchronized void setBlob(String string, InputStream inputStream) throws SQLException {
        super.setBlob(this.findParameterIndex(string), inputStream);
    }

    @Override
    public synchronized void setNClob(String string, Reader reader) throws SQLException {
        super.setNClob(this.findParameterIndex(string), reader);
    }

    @Override
    public <T> T getObject(int n, Class<T> clazz) throws SQLException {
        if (clazz == null) {
            throw JDBCUtil.nullArgument();
        }
        Object object = this.getColumnValue(n);
        if (this.wasNullValue) {
            return null;
        }
        Object object2 = null;
        switch (clazz.getName()) {
            case "int": 
            case "java.lang.Integer": {
                object2 = this.getInt(n);
                break;
            }
            case "double": 
            case "java.lang.Double": {
                object2 = this.getDouble(n);
                break;
            }
            case "boolean": 
            case "java.lang.Boolean": {
                object2 = this.getBoolean(n);
                break;
            }
            case "byte": 
            case "java.lang.Byte": {
                object2 = this.getByte(n);
                break;
            }
            case "short": 
            case "java.lang.Short": {
                object2 = this.getShort(n);
                break;
            }
            case "long": 
            case "java.lang.Long": {
                object2 = this.getLong(n);
                break;
            }
            case "[B": {
                object2 = this.getBytes(n);
                break;
            }
            case "java.lang.Object": {
                object2 = this.getObject(n);
                break;
            }
            case "java.math.BigDecimal": {
                object2 = this.getBigDecimal(n);
                break;
            }
            case "java.sql.Blob": {
                object2 = this.getBlob(n);
                break;
            }
            case "java.sql.Clob": {
                object2 = this.getClob(n);
                break;
            }
            case "java.lang.String": 
            case "java.lang.CharSequence": {
                object2 = this.getString(n);
                break;
            }
            case "java.sql.Date": {
                object2 = this.getDate(n);
                break;
            }
            case "java.sql.Time": {
                object2 = this.getTime(n);
                break;
            }
            case "java.sql.Timestamp": {
                object2 = this.getTimestamp(n);
                break;
            }
            case "java.util.UUID": {
                Type type = this.parameterTypes[n - 1];
                if (type.isUUIDType()) {
                    object2 = Type.SQL_GUID.convertSQLToJava(this.session, object);
                    break;
                }
                Object object3 = Type.SQL_GUID.convertToTypeJDBC(this.session, object, type);
                object2 = Type.SQL_GUID.convertSQLToJava(this.session, object3);
                break;
            }
            case "java.time.Instant": {
                Type type = this.parameterTypes[n - 1];
                if (!type.isDateOrTimestampType()) break;
                TimestampData timestampData = (TimestampData)object;
                object2 = ((DateTimeType)type).toInstant(this.session, timestampData);
                break;
            }
            case "java.time.LocalDate": {
                Type type = this.parameterTypes[n - 1];
                if (!type.isDateOrTimestampType()) break;
                TimestampData timestampData = (TimestampData)object;
                object2 = ((DateTimeType)type).toLocalDate(this.session, timestampData);
                break;
            }
            case "java.time.LocalTime": {
                Type type = this.parameterTypes[n - 1];
                if (type.isTimeType()) {
                    TimeData timeData = (TimeData)object;
                    object2 = ((DateTimeType)type).toLocalTime(this.session, timeData);
                    break;
                }
                if (!type.isTimestampType()) break;
                TimestampData timestampData = (TimestampData)object;
                object2 = ((DateTimeType)type).toLocalTime(this.session, timestampData);
                break;
            }
            case "java.time.LocalDateTime": {
                Type type = this.parameterTypes[n - 1];
                if (!type.isDateOrTimestampType()) break;
                TimestampData timestampData = (TimestampData)object;
                object2 = ((DateTimeType)type).toLocalDateTime(this.session, timestampData);
                break;
            }
            case "java.time.OffsetTime": {
                Type type = this.parameterTypes[n - 1];
                if (type.isTimeType()) {
                    TimeData timeData = (TimeData)object;
                    object2 = ((DateTimeType)type).toOffsetTime(this.session, timeData);
                    break;
                }
                if (!type.isTimestampType()) break;
                TimestampData timestampData = (TimestampData)object;
                object2 = ((DateTimeType)type).toOffsetTime(this.session, timestampData);
                break;
            }
            case "java.time.OffsetDateTime": {
                Type type = this.parameterTypes[n - 1];
                if (!type.isDateOrTimestampType()) break;
                TimestampData timestampData = (TimestampData)object;
                object2 = ((DateTimeType)type).toOffsetDateTime(this.session, timestampData);
                break;
            }
            case "java.time.Duration": {
                Type type = this.parameterMetaData.columnTypes[n - 1];
                if (!type.isIntervalDaySecondType()) break;
                IntervalSecondData intervalSecondData = (IntervalSecondData)object;
                object2 = Duration.ofSeconds(intervalSecondData.getSeconds(), intervalSecondData.getNanos());
                break;
            }
            case "java.time.Period": {
                Type type = this.parameterMetaData.columnTypes[n - 1];
                if (!type.isIntervalYearMonthType()) break;
                IntervalMonthData intervalMonthData = (IntervalMonthData)object;
                int n2 = intervalMonthData.getMonths();
                if (type.typeCode == 102) {
                    object2 = Period.ofMonths(n2);
                    break;
                }
                object2 = Period.of(n2 / 12, n2 % 12, 0);
                break;
            }
        }
        if (object2 == null) {
            throw JDBCUtil.sqlException(5561);
        }
        return (T)object2;
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        return this.getObject(this.findParameterIndex(string), clazz);
    }

    @Override
    public void setObject(String string, Object object, SQLType sQLType, int n) throws SQLException {
        this.setObject(string, object, (int)sQLType.getVendorTypeNumber(), n);
    }

    @Override
    public void setObject(String string, Object object, SQLType sQLType) throws SQLException {
        this.setObject(string, object, (int)sQLType.getVendorTypeNumber());
    }

    @Override
    public void registerOutParameter(int n, SQLType sQLType) throws SQLException {
        this.registerOutParameter(n, (int)sQLType.getVendorTypeNumber());
    }

    @Override
    public void registerOutParameter(int n, SQLType sQLType, int n2) throws SQLException {
        this.registerOutParameter(n, (int)sQLType.getVendorTypeNumber(), n2);
    }

    @Override
    public void registerOutParameter(int n, SQLType sQLType, String string) throws SQLException {
        this.registerOutParameter(n, (int)sQLType.getVendorTypeNumber(), string);
    }

    @Override
    public void registerOutParameter(String string, SQLType sQLType) throws SQLException {
        this.registerOutParameter(string, (int)sQLType.getVendorTypeNumber());
    }

    @Override
    public void registerOutParameter(String string, SQLType sQLType, int n) throws SQLException {
        this.registerOutParameter(string, (int)sQLType.getVendorTypeNumber(), n);
    }

    @Override
    public void registerOutParameter(String string, SQLType sQLType, String string2) throws SQLException {
        this.registerOutParameter(string, (int)sQLType.getVendorTypeNumber(), string2);
    }

    public JDBCCallableStatement(JDBCConnection jDBCConnection, String string, int n, int n2, int n3) throws HsqlException, SQLException {
        super(jDBCConnection, string, n, n2, n3, 2, null, null);
        if (this.parameterMetaData != null) {
            String[] stringArray = this.parameterMetaData.columnLabels;
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (string2 == null || string2.isEmpty()) continue;
                this.parameterNameMap.put(string2, i);
            }
        }
    }

    @Override
    void fetchResult() throws SQLException {
        super.fetchResult();
        if (this.resultIn.getType() == 43) {
            Object[] objectArray = this.resultIn.getParameterData();
            System.arraycopy(objectArray, 0, this.parameterValues, 0, this.parameterValues.length);
        }
    }

    int findParameterIndex(String string) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (string == null) {
            throw JDBCUtil.nullArgument();
        }
        int n = this.parameterNameMap.get((Object)string, -1);
        if (n >= 0) {
            return n + 1;
        }
        n = this.parameterNameMap.get((Object)string.toUpperCase(Locale.ENGLISH), -1);
        if (n >= 0) {
            return n + 1;
        }
        throw JDBCUtil.sqlException(421, string);
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.parameterNameMap = null;
        super.close();
    }

    protected Object getColumnValue(int n) throws SQLException {
        this.checkGetParameterIndex(n);
        Object object = this.parameterValues[n - 1];
        this.trackNull(object);
        return object;
    }

    private Object getColumnInType(int n, Type type) throws SQLException {
        this.checkGetParameterIndex(n);
        Type type2 = this.parameterTypes[--n];
        Object object = this.parameterValues[n];
        if (this.trackNull(object)) {
            return null;
        }
        if (type2.typeCode != type.typeCode) {
            try {
                object = type.convertToTypeJDBC(this.session, object, type2);
            }
            catch (HsqlException hsqlException) {
                String string = object instanceof Number || object instanceof String || object instanceof java.util.Date ? object.toString() : "instance of " + object.getClass().getName();
                String string2 = "from SQL type " + type2.getNameString() + " to " + type.getJDBCClassName() + ", value: " + string;
                throw JDBCUtil.sqlException(5561, string2);
            }
        }
        return object;
    }

    private Object getTimestampWithZone(int n) throws SQLException {
        TimestampData timestampData = (TimestampData)this.getColumnInType(n, Type.SQL_TIMESTAMP_WITH_TIME_ZONE);
        if (timestampData == null) {
            return null;
        }
        return Type.SQL_TIMESTAMP_WITH_TIME_ZONE.convertSQLToJava(this.session, timestampData);
    }

    private Object getTimeWithZone(int n) throws SQLException {
        TimeData timeData = (TimeData)this.getColumnInType(n, Type.SQL_TIME_WITH_TIME_ZONE);
        if (timeData == null) {
            return null;
        }
        return Type.SQL_TIME_WITH_TIME_ZONE.convertSQLToJava(this.session, timeData);
    }

    private boolean trackNull(Object object) {
        this.wasNullValue = object == null;
        return this.wasNullValue;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public synchronized ResultSet executeQuery() throws SQLException {
        this.fetchResult();
        ResultSet resultSet = this.getResultSet();
        if (resultSet != null) {
            return resultSet;
        }
        if (this.getMoreResults()) {
            return this.getResultSet();
        }
        throw JDBCUtil.sqlException(1254);
    }
}

