/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.util;

import java.util.stream.Stream;

public class BlacklistClassResolver {
    private static final String MATCH_ANY = "*";
    public static final BlacklistClassResolver DEFAULT = new BlacklistClassResolver(BlacklistClassResolver.toArray(System.getProperty("openjpa.serialization.class.blacklist", "org.codehaus.groovy.runtime.,org.apache.commons.collections4.functors.,org.apache.xalan")), BlacklistClassResolver.toArray(System.getProperty("openjpa.serialization.class.whitelist")));
    private final boolean allWhite;
    private final boolean allBlack;
    private final String[] blacklist;
    private final String[] whitelist;

    protected BlacklistClassResolver(String[] blacklist, String[] whitelist) {
        this.allWhite = Stream.of(whitelist).anyMatch(white -> MATCH_ANY.equals(white));
        this.allBlack = Stream.of(blacklist).anyMatch(black -> MATCH_ANY.equals(black));
        this.whitelist = whitelist;
        this.blacklist = blacklist;
    }

    protected boolean isBlacklisted(String name) {
        if (this.allWhite || BlacklistClassResolver.contains(this.whitelist, name)) {
            return false;
        }
        return this.allBlack || BlacklistClassResolver.contains(this.blacklist, name);
    }

    public final String check(String name) {
        if (this.isBlacklisted(name)) {
            throw new SecurityException(name + " is not whitelisted as deserialisable, prevented before loading.");
        }
        return name;
    }

    private static String[] toArray(String property) {
        return property == null ? new String[]{} : (String[])Stream.of(property.split(" *, *")).filter(item -> item != null && !item.isEmpty()).toArray(String[]::new);
    }

    private static boolean contains(String[] list, String name) {
        for (String white : list) {
            if (!name.startsWith(white)) continue;
            return true;
        }
        return false;
    }
}

