/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.finder;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import org.apache.xbean.finder.AbstractFinder;
import org.apache.xbean.osgi.bundle.util.BundleResourceFinder;
import org.apache.xbean.osgi.bundle.util.BundleUtils;
import org.apache.xbean.osgi.bundle.util.ResourceDiscoveryFilter;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.PackageAdmin;

public class BundleAnnotationFinder
extends AbstractFinder {
    private final Bundle bundle;
    private final Set<String> paths;

    public BundleAnnotationFinder(PackageAdmin packageAdmin, Bundle bundle) throws Exception {
        this(packageAdmin, bundle, BundleResourceFinder.FULL_DISCOVERY_FILTER);
    }

    public BundleAnnotationFinder(PackageAdmin packageAdmin, Bundle bundle, ResourceDiscoveryFilter discoveryFilter) throws Exception {
        this(packageAdmin, bundle, discoveryFilter, Collections.emptySet());
    }

    public BundleAnnotationFinder(PackageAdmin packageAdmin, Bundle bundle, ResourceDiscoveryFilter discoveryFilter, Set<String> paths) throws Exception {
        this.bundle = BundleUtils.unwrapBundle((Bundle)bundle);
        BundleResourceFinder bundleResourceFinder = new BundleResourceFinder(packageAdmin, this.bundle, "", ".class", discoveryFilter);
        bundleResourceFinder.find((BundleResourceFinder.ResourceFinderCallback)new AnnotationFindingCallback());
        this.paths = paths;
    }

    @Override
    protected URL getResource(String s) {
        return this.bundle.getResource(s);
    }

    @Override
    protected Class<?> loadClass(String s) throws ClassNotFoundException {
        return this.bundle.loadClass(s);
    }

    @Override
    public List<String> getAnnotatedClassNames() {
        ArrayList<String> classNames = new ArrayList<String>(this.originalInfos.size());
        for (Map.Entry entry : this.originalInfos.entrySet()) {
            if (!this.paths.contains(((AbstractFinder.ClassInfo)entry.getValue()).getPath())) continue;
            classNames.add((String)entry.getKey());
        }
        return classNames;
    }

    private class AnnotationFindingCallback
    implements BundleResourceFinder.ResourceFinderCallback {
        private AnnotationFindingCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean foundInDirectory(Bundle bundle, String baseDir, URL url) throws Exception {
            try (InputStream in = url.openStream();){
                BundleAnnotationFinder.this.readClassDef(in, baseDir);
            }
            return true;
        }

        public boolean foundInJar(Bundle bundle, String jarName, ZipEntry entry, InputStream in) throws Exception {
            BundleAnnotationFinder.this.readClassDef(in, jarName);
            return true;
        }
    }
}

