/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.event;

import java.util.Arrays;
import org.apache.openjpa.event.RemoteCommitEvent;
import org.apache.openjpa.event.RemoteCommitEventManager;
import org.apache.openjpa.event.RemoteCommitProvider;
import org.apache.openjpa.lib.conf.Configurable;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;

public abstract class AbstractRemoteCommitProvider
implements RemoteCommitProvider,
Configurable {
    private static final Localizer _loc = Localizer.forPackage(AbstractRemoteCommitProvider.class);
    protected RemoteCommitEventManager eventManager;
    protected Log log;

    @Override
    public void setConfiguration(Configuration config) {
        this.log = config.getLog("openjpa.Runtime");
    }

    @Override
    public void startConfiguration() {
    }

    @Override
    public void endConfiguration() {
    }

    @Override
    public void setRemoteCommitEventManager(RemoteCommitEventManager mgr) {
        this.eventManager = mgr;
    }

    protected void fireEvent(RemoteCommitEvent event) {
        Exception[] es = this.eventManager.fireEvent(event);
        if (es.length > 0 && this.log.isWarnEnabled()) {
            this.log.warn(_loc.get("remote-listener-ex", Arrays.asList(es)));
        }
        if (this.log.isTraceEnabled()) {
            for (Exception e : es) {
                this.log.trace(e);
            }
        }
    }
}

