/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.webservices;

import java.util.List;
import org.apache.openejb.assembler.classic.ServletInfo;
import org.apache.openejb.server.httpd.BasicAuthHttpListenerWrapper;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.httpd.OpenEJBHttpRegistry;
import org.apache.openejb.server.webservices.WsRegistry;

public class OpenEJBHttpWsRegistry
extends OpenEJBHttpRegistry
implements WsRegistry {
    @Override
    public List<String> setWsContainer(HttpListener httpListener, ClassLoader classLoader, String context, String virtualHost, ServletInfo servletInfo, String realmName, String transportGuarantee, String authMethod, String moduleId) throws Exception {
        String path = (String)servletInfo.mappings.iterator().next();
        return this.addWsContainer(httpListener, classLoader, context, virtualHost, path, realmName, transportGuarantee, authMethod, moduleId);
    }

    @Override
    public void clearWsContainer(String context, String virtualHost, ServletInfo servletInfo, String moduleId) {
        String path = (String)servletInfo.mappings.iterator().next();
        this.removeWsContainer(path, moduleId);
    }

    @Override
    public List<String> addWsContainer(HttpListener inputListener, ClassLoader classLoader, String context, String virtualHost, String path, String realmName, String transportGuarantee, String authMethod, String moduleId) throws Exception {
        if (path == null) {
            throw new NullPointerException("contextRoot is null");
        }
        HttpListener httpListener = inputListener;
        if (httpListener == null) {
            throw new NullPointerException("httpListener is null");
        }
        if ("BASIC".equals(authMethod)) {
            httpListener = new BasicAuthHttpListenerWrapper(httpListener, realmName);
        }
        StringBuilder deployedPath = new StringBuilder("");
        if (context != null) {
            if (!context.startsWith("/")) {
                deployedPath.append("/");
            }
            deployedPath.append(context);
            if (!context.endsWith("/")) {
                deployedPath.append("/");
            }
        } else {
            deployedPath.append("/");
        }
        if (path.startsWith("/") && path.length() > 1) {
            deployedPath.append(path.substring(1));
        } else if (path.length() > 1) {
            deployedPath.append(path);
        }
        this.addWrappedHttpListener(httpListener, classLoader, deployedPath.toString());
        return this.getResolvedAddresses(deployedPath.toString());
    }

    @Override
    public void removeWsContainer(String path, String moduleId) {
        this.registry.removeHttpListener(path);
    }
}

