/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.uima.UimaContext;
import org.apache.uima.internal.util.Misc;

public class UimaContextHolder {
    private static final String TRACK_CONTEXT_HOLDER_TRACKING = "uima.enable_context_holder_tracking";
    private static final String CONTEXT_HOLDER_REFERENCE_TYPE = "uima.context_holder_reference_type";
    private static final boolean IS_TRACK_CONTEXT_HOLDER_TRACKING = Misc.getNoValueSystemProperty("uima.enable_context_holder_tracking");
    private static final ContextHolderReferenceType CONTEXT_HOLDER_REFERENCE_TYPE_VALUE = ContextHolderReferenceType.valueOf(System.getProperty("uima.context_holder_reference_type", ContextHolderReferenceType.WEAK.toString()));
    private static final InheritableThreadLocal<Object> THREAD_LOCAL_CONTEXT = new InheritableThreadLocal();
    private static final Map<UimaContext, StackTraceElement[]> CONTEXT_SETTERS = IS_TRACK_CONTEXT_HOLDER_TRACKING ? Collections.synchronizedMap(new WeakHashMap()) : null;

    private UimaContextHolder() {
    }

    public static UimaContext getContext() {
        Object obj = THREAD_LOCAL_CONTEXT.get();
        if (!(obj instanceof Reference)) {
            return (UimaContext)obj;
        }
        Reference ref = (Reference)obj;
        UimaContext context = (UimaContext)ref.get();
        if (context == null) {
            THREAD_LOCAL_CONTEXT.set(null);
        }
        return context;
    }

    public static UimaContext setContext(UimaContext uimaContext) {
        UimaContext prevContext;
        Object prevContextObj = THREAD_LOCAL_CONTEXT.get();
        UimaContext uimaContext2 = prevContext = prevContextObj instanceof Reference ? (UimaContext)((Reference)prevContextObj).get() : (UimaContext)prevContextObj;
        if (uimaContext == null) {
            THREAD_LOCAL_CONTEXT.set(null);
            if (prevContext != null && CONTEXT_SETTERS != null) {
                CONTEXT_SETTERS.remove(prevContext);
            }
        } else {
            THREAD_LOCAL_CONTEXT.set(UimaContextHolder.makeRef(uimaContext));
            if (CONTEXT_SETTERS != null) {
                CONTEXT_SETTERS.put(uimaContext, new Exception().getStackTrace());
            }
        }
        return prevContext;
    }

    private static Object makeRef(UimaContext aContext) {
        switch (CONTEXT_HOLDER_REFERENCE_TYPE_VALUE) {
            case SOFT: {
                return new SoftReference<UimaContext>(aContext);
            }
            case WEAK: {
                return new WeakReference<UimaContext>(aContext);
            }
            case STRONG: {
                return aContext;
            }
        }
        throw new IllegalArgumentException("Unsupported reference type: [" + String.valueOf((Object)CONTEXT_HOLDER_REFERENCE_TYPE_VALUE) + "]");
    }

    public static void clearContext() {
        if (CONTEXT_SETTERS != null) {
            UimaContext prevContext;
            Object prevContextObj = THREAD_LOCAL_CONTEXT.get();
            UimaContext uimaContext = prevContext = prevContextObj instanceof Reference ? (UimaContext)((Reference)prevContextObj).get() : (UimaContext)prevContextObj;
            if (prevContext != null) {
                CONTEXT_SETTERS.remove(prevContext);
            }
        }
        THREAD_LOCAL_CONTEXT.set(null);
    }

    private static enum ContextHolderReferenceType {
        STRONG,
        WEAK,
        SOFT;

    }
}

