/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.MultiPartFormDataCompliance;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.service.jetty.internal.JettyFactory;
import org.ops4j.pax.web.service.jetty.internal.JettyServer;
import org.ops4j.pax.web.service.jetty.internal.JettyServerImpl;
import org.ops4j.pax.web.service.jetty.internal.JettyServerWrapper;
import org.ops4j.pax.web.service.spi.model.ServerModel;
import org.ops4j.util.xml.ElementHelper;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

class JettyFactoryImpl
implements JettyFactory {
    private final ServerModel serverModel;
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Bundle bundle;
    private Comparator<?> priorityComparator;

    JettyFactoryImpl(ServerModel serverModel, Bundle bundle, Comparator<?> priorityComparator) {
        NullArgumentException.validateNotNull(serverModel, "Service model");
        this.serverModel = serverModel;
        this.bundle = bundle;
        this.priorityComparator = priorityComparator;
    }

    @Override
    public JettyServer createServer(Integer maxThreads, Integer minThreads, Integer threadIdleTimeout) {
        QueuedThreadPool threadPool = maxThreads != null && minThreads != null && threadIdleTimeout != null ? new QueuedThreadPool(maxThreads.intValue(), minThreads.intValue(), threadIdleTimeout.intValue()) : (maxThreads != null && minThreads != null ? new QueuedThreadPool(maxThreads.intValue(), minThreads.intValue()) : (maxThreads != null ? new QueuedThreadPool(maxThreads.intValue()) : new QueuedThreadPool()));
        return new JettyServerImpl(this.serverModel, this.bundle, this.priorityComparator, (ThreadPool)threadPool);
    }

    public ServerConnector createConnector(Server server, String name, int port, Integer idleTimeout, int securePort, String host, Boolean checkForwaredHeaders) {
        HttpConfiguration httpConfig = this.getHttpConfiguration(securePort, checkForwaredHeaders, server);
        HttpConnectionFactory factory = null;
        if (this.alpnCLassesAvailable()) {
            this.log.info("HTTP/2 available, adding HTTP/2 to connector");
            try {
                Class loadClass = this.bundle.loadClass("org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory");
                factory = (ConnectionFactory)ConstructorUtils.invokeConstructor(loadClass, httpConfig);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            this.log.info("HTTP/2 not available, creating standard ServerConnector for Http");
            factory = new HttpConnectionFactory(httpConfig);
        }
        ServerConnector http = new ServerConnector(server);
        http.addConnectionFactory((ConnectionFactory)factory);
        http.setPort(port);
        http.setHost(host);
        http.setName(name);
        if (idleTimeout != null) {
            http.setIdleTimeout((long)idleTimeout.intValue());
        } else {
            http.setIdleTimeout(30000L);
        }
        return http;
    }

    private HttpConfiguration getHttpConfiguration(int securePort, Boolean checkForwardedHeaders, Server server) {
        File serverConfigDir = ((JettyServerWrapper)server).getServerConfigDir();
        URL jettyResource = ((JettyServerWrapper)server).getServerConfigURL();
        HttpConfiguration httpConfig = new HttpConfiguration();
        if (jettyResource == null) {
            jettyResource = this.getClass().getResource("/jetty.xml");
        }
        try {
            if (jettyResource == null && serverConfigDir != null && !serverConfigDir.isDirectory() && serverConfigDir.canRead()) {
                String fileName = serverConfigDir.getName();
                jettyResource = fileName.equalsIgnoreCase("jetty.xml") ? serverConfigDir.toURI().toURL() : serverConfigDir.toURI().toURL();
            }
            if (jettyResource != null) {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                try {
                    httpConfig = this.parseAndConfigureHttpConfig(jettyResource);
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    this.log.error("Can't parse jetty.xml for HttpConfiguration!", (Throwable)e);
                }
            }
        }
        catch (MalformedURLException e) {
            this.log.error("URI to configure HttpConfiguration via jetty.xml is malformed", (Throwable)e);
        }
        if (httpConfig.getSecureScheme() == null) {
            httpConfig.setSecureScheme(HttpScheme.HTTPS.asString());
        }
        if (httpConfig.getSecurePort() == 0) {
            httpConfig.setSecurePort(securePort != 0 ? securePort : 8443);
        }
        if (httpConfig.getOutputBufferSize() == 0) {
            httpConfig.setOutputBufferSize(32768);
        }
        if (checkForwardedHeaders != null && checkForwardedHeaders.booleanValue()) {
            httpConfig.addCustomizer((HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
            if (this.priorityComparator != null) {
                Comparator<?> comparator = this.priorityComparator;
                List customizers = httpConfig.getCustomizers();
                Collections.sort(customizers, comparator);
            }
        }
        httpConfig.setMultiPartFormDataCompliance(MultiPartFormDataCompliance.RFC7578);
        return httpConfig;
    }

    private HttpConfiguration parseAndConfigureHttpConfig(URL jettyResource) throws IOException, ParserConfigurationException, SAXException {
        InputStream inputStream = jettyResource.openStream();
        Element rootElement = ElementHelper.getRootElement(inputStream);
        Element[] news = ElementHelper.getChildren(rootElement, "New");
        List httpConfigElements = Arrays.stream(news).filter(element -> element.hasAttribute("class")).filter(element -> ElementHelper.getAttribute(element, "class").equalsIgnoreCase("org.eclipse.jetty.server.HttpConfiguration")).collect(Collectors.toList());
        if (httpConfigElements.size() < 1) {
            this.log.warn("No HttpConfig Element found in jetty.xml, using default");
            return new HttpConfiguration();
        }
        if (httpConfigElements.size() > 1) {
            this.log.warn("To many HttpConfig elements found, will use default!");
            return new HttpConfiguration();
        }
        HttpConfiguration httpConfig = new HttpConfiguration();
        Element httpConfigElement = (Element)httpConfigElements.get(0);
        Element[] children = ElementHelper.getChildren(httpConfigElement);
        HashMap confProps = new HashMap();
        Arrays.stream(children).filter(element -> element.getTagName().equalsIgnoreCase("Set")).forEach(element -> {
            Element property;
            String name = ElementHelper.getAttribute(element, "name");
            String value = ElementHelper.getValue(element);
            if (element.hasChildNodes() && (property = ElementHelper.getChild(element, "Property")) != null) {
                value = property.getAttribute("default");
            }
            confProps.put(name, value);
        });
        HashMap methods = new HashMap();
        Arrays.stream(HttpConfiguration.class.getMethods()).forEach(method -> methods.put(method.getName(), method));
        HttpConfiguration finalHttpConfig = httpConfig;
        confProps.entrySet().stream().forEach(entry -> {
            String key = (String)entry.getKey();
            key = key.substring(0, 1).toUpperCase().concat(key.substring(1));
            String name = "set".concat(key);
            Method method = (Method)methods.get(name);
            Class<?> parameterType = method.getParameterTypes()[0];
            try {
                Object o = JettyFactoryImpl.toObject(parameterType, (String)entry.getValue());
                method.invoke((Object)finalHttpConfig, o);
            }
            catch (IllegalAccessException | NumberFormatException | InvocationTargetException e) {
                this.log.error("HttpConfiguration failed to set variable {} with method {}", entry.getValue(), (Object)name);
            }
        });
        if (finalHttpConfig == null) {
            this.log.warn("HttpConfiguration is null ... even though it should be initialized!!!");
            httpConfig = new HttpConfiguration();
        } else {
            httpConfig = finalHttpConfig;
        }
        httpConfig.setMultiPartFormDataCompliance(MultiPartFormDataCompliance.RFC7578);
        return httpConfig;
    }

    private static Object toObject(Class clazz, String value) {
        if (Boolean.class == clazz || Boolean.TYPE == clazz) {
            return Boolean.parseBoolean(value);
        }
        if (Byte.class == clazz || Byte.TYPE == clazz) {
            return Byte.parseByte(value);
        }
        if (Short.class == clazz || Short.TYPE == clazz) {
            return Short.parseShort(value);
        }
        if (Integer.class == clazz || Integer.TYPE == clazz) {
            return Integer.parseInt(value);
        }
        if (Long.class == clazz || Long.TYPE == clazz) {
            return Long.parseLong(value);
        }
        if (Float.class == clazz || Float.TYPE == clazz) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (Double.class == clazz || Double.TYPE == clazz) {
            return Double.parseDouble(value);
        }
        return value;
    }

    public ServerConnector createSecureConnector(Server server, String name, int port, Integer idleTimeout, String sslKeystore, String sslKeystorePassword, String sslKeyPassword, String host, String sslKeystoreType, String sslKeyAlias, String trustStore, String trustStorePassword, String trustStoreType, boolean isClientAuthNeeded, boolean isClientAuthWanted, List<String> cipherSuitesIncluded, List<String> cipherSuitesExcluded, List<String> protocolsIncluded, List<String> protocolsExcluded, Boolean sslRenegotiationAllowed, String crlPath, Boolean enableCRLDP, Boolean validateCerts, Boolean validatePeerCerts, Boolean enableOCSP, String ocspResponderURL, Boolean checkForwaredHeaders) {
        String[] cipherSuites;
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        if (null != sslKeystore && !"".equals(sslKeystore.trim())) {
            sslContextFactory.setKeyStorePath(sslKeystore);
        }
        sslContextFactory.setKeyStorePassword(sslKeystorePassword);
        sslContextFactory.setKeyManagerPassword(sslKeyPassword);
        sslContextFactory.setNeedClientAuth(isClientAuthNeeded);
        sslContextFactory.setWantClientAuth(isClientAuthWanted);
        sslContextFactory.setEnableCRLDP(enableCRLDP.booleanValue());
        sslContextFactory.setValidateCerts(validateCerts.booleanValue());
        sslContextFactory.setValidatePeerCerts(validatePeerCerts.booleanValue());
        sslContextFactory.setEnableOCSP(enableOCSP.booleanValue());
        if (null != crlPath && !"".equals(crlPath)) {
            sslContextFactory.setCrlPath(crlPath);
        }
        if (null != ocspResponderURL && !"".equals(ocspResponderURL)) {
            sslContextFactory.setOcspResponderURL(ocspResponderURL);
        }
        if (sslKeystoreType != null) {
            sslContextFactory.setKeyStoreType(sslKeystoreType);
        }
        if (null != sslKeyAlias && !"".equals(sslKeyAlias)) {
            sslContextFactory.setCertAlias(sslKeyAlias);
        }
        if (null != trustStore && !"".equals(trustStore)) {
            sslContextFactory.setTrustStorePath(trustStore);
        }
        if (null != trustStorePassword && !"".equals(trustStorePassword)) {
            sslContextFactory.setTrustStorePassword(trustStorePassword);
        }
        if (null != trustStoreType && !"".equals(trustStoreType)) {
            sslContextFactory.setTrustStoreType(trustStoreType);
        }
        try {
            SSLContext context = SSLContext.getDefault();
            String[] sf = context.getSocketFactory();
            cipherSuites = sf.getSupportedCipherSuites();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed to get supported cipher suites.", e);
        }
        if (cipherSuitesIncluded != null && !cipherSuitesIncluded.isEmpty()) {
            ArrayList<String> cipherSuitesToInclude = new ArrayList<String>();
            for (String cipherSuite : cipherSuites) {
                for (String includeRegex : cipherSuitesIncluded) {
                    if (!cipherSuite.matches(includeRegex)) continue;
                    cipherSuitesToInclude.add(cipherSuite);
                }
            }
            sslContextFactory.setIncludeCipherSuites(cipherSuitesToInclude.toArray(new String[cipherSuitesToInclude.size()]));
        }
        if (cipherSuitesExcluded != null && !cipherSuitesExcluded.isEmpty()) {
            ArrayList<String> cipherSuitesToExclude = new ArrayList<String>();
            for (String cipherSuite : cipherSuites) {
                for (String excludeRegex : cipherSuitesExcluded) {
                    if (!cipherSuite.matches(excludeRegex)) continue;
                    cipherSuitesToExclude.add(cipherSuite);
                }
            }
            sslContextFactory.setExcludeCipherSuites(cipherSuitesToExclude.toArray(new String[cipherSuitesToExclude.size()]));
        }
        if (null != protocolsIncluded && !protocolsIncluded.isEmpty()) {
            sslContextFactory.setIncludeProtocols(protocolsIncluded.toArray(new String[protocolsIncluded.size()]));
        }
        if (null != protocolsExcluded && !protocolsExcluded.isEmpty()) {
            sslContextFactory.setExcludeProtocols(protocolsExcluded.toArray(new String[protocolsExcluded.size()]));
        }
        if (sslRenegotiationAllowed != null) {
            sslContextFactory.setRenegotiationAllowed(sslRenegotiationAllowed.booleanValue());
        }
        HttpConfiguration httpConfig = this.getHttpConfiguration(port, checkForwaredHeaders, server);
        HttpConfiguration httpsConfig = new HttpConfiguration(httpConfig);
        httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        ArrayList<Object> connectionFactories = new ArrayList<Object>();
        HttpConnectionFactory httpConFactory = new HttpConnectionFactory(httpsConfig);
        SslConnectionFactory sslFactory = null;
        AbstractConnectionFactory http2Factory = null;
        Object alpnFactory = null;
        if (this.alpnCLassesAvailable()) {
            this.log.info("HTTP/2 available, creating HttpSpdyServerConnector for Https");
            try {
                Class comparatorClass = this.bundle.loadClass("org.eclipse.jetty.http2.HTTP2Cipher");
                Comparator cipherComparator = (Comparator)FieldUtils.readDeclaredStaticField(comparatorClass, "COMPARATOR");
                sslContextFactory.setCipherComparator(cipherComparator);
                sslFactory = new SslConnectionFactory((SslContextFactory)sslContextFactory, "h2");
                connectionFactories.add(sslFactory);
                Class clazz = this.bundle.loadClass("org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory");
                http2Factory = (AbstractConnectionFactory)ConstructorUtils.invokeConstructor(clazz, httpsConfig);
                connectionFactories.add(http2Factory);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            this.log.info("SPDY not available, creating standard ServerConnector for Https");
            sslFactory = new SslConnectionFactory((SslContextFactory)sslContextFactory, "http/1.1");
        }
        ServerConnector https = new ServerConnector(server, new ConnectionFactory[]{sslFactory, httpConFactory});
        for (AbstractConnectionFactory abstractConnectionFactory : connectionFactories) {
            https.addConnectionFactory((ConnectionFactory)abstractConnectionFactory);
        }
        https.setPort(port);
        https.setName(name);
        https.setHost(host);
        if (idleTimeout != null) {
            https.setIdleTimeout((long)idleTimeout.intValue());
        } else {
            https.setIdleTimeout(500000L);
        }
        return https;
    }

    private boolean alpnCLassesAvailable() {
        try {
            this.bundle.loadClass("org.eclipse.jetty.alpn.ALPN");
        }
        catch (ClassNotFoundException e) {
            this.log.info("No ALPN class available");
            return false;
        }
        try {
            this.bundle.loadClass("org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory");
        }
        catch (ClassNotFoundException e) {
            this.log.info("No HTTP2ServerConnectionFactory class available");
            return false;
        }
        try {
            this.bundle.loadClass("org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory");
        }
        catch (ClassNotFoundException e) {
            this.log.info("No ALPNServerConnectionFactory class available");
            return false;
        }
        return true;
    }
}

