/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.groovy.actions;

import groovy.lang.Script;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

public final class ScriptMetadata {
    private final String actionName;
    private final String scriptContent;
    private final String contentHash;
    private final long creationTime;
    private final Class<? extends Script> compiledClass;

    public ScriptMetadata(String actionName, String scriptContent, Class<? extends Script> compiledClass) {
        if (actionName == null) {
            throw new IllegalArgumentException("Action name cannot be null");
        }
        if (scriptContent == null) {
            throw new IllegalArgumentException("Script content cannot be null");
        }
        if (compiledClass == null) {
            throw new IllegalArgumentException("Compiled class cannot be null");
        }
        this.actionName = actionName;
        this.scriptContent = scriptContent;
        this.contentHash = this.calculateHash(scriptContent);
        this.creationTime = System.currentTimeMillis();
        this.compiledClass = compiledClass;
    }

    private String calculateHash(String content) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(content.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-256 algorithm not available", e);
        }
    }

    public boolean hasChanged(String newContent) {
        if (newContent == null) {
            throw new IllegalArgumentException("New content cannot be null");
        }
        return !this.contentHash.equals(this.calculateHash(newContent));
    }

    public String getActionName() {
        return this.actionName;
    }

    public String getScriptContent() {
        return this.scriptContent;
    }

    public String getContentHash() {
        return this.contentHash;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public Class<? extends Script> getCompiledClass() {
        return this.compiledClass;
    }
}

