/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.persistence.elasticsearch;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.persistence.elasticsearch.ConditionESQueryBuilder;
import org.apache.unomi.persistence.spi.conditions.ConditionContextHelper;
import org.apache.unomi.scripting.ScriptExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionESQueryBuilderDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ConditionESQueryBuilderDispatcher.class.getName());
    private Map<String, ConditionESQueryBuilder> queryBuilders = new ConcurrentHashMap<String, ConditionESQueryBuilder>();
    private ScriptExecutor scriptExecutor;

    public void setScriptExecutor(ScriptExecutor scriptExecutor) {
        this.scriptExecutor = scriptExecutor;
    }

    public void addQueryBuilder(String name, ConditionESQueryBuilder evaluator) {
        this.queryBuilders.put(name, evaluator);
    }

    public void removeQueryBuilder(String name) {
        this.queryBuilders.remove(name);
    }

    public String getQuery(Condition condition) {
        return "{\"query\": " + this.getQueryBuilder(condition).toString() + "}";
    }

    public Query getQueryBuilder(Condition condition) {
        Query.Builder qb = new Query.Builder();
        return qb.bool(b -> b.must(Query.of(q -> q.matchAll(m -> m)), new Query[0]).filter(this.buildFilter(condition), new Query[0])).build();
    }

    public Query buildFilter(Condition condition) {
        return this.buildFilter(condition, new HashMap<String, Object>());
    }

    public Query buildFilter(Condition condition, Map<String, Object> context) {
        if (condition == null || condition.getConditionType() == null) {
            throw new IllegalArgumentException("Condition is null or doesn't have type, impossible to build filter");
        }
        String queryBuilderKey = condition.getConditionType().getQueryBuilder();
        if (queryBuilderKey == null && condition.getConditionType().getParentCondition() != null) {
            context.putAll(condition.getParameterValues());
            return this.buildFilter(condition.getConditionType().getParentCondition(), context);
        }
        if (queryBuilderKey == null) {
            throw new UnsupportedOperationException("No query builder defined for : " + condition.getConditionTypeId());
        }
        if (this.queryBuilders.containsKey(queryBuilderKey)) {
            ConditionESQueryBuilder queryBuilder = this.queryBuilders.get(queryBuilderKey);
            Condition contextualCondition = ConditionContextHelper.getContextualCondition((Condition)condition, context, (ScriptExecutor)this.scriptExecutor);
            if (contextualCondition != null) {
                return queryBuilder.buildQuery(contextualCondition, context, this);
            }
        } else {
            LOGGER.warn("No matching query builder. See debug log level for more information");
            LOGGER.debug("No matching query builder for condition {} and context {}", (Object)condition, context);
        }
        return Query.of(q -> q.matchAll(m -> m));
    }

    public long count(Condition condition) {
        return this.count(condition, new HashMap<String, Object>());
    }

    public long count(Condition condition, Map<String, Object> context) {
        if (condition == null || condition.getConditionType() == null) {
            throw new IllegalArgumentException("Condition is null or doesn't have type, impossible to build filter");
        }
        String queryBuilderKey = condition.getConditionType().getQueryBuilder();
        if (queryBuilderKey == null && condition.getConditionType().getParentCondition() != null) {
            context.putAll(condition.getParameterValues());
            return this.count(condition.getConditionType().getParentCondition(), context);
        }
        if (queryBuilderKey == null) {
            throw new UnsupportedOperationException("No query builder defined for : " + condition.getConditionTypeId());
        }
        if (this.queryBuilders.containsKey(queryBuilderKey)) {
            ConditionESQueryBuilder queryBuilder = this.queryBuilders.get(queryBuilderKey);
            Condition contextualCondition = ConditionContextHelper.getContextualCondition((Condition)condition, context, (ScriptExecutor)this.scriptExecutor);
            if (contextualCondition != null) {
                return queryBuilder.count(contextualCondition, context, this);
            }
        }
        LOGGER.warn("No matching query builder. See debug log level for more information");
        LOGGER.debug("No matching query builder for condition {} and context {}", (Object)condition, context);
        throw new UnsupportedOperationException();
    }
}

