/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.persistence.elasticsearch;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._helpers.bulk.BulkIngester;
import co.elastic.clients.elasticsearch._helpers.bulk.BulkListener;
import co.elastic.clients.elasticsearch._types.Conflicts;
import co.elastic.clients.elasticsearch._types.DistanceUnit;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.GeoDistanceSort;
import co.elastic.clients.elasticsearch._types.GeoLocation;
import co.elastic.clients.elasticsearch._types.HealthStatus;
import co.elastic.clients.elasticsearch._types.OpType;
import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.Result;
import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.ScriptLanguage;
import co.elastic.clients.elasticsearch._types.ScriptSource;
import co.elastic.clients.elasticsearch._types.Slices;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.StoredScript;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationBuilders;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationRange;
import co.elastic.clients.elasticsearch._types.aggregations.AverageAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.CalendarInterval;
import co.elastic.clients.elasticsearch._types.aggregations.CardinalityAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.DateHistogramAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.DateHistogramAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.DateHistogramBucket;
import co.elastic.clients.elasticsearch._types.aggregations.DateRangeAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.DateRangeExpression;
import co.elastic.clients.elasticsearch._types.aggregations.FieldDateMath;
import co.elastic.clients.elasticsearch._types.aggregations.FilterAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.GlobalAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.GlobalAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.IpRangeAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.IpRangeAggregationRange;
import co.elastic.clients.elasticsearch._types.aggregations.LongTermsBucket;
import co.elastic.clients.elasticsearch._types.aggregations.MaxAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.MinAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.MissingAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.MissingAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.MultiTermsBucket;
import co.elastic.clients.elasticsearch._types.aggregations.RangeAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.StringTermsAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.StringTermsBucket;
import co.elastic.clients.elasticsearch._types.aggregations.SumAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.TermsAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.TermsInclude;
import co.elastic.clients.elasticsearch._types.analysis.CustomAnalyzer;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.TypeMapping;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.IdsQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.RangeQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.TermQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.TermsQueryField;
import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.BulkResponse;
import co.elastic.clients.elasticsearch.core.ClearScrollRequest;
import co.elastic.clients.elasticsearch.core.CountRequest;
import co.elastic.clients.elasticsearch.core.DeleteByQueryRequest;
import co.elastic.clients.elasticsearch.core.DeleteByQueryResponse;
import co.elastic.clients.elasticsearch.core.DeleteRequest;
import co.elastic.clients.elasticsearch.core.GetRequest;
import co.elastic.clients.elasticsearch.core.GetResponse;
import co.elastic.clients.elasticsearch.core.IndexRequest;
import co.elastic.clients.elasticsearch.core.IndexResponse;
import co.elastic.clients.elasticsearch.core.InfoResponse;
import co.elastic.clients.elasticsearch.core.PutScriptRequest;
import co.elastic.clients.elasticsearch.core.PutScriptResponse;
import co.elastic.clients.elasticsearch.core.ScrollRequest;
import co.elastic.clients.elasticsearch.core.ScrollResponse;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.UpdateByQueryRequest;
import co.elastic.clients.elasticsearch.core.UpdateByQueryResponse;
import co.elastic.clients.elasticsearch.core.UpdateRequest;
import co.elastic.clients.elasticsearch.core.UpdateResponse;
import co.elastic.clients.elasticsearch.core.bulk.BulkOperation;
import co.elastic.clients.elasticsearch.core.bulk.CreateOperation;
import co.elastic.clients.elasticsearch.core.bulk.DeleteOperation;
import co.elastic.clients.elasticsearch.core.bulk.IndexOperation;
import co.elastic.clients.elasticsearch.core.bulk.UpdateAction;
import co.elastic.clients.elasticsearch.core.bulk.UpdateOperation;
import co.elastic.clients.elasticsearch.core.search.Hit;
import co.elastic.clients.elasticsearch.core.search.TotalHits;
import co.elastic.clients.elasticsearch.core.search.TotalHitsRelation;
import co.elastic.clients.elasticsearch.ilm.Actions;
import co.elastic.clients.elasticsearch.ilm.IlmPolicy;
import co.elastic.clients.elasticsearch.ilm.Phase;
import co.elastic.clients.elasticsearch.ilm.Phases;
import co.elastic.clients.elasticsearch.ilm.PutLifecycleRequest;
import co.elastic.clients.elasticsearch.ilm.PutLifecycleResponse;
import co.elastic.clients.elasticsearch.ilm.RolloverAction;
import co.elastic.clients.elasticsearch.indices.Alias;
import co.elastic.clients.elasticsearch.indices.CreateIndexRequest;
import co.elastic.clients.elasticsearch.indices.CreateIndexResponse;
import co.elastic.clients.elasticsearch.indices.DeleteIndexRequest;
import co.elastic.clients.elasticsearch.indices.DeleteIndexTemplateRequest;
import co.elastic.clients.elasticsearch.indices.ExistsIndexTemplateRequest;
import co.elastic.clients.elasticsearch.indices.ExistsRequest;
import co.elastic.clients.elasticsearch.indices.GetAliasResponse;
import co.elastic.clients.elasticsearch.indices.GetIndexRequest;
import co.elastic.clients.elasticsearch.indices.GetIndexResponse;
import co.elastic.clients.elasticsearch.indices.GetMappingRequest;
import co.elastic.clients.elasticsearch.indices.GetMappingResponse;
import co.elastic.clients.elasticsearch.indices.IndexSettings;
import co.elastic.clients.elasticsearch.indices.IndexSettingsAnalysis;
import co.elastic.clients.elasticsearch.indices.MappingLimitSettings;
import co.elastic.clients.elasticsearch.indices.MappingLimitSettingsTotalFields;
import co.elastic.clients.elasticsearch.indices.PutIndexTemplateRequest;
import co.elastic.clients.elasticsearch.indices.PutMappingRequest;
import co.elastic.clients.elasticsearch.indices.PutMappingResponse;
import co.elastic.clients.elasticsearch.indices.RefreshRequest;
import co.elastic.clients.elasticsearch.indices.get_mapping.IndexMappingRecord;
import co.elastic.clients.elasticsearch.indices.put_index_template.IndexTemplateMapping;
import co.elastic.clients.elasticsearch.tasks.GetTasksRequest;
import co.elastic.clients.elasticsearch.tasks.GetTasksResponse;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.transport.BackoffPolicy;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.TransportOptions;
import co.elastic.clients.transport.endpoints.BooleanResponse;
import co.elastic.clients.transport.rest_client.RestClientOptions;
import co.elastic.clients.util.ObjectBuilder;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.json.stream.JsonGenerator;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.log4j.Level;
import org.apache.unomi.api.CustomItem;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.MetadataItem;
import org.apache.unomi.api.PartialList;
import org.apache.unomi.api.PropertyType;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.query.DateRange;
import org.apache.unomi.api.query.IpRange;
import org.apache.unomi.api.query.NumericRange;
import org.apache.unomi.metrics.MetricAdapter;
import org.apache.unomi.metrics.MetricsService;
import org.apache.unomi.persistence.elasticsearch.ConditionESQueryBuilder;
import org.apache.unomi.persistence.elasticsearch.ConditionESQueryBuilderDispatcher;
import org.apache.unomi.persistence.elasticsearch.ESCustomObjectMapper;
import org.apache.unomi.persistence.elasticsearch.ElasticsearchClientFactory;
import org.apache.unomi.persistence.spi.PersistenceService;
import org.apache.unomi.persistence.spi.aggregate.BaseAggregate;
import org.apache.unomi.persistence.spi.aggregate.DateAggregate;
import org.apache.unomi.persistence.spi.aggregate.DateRangeAggregate;
import org.apache.unomi.persistence.spi.aggregate.IpRangeAggregate;
import org.apache.unomi.persistence.spi.aggregate.NumericRangeAggregate;
import org.apache.unomi.persistence.spi.aggregate.TermsAggregate;
import org.apache.unomi.persistence.spi.conditions.ConditionContextHelper;
import org.apache.unomi.persistence.spi.conditions.evaluator.ConditionEvaluatorDispatcher;
import org.elasticsearch.client.HttpAsyncResponseConsumerFactory;
import org.elasticsearch.client.RequestOptions;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchPersistenceServiceImpl
implements PersistenceService,
SynchronousBundleListener {
    public static final String SEQ_NO = "seq_no";
    public static final String PRIMARY_TERM = "primary_term";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ElasticSearchPersistenceServiceImpl.class.getName());
    private static final String ROLLOVER_LIFECYCLE_NAME = "unomi-rollover-policy";
    private boolean throwExceptions = false;
    private ElasticsearchClient esClient;
    private BulkIngester bulkIngester;
    private String elasticSearchAddresses;
    private final List<String> elasticSearchAddressList = new ArrayList<String>();
    private String indexPrefix;
    private String numberOfShards;
    private String numberOfReplicas;
    private String indexMappingTotalFieldsLimit;
    private String indexMaxDocValueFieldsSearch;
    private String[] fatalIllegalStateErrors;
    private BundleContext bundleContext;
    private final Map<String, String> mappings = new HashMap<String, String>();
    private ConditionEvaluatorDispatcher conditionEvaluatorDispatcher;
    private ConditionESQueryBuilderDispatcher conditionESQueryBuilderDispatcher;
    private Map<String, String> routingByType;
    private Integer defaultQueryLimit = 10;
    private final Integer removeByQueryTimeoutInMinutes = 10;
    private Integer taskWaitingTimeout = 3600000;
    private Integer taskWaitingPollingInterval = 1000;
    private String bulkProcessorConcurrentRequests = "1";
    private String bulkProcessorBulkActions = "1000";
    private Long bulkProcessorBulkSize = 5L;
    private Long bulkProcessorFlushIntervalInSeconds = 5L;
    private String bulkProcessorBackoffPolicy = "exponential";
    private String sessionLatestIndex;
    private List<String> rolloverIndices;
    private String rolloverMaxSize;
    private String rolloverMaxAge;
    private String rolloverMaxDocs;
    private String rolloverIndexNumberOfShards;
    private String rolloverIndexNumberOfReplicas;
    private String rolloverIndexMappingTotalFieldsLimit;
    private String rolloverIndexMaxDocValueFieldsSearch;
    private String minimalElasticSearchVersion = "9.0.3";
    private String maximalElasticSearchVersion = "10.0.0";
    private String username;
    private String password;
    private boolean sslEnable = false;
    private boolean sslTrustAllCertificates = false;
    private int aggregateQueryBucketSize = 5000;
    private MetricsService metricsService;
    private boolean useBatchingForSave = false;
    private boolean useBatchingForUpdate = true;
    private String logLevelRestClient = "ERROR";
    private boolean alwaysOverwrite = true;
    private boolean aggQueryThrowOnMissingDocs = false;
    private Integer aggQueryMaxResponseSizeHttp = null;
    private Integer clientSocketTimeout = null;
    private Map<String, Refresh> itemTypeToRefreshPolicy = new HashMap<String, Refresh>();
    private final Map<String, Map<String, Map<String, Object>>> knownMappings = new HashMap<String, Map<String, Map<String, Object>>>();
    private static final Map<String, String> itemTypeIndexNameMap = new HashMap<String, String>();
    private static final Collection<String> systemItems = Arrays.asList("actionType", "campaign", "campaignevent", "goal", "userList", "propertyType", "scope", "conditionType", "rule", "scoring", "segment", "groovyAction", "topic", "patch", "jsonSchema", "importConfig", "exportConfig", "rulestats");

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setElasticSearchAddresses(String elasticSearchAddresses) {
        this.elasticSearchAddresses = elasticSearchAddresses;
        String[] elasticSearchAddressesArray = elasticSearchAddresses.split(",");
        this.elasticSearchAddressList.clear();
        for (String elasticSearchAddress : elasticSearchAddressesArray) {
            this.elasticSearchAddressList.add(elasticSearchAddress.trim());
        }
    }

    public void setItemTypeToRefreshPolicy(String itemTypeToRefreshPolicy) throws IOException {
        if (!itemTypeToRefreshPolicy.isEmpty()) {
            this.itemTypeToRefreshPolicy = (Map)new ObjectMapper().readValue(itemTypeToRefreshPolicy, (TypeReference)new TypeReference<HashMap<String, Refresh>>(){});
        }
    }

    public void setFatalIllegalStateErrors(String fatalIllegalStateErrors) {
        this.fatalIllegalStateErrors = (String[])Arrays.stream(fatalIllegalStateErrors.split(",")).map(i -> i.trim()).filter(i -> !i.isEmpty()).toArray(String[]::new);
    }

    public void setAggQueryMaxResponseSizeHttp(String aggQueryMaxResponseSizeHttp) {
        if (StringUtils.isNumeric((CharSequence)aggQueryMaxResponseSizeHttp)) {
            this.aggQueryMaxResponseSizeHttp = Integer.parseInt(aggQueryMaxResponseSizeHttp);
        }
    }

    public void setIndexPrefix(String indexPrefix) {
        this.indexPrefix = indexPrefix;
    }

    public void setNumberOfShards(String numberOfShards) {
        this.numberOfShards = numberOfShards;
    }

    public void setNumberOfReplicas(String numberOfReplicas) {
        this.numberOfReplicas = numberOfReplicas;
    }

    public void setIndexMappingTotalFieldsLimit(String indexMappingTotalFieldsLimit) {
        this.indexMappingTotalFieldsLimit = indexMappingTotalFieldsLimit;
    }

    public void setIndexMaxDocValueFieldsSearch(String indexMaxDocValueFieldsSearch) {
        this.indexMaxDocValueFieldsSearch = indexMaxDocValueFieldsSearch;
    }

    public void setDefaultQueryLimit(Integer defaultQueryLimit) {
        this.defaultQueryLimit = defaultQueryLimit;
    }

    public void setRoutingByType(Map<String, String> routingByType) {
        this.routingByType = routingByType;
    }

    public void setConditionEvaluatorDispatcher(ConditionEvaluatorDispatcher conditionEvaluatorDispatcher) {
        this.conditionEvaluatorDispatcher = conditionEvaluatorDispatcher;
    }

    public void setConditionESQueryBuilderDispatcher(ConditionESQueryBuilderDispatcher conditionESQueryBuilderDispatcher) {
        this.conditionESQueryBuilderDispatcher = conditionESQueryBuilderDispatcher;
    }

    public void setBulkProcessorConcurrentRequests(String bulkProcessorConcurrentRequests) {
        this.bulkProcessorConcurrentRequests = bulkProcessorConcurrentRequests;
    }

    public void setBulkProcessorBulkActions(String bulkProcessorBulkActions) {
        this.bulkProcessorBulkActions = bulkProcessorBulkActions;
    }

    public void setBulkProcessorBulkSize(Long bulkProcessorBulkSize) {
        this.bulkProcessorBulkSize = bulkProcessorBulkSize;
    }

    public void setBulkProcessorFlushIntervalInSeconds(Long bulkProcessorFlushIntervalInSeconds) {
        this.bulkProcessorFlushIntervalInSeconds = bulkProcessorFlushIntervalInSeconds;
    }

    public void setBulkProcessorBackoffPolicy(String bulkProcessorBackoffPolicy) {
        this.bulkProcessorBackoffPolicy = bulkProcessorBackoffPolicy;
    }

    public void setRolloverIndices(String rolloverIndices) {
        this.rolloverIndices = StringUtils.isNotEmpty((CharSequence)rolloverIndices) ? Arrays.asList((String[])rolloverIndices.split(",").clone()) : null;
    }

    public void setRolloverMaxSize(String rolloverMaxSize) {
        this.rolloverMaxSize = rolloverMaxSize;
    }

    public void setRolloverMaxAge(String rolloverMaxAge) {
        this.rolloverMaxAge = rolloverMaxAge;
    }

    public void setRolloverMaxDocs(String rolloverMaxDocs) {
        this.rolloverMaxDocs = rolloverMaxDocs;
    }

    public void setRolloverIndexNumberOfShards(String rolloverIndexNumberOfShards) {
        this.rolloverIndexNumberOfShards = rolloverIndexNumberOfShards;
    }

    public void setRolloverIndexNumberOfReplicas(String rolloverIndexNumberOfReplicas) {
        this.rolloverIndexNumberOfReplicas = rolloverIndexNumberOfReplicas;
    }

    public void setRolloverIndexMappingTotalFieldsLimit(String rolloverIndexMappingTotalFieldsLimit) {
        this.rolloverIndexMappingTotalFieldsLimit = rolloverIndexMappingTotalFieldsLimit;
    }

    public void setRolloverIndexMaxDocValueFieldsSearch(String rolloverIndexMaxDocValueFieldsSearch) {
        this.rolloverIndexMaxDocValueFieldsSearch = rolloverIndexMaxDocValueFieldsSearch;
    }

    public void setMinimalElasticSearchVersion(String minimalElasticSearchVersion) {
        this.minimalElasticSearchVersion = minimalElasticSearchVersion;
    }

    public void setMaximalElasticSearchVersion(String maximalElasticSearchVersion) {
        this.maximalElasticSearchVersion = maximalElasticSearchVersion;
    }

    public void setAggregateQueryBucketSize(int aggregateQueryBucketSize) {
        this.aggregateQueryBucketSize = aggregateQueryBucketSize;
    }

    public void setClientSocketTimeout(String clientSocketTimeout) {
        if (StringUtils.isNumeric((CharSequence)clientSocketTimeout)) {
            this.clientSocketTimeout = Integer.parseInt(clientSocketTimeout);
        }
    }

    public void setMetricsService(MetricsService metricsService) {
        this.metricsService = metricsService;
    }

    public void setUseBatchingForSave(boolean useBatchingForSave) {
        this.useBatchingForSave = useBatchingForSave;
    }

    public void setUseBatchingForUpdate(boolean useBatchingForUpdate) {
        this.useBatchingForUpdate = useBatchingForUpdate;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSslEnable(boolean sslEnable) {
        this.sslEnable = sslEnable;
    }

    public void setSslTrustAllCertificates(boolean sslTrustAllCertificates) {
        this.sslTrustAllCertificates = sslTrustAllCertificates;
    }

    public void setAggQueryThrowOnMissingDocs(boolean aggQueryThrowOnMissingDocs) {
        this.aggQueryThrowOnMissingDocs = aggQueryThrowOnMissingDocs;
    }

    public void setThrowExceptions(boolean throwExceptions) {
        this.throwExceptions = throwExceptions;
    }

    public void setAlwaysOverwrite(boolean alwaysOverwrite) {
        this.alwaysOverwrite = alwaysOverwrite;
    }

    public void setLogLevelRestClient(String logLevelRestClient) {
        this.logLevelRestClient = logLevelRestClient;
    }

    public void setTaskWaitingTimeout(String taskWaitingTimeout) {
        if (StringUtils.isNumeric((CharSequence)taskWaitingTimeout)) {
            this.taskWaitingTimeout = Integer.parseInt(taskWaitingTimeout);
        }
    }

    public void setTaskWaitingPollingInterval(String taskWaitingPollingInterval) {
        if (StringUtils.isNumeric((CharSequence)taskWaitingPollingInterval)) {
            this.taskWaitingPollingInterval = Integer.parseInt(taskWaitingPollingInterval);
        }
    }

    private boolean versionIsNotCompatible() throws IOException {
        InfoResponse info = this.esClient.info();
        String currentVersion = info.version().number();
        return ElasticSearchPersistenceServiceImpl.compareVersions(currentVersion, this.minimalElasticSearchVersion) < 0 || ElasticSearchPersistenceServiceImpl.compareVersions(currentVersion, this.maximalElasticSearchVersion) >= 0;
    }

    private static int compareVersions(String version1, String version2) {
        String[] parts1 = version1.split("\\.");
        String[] parts2 = version2.split("\\.");
        int length = Math.max(parts1.length, parts2.length);
        for (int i = 0; i < length; ++i) {
            int part2;
            int part1 = i < parts1.length ? Integer.parseInt(parts1[i]) : 0;
            int n = part2 = i < parts2.length ? Integer.parseInt(parts2[i]) : 0;
            if (part1 == part2) continue;
            return part1 - part2;
        }
        return 0;
    }

    public void start() throws Exception {
        try {
            Level lvl = Level.toLevel((String)this.logLevelRestClient, (Level)Level.ERROR);
            org.apache.log4j.Logger.getLogger((String)"org.elasticsearch.client.RestClient").setLevel(lvl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        new InClassLoaderExecute<Object>(null, null, this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            public Object execute(Object ... args) throws Exception {
                ElasticSearchPersistenceServiceImpl.this.buildClient();
                if (ElasticSearchPersistenceServiceImpl.this.versionIsNotCompatible()) {
                    throw new Exception("ElasticSearch version is not within [" + ElasticSearchPersistenceServiceImpl.this.minimalElasticSearchVersion + "," + ElasticSearchPersistenceServiceImpl.this.maximalElasticSearchVersion + "), aborting startup !");
                }
                ElasticSearchPersistenceServiceImpl.this.registerRolloverLifecyclePolicy();
                ElasticSearchPersistenceServiceImpl.this.loadPredefinedMappings(ElasticSearchPersistenceServiceImpl.this.bundleContext, false);
                ElasticSearchPersistenceServiceImpl.this.loadPainlessScripts(ElasticSearchPersistenceServiceImpl.this.bundleContext);
                for (Bundle existingBundle : ElasticSearchPersistenceServiceImpl.this.bundleContext.getBundles()) {
                    if (existingBundle.getBundleContext() == null) continue;
                    ElasticSearchPersistenceServiceImpl.this.loadPredefinedMappings(existingBundle.getBundleContext(), false);
                    ElasticSearchPersistenceServiceImpl.this.loadPainlessScripts(existingBundle.getBundleContext());
                }
                LOGGER.info("Waiting for GREEN cluster status...");
                ElasticSearchPersistenceServiceImpl.this.esClient.cluster().health(builder -> builder.waitForStatus(HealthStatus.Green));
                LOGGER.info("Cluster status is GREEN");
                if (ElasticSearchPersistenceServiceImpl.this.isItemTypeRollingOver("session")) {
                    LOGGER.info("Sessions are using rollover indices, loading latest session index available ...");
                    GetAliasResponse getAliasResponse = ElasticSearchPersistenceServiceImpl.this.esClient.indices().getAlias(builder -> builder.name(ElasticSearchPersistenceServiceImpl.this.getIndex("session"), new String[0]));
                    Map aliases = getAliasResponse.aliases();
                    if (!aliases.isEmpty()) {
                        ElasticSearchPersistenceServiceImpl.this.sessionLatestIndex = (String)new TreeSet(aliases.keySet()).last();
                        LOGGER.info("Latest available session index found is: {}", (Object)ElasticSearchPersistenceServiceImpl.this.sessionLatestIndex);
                    } else {
                        throw new IllegalStateException("No index found for sessions");
                    }
                }
                return true;
            }
        }.executeInClassLoader(new Object[0]);
        this.bundleContext.addBundleListener((BundleListener)this);
        LOGGER.info("{} service started successfully.", (Object)this.getClass().getName());
    }

    private List<HttpHost> getHosts() {
        ArrayList<HttpHost> hosts = new ArrayList<HttpHost>();
        for (String elasticSearchAddress : this.elasticSearchAddressList) {
            String[] elasticSearchAddressParts = elasticSearchAddress.split(":");
            String elasticSearchHostName = elasticSearchAddressParts[0];
            int elasticSearchPort = Integer.parseInt(elasticSearchAddressParts[1]);
            hosts.add(new HttpHost(elasticSearchHostName, elasticSearchPort, this.sslEnable ? "https" : "http"));
        }
        return hosts;
    }

    private void buildClient() throws NoSuchFieldException, IllegalAccessException {
        ElasticsearchClientFactory.ClientBuilder esClienBuilder = ElasticsearchClientFactory.builder();
        if (this.sslTrustAllCertificates) {
            SSLContext sslContext;
            try {
                sslContext = SSLContext.getInstance("SSL");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            try {
                sslContext.init(null, new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }}, new SecureRandom());
                esClienBuilder.sslContext(sslContext);
            }
            catch (KeyManagementException e) {
                LOGGER.error("Error creating SSL Context for trust all certificates", (Throwable)e);
            }
        }
        this.esClient = esClienBuilder.hosts(this.getHosts()).socketTimeout(this.clientSocketTimeout).usernameAndPassword(this.username, this.password).build();
        this.buildBulkIngester();
        LOGGER.info("Connecting to ElasticSearch persistence backend using index prefix {}...", (Object)this.indexPrefix);
    }

    public BulkIngester buildBulkIngester() {
        String backoffPolicyStr;
        int concurrentRequests;
        if (this.bulkIngester != null) {
            return this.bulkIngester;
        }
        BulkListener<String> listener = new BulkListener<String>(){

            public void beforeBulk(long executionId, BulkRequest request, List<String> strings) {
                LOGGER.debug("Before Bulk");
            }

            public void afterBulk(long executionId, BulkRequest request, List<String> strings, BulkResponse response) {
                LOGGER.debug("After Bulk");
            }

            public void afterBulk(long executionId, BulkRequest request, List<String> strings, Throwable failure) {
                LOGGER.error("After Bulk (failure)", failure);
            }
        };
        BulkIngester.Builder ingesterBuilder = new BulkIngester.Builder().client(this.esClient).maxOperations(100).flushInterval(1L, TimeUnit.SECONDS).listener((BulkListener)listener);
        if (this.bulkProcessorConcurrentRequests != null && (concurrentRequests = Integer.parseInt(this.bulkProcessorConcurrentRequests)) > 1) {
            ingesterBuilder.maxConcurrentRequests(concurrentRequests);
        }
        if (this.bulkProcessorBulkActions != null) {
            int bulkActions = Integer.parseInt(this.bulkProcessorBulkActions);
            ingesterBuilder.maxOperations(bulkActions);
        }
        if (this.bulkProcessorBulkSize != null) {
            ingesterBuilder.maxSize(this.bulkProcessorBulkSize * 1024L * 1024L);
        }
        if (this.bulkProcessorFlushIntervalInSeconds != null) {
            ingesterBuilder.flushInterval(this.bulkProcessorFlushIntervalInSeconds.longValue(), TimeUnit.SECONDS);
        } else {
            ingesterBuilder.flushInterval(5L, TimeUnit.SECONDS);
        }
        if (this.bulkProcessorBackoffPolicy != null && (backoffPolicyStr = this.bulkProcessorBackoffPolicy) != null && backoffPolicyStr.length() > 0) {
            if ("nobackoff".equals(backoffPolicyStr = backoffPolicyStr.toLowerCase())) {
                ingesterBuilder.backoffPolicy(BackoffPolicy.noBackoff());
            } else if (backoffPolicyStr.startsWith("constant(")) {
                int paramStartPos = backoffPolicyStr.indexOf("constant(" + "constant(".length());
                int paramEndPos = backoffPolicyStr.indexOf(")", paramStartPos);
                int paramSeparatorPos = backoffPolicyStr.indexOf(",", paramStartPos);
                Long delay = Long.valueOf(backoffPolicyStr.substring(paramStartPos, paramSeparatorPos));
                int maxNumberOfRetries = Integer.parseInt(backoffPolicyStr.substring(paramSeparatorPos + 1, paramEndPos));
                ingesterBuilder.backoffPolicy(BackoffPolicy.constantBackoff((Long)(delay != null ? delay : 5000L), (int)maxNumberOfRetries));
            } else if (backoffPolicyStr.startsWith("exponential")) {
                if (!backoffPolicyStr.contains("(")) {
                    ingesterBuilder.backoffPolicy(BackoffPolicy.exponentialBackoff());
                } else {
                    int paramStartPos = backoffPolicyStr.indexOf("exponential(" + "exponential(".length());
                    int paramEndPos = backoffPolicyStr.indexOf(")", paramStartPos);
                    int paramSeparatorPos = backoffPolicyStr.indexOf(",", paramStartPos);
                    Long delay = Long.valueOf(backoffPolicyStr.substring(paramStartPos, paramSeparatorPos));
                    int maxNumberOfRetries = Integer.parseInt(backoffPolicyStr.substring(paramSeparatorPos + 1, paramEndPos));
                    ingesterBuilder.backoffPolicy(BackoffPolicy.exponentialBackoff((Long)(delay != null ? delay : 5000L), (int)maxNumberOfRetries));
                }
            }
        }
        this.bulkIngester = ingesterBuilder.build();
        return this.bulkIngester;
    }

    public void stop() {
        new InClassLoaderExecute<Object>(null, null, this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Object execute(Object ... args) throws IOException {
                LOGGER.info("Closing ElasticSearch persistence backend...");
                if (ElasticSearchPersistenceServiceImpl.this.esClient != null) {
                    ElasticSearchPersistenceServiceImpl.this.esClient.close();
                }
                return null;
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
        this.bundleContext.removeBundleListener((BundleListener)this);
    }

    public void bindConditionESQueryBuilder(ServiceReference<ConditionESQueryBuilder> conditionESQueryBuilderServiceReference) {
        ConditionESQueryBuilder conditionESQueryBuilder = (ConditionESQueryBuilder)this.bundleContext.getService(conditionESQueryBuilderServiceReference);
        this.conditionESQueryBuilderDispatcher.addQueryBuilder(conditionESQueryBuilderServiceReference.getProperty("queryBuilderId").toString(), conditionESQueryBuilder);
    }

    public void unbindConditionESQueryBuilder(ServiceReference<ConditionESQueryBuilder> conditionESQueryBuilderServiceReference) {
        if (conditionESQueryBuilderServiceReference == null) {
            return;
        }
        this.conditionESQueryBuilderDispatcher.removeQueryBuilder(conditionESQueryBuilderServiceReference.getProperty("queryBuilderId").toString());
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 128: {
                this.loadPredefinedMappings(event.getBundle().getBundleContext(), true);
                this.loadPainlessScripts(event.getBundle().getBundleContext());
            }
        }
    }

    private void loadPredefinedMappings(BundleContext bundleContext, boolean forceUpdateMapping) {
        Enumeration predefinedMappings = bundleContext.getBundle().findEntries("META-INF/cxs/mappings", "*.json", true);
        if (predefinedMappings == null) {
            return;
        }
        while (predefinedMappings.hasMoreElements()) {
            URL predefinedMappingURL = (URL)predefinedMappings.nextElement();
            LOGGER.info("Found mapping at {}, loading... ", (Object)predefinedMappingURL);
            try {
                String path = predefinedMappingURL.getPath();
                String name = path.substring(path.lastIndexOf(47) + 1, path.lastIndexOf(46));
                String mappingSource = this.loadMappingFile(predefinedMappingURL);
                this.mappings.put(name, mappingSource);
                if (this.createIndex(name)) continue;
                LOGGER.info("Found index for type {}", (Object)name);
                if (!forceUpdateMapping) continue;
                LOGGER.info("Updating mapping for {}", (Object)name);
                this.createMapping(name, mappingSource);
            }
            catch (Exception e) {
                LOGGER.error("Error while loading mapping definition {}", (Object)predefinedMappingURL, (Object)e);
            }
        }
    }

    private void loadPainlessScripts(BundleContext bundleContext) {
        Enumeration scriptsURL = bundleContext.getBundle().findEntries("META-INF/cxs/painless", "*.painless", true);
        if (scriptsURL == null) {
            return;
        }
        HashMap<String, String> scriptsById = new HashMap<String, String>();
        while (scriptsURL.hasMoreElements()) {
            URL scriptURL = (URL)scriptsURL.nextElement();
            LOGGER.info("Found painless script at {}, loading... ", (Object)scriptURL);
            try {
                InputStream in = scriptURL.openStream();
                try {
                    String script = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
                    String scriptId = FilenameUtils.getBaseName((String)scriptURL.getPath());
                    scriptsById.put(scriptId, script);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            catch (Exception e) {
                LOGGER.error("Error while loading painless script {}", (Object)scriptURL, (Object)e);
            }
        }
        this.storeScripts(scriptsById);
    }

    private String loadMappingFile(URL predefinedMappingURL) throws IOException {
        String l;
        BufferedReader reader = new BufferedReader(new InputStreamReader(predefinedMappingURL.openStream()));
        StringBuilder content = new StringBuilder();
        while ((l = reader.readLine()) != null) {
            content.append(l);
        }
        return content.toString();
    }

    public String getName() {
        return "elasticsearch";
    }

    public <T extends Item> List<T> getAllItems(Class<T> clazz) {
        return this.getAllItems(clazz, 0, -1, null).getList();
    }

    public long getAllItemsCount(String itemType) {
        return this.queryCount(Query.of(q -> q.matchAll(m -> m)), itemType);
    }

    public <T extends Item> PartialList<T> getAllItems(Class<T> clazz, int offset, int size, String sortBy) {
        return this.getAllItems(clazz, offset, size, sortBy, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Item> PartialList<T> getAllItems(Class<T> clazz, int offset, int size, String sortBy, String scrollTimeValidity) {
        long startTime = System.currentTimeMillis();
        try {
            PartialList<T> partialList = this.query(Query.of(q -> q.matchAll(m -> m)), sortBy, clazz, offset, size, null, scrollTimeValidity);
            return partialList;
        }
        finally {
            if (this.metricsService != null && this.metricsService.isActivated()) {
                this.metricsService.updateTimer(this.getClass().getName() + ".getAllItems", startTime);
            }
        }
    }

    public <T extends Item> T load(String itemId, Class<T> clazz) {
        return this.load(itemId, clazz, null);
    }

    @Deprecated
    public <T extends Item> T load(String itemId, Date dateHint, Class<T> clazz) {
        return this.load(itemId, clazz, null);
    }

    @Deprecated
    public CustomItem loadCustomItem(String itemId, Date dateHint, String customItemType) {
        return this.load(itemId, CustomItem.class, customItemType);
    }

    public CustomItem loadCustomItem(String itemId, String customItemType) {
        return this.load(itemId, CustomItem.class, customItemType);
    }

    private <T extends Item> T load(final String itemId, final Class<T> clazz, final String customItemType) {
        if (StringUtils.isEmpty((CharSequence)itemId)) {
            return null;
        }
        return (T)((Item)new InClassLoaderExecute<T>(this.metricsService, this.getClass().getName() + ".loadItem", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected T execute(Object ... args) throws Exception {
                try {
                    boolean sessionSpecialDirectAccess;
                    String itemType = customItemType != null ? customItemType : Item.getItemType((Class)clazz);
                    final String documentId = ElasticSearchPersistenceServiceImpl.this.getDocumentIDForItemType(itemId, itemType);
                    boolean bl = sessionSpecialDirectAccess = ElasticSearchPersistenceServiceImpl.this.sessionLatestIndex != null && "session".equals(itemType);
                    if (!sessionSpecialDirectAccess && ElasticSearchPersistenceServiceImpl.this.isItemTypeRollingOver(itemType)) {
                        return new MetricAdapter<T>(ElasticSearchPersistenceServiceImpl.this.metricsService, ".loadItemWithQuery"){

                            public T execute(Object ... args) throws Exception {
                                Query query = Query.of(q -> q.ids(builder -> builder.values(documentId, new String[0])));
                                if (customItemType == null) {
                                    PartialList r = ElasticSearchPersistenceServiceImpl.this.query(query, null, clazz, 0, 1, null, null);
                                    if (r.size() > 0) {
                                        return (Item)r.get(0);
                                    }
                                } else {
                                    PartialList<CustomItem> r = ElasticSearchPersistenceServiceImpl.this.query(query, null, customItemType, 0, 1, null, null);
                                    if (r.size() > 0) {
                                        return (Item)r.get(0);
                                    }
                                }
                                return null;
                            }
                        }.execute(new Object[0]);
                    }
                    GetRequest getRequest = GetRequest.of(builder -> builder.index(sessionSpecialDirectAccess ? ElasticSearchPersistenceServiceImpl.this.sessionLatestIndex : ElasticSearchPersistenceServiceImpl.this.getIndex(itemType)).id(documentId));
                    GetResponse response = ElasticSearchPersistenceServiceImpl.this.esClient.get(getRequest, clazz);
                    if (response.found()) {
                        Item value = (Item)response.source();
                        ElasticSearchPersistenceServiceImpl.this.setMetadata(value, response.id(), response.version() != null ? response.version() : 0L, response.seqNo() != null ? response.seqNo() : 0L, response.primaryTerm() != null ? response.primaryTerm() : 0L, response.index());
                        return value;
                    }
                    return null;
                }
                catch (ElasticsearchException e) {
                    if (e.status() == 404 && e.getMessage() != null && e.getMessage().contains("index_not_found_exception")) {
                        return null;
                    }
                    return null;
                }
                catch (Exception ex) {
                    throw new Exception("Error loading itemType=" + clazz.getName() + " customItemType=" + customItemType + " itemId=" + itemId, ex);
                }
            }
        }.catchingExecuteInClassLoader(true, new Object[0]));
    }

    private void setMetadata(Item item, String itemId, long version, long seqNo, long primaryTerm, String index) {
        if (!systemItems.contains(item.getItemType()) && item.getItemId() == null) {
            item.setItemId(itemId);
        }
        item.setVersion(Long.valueOf(version));
        item.setSystemMetadata(SEQ_NO, (Object)seqNo);
        item.setSystemMetadata(PRIMARY_TERM, (Object)primaryTerm);
        item.setSystemMetadata("index", (Object)index);
    }

    public boolean isConsistent(Item item) {
        return this.getRefreshPolicy(item.getItemType()) != Refresh.False;
    }

    public boolean save(Item item) {
        return this.save(item, this.useBatchingForSave, this.alwaysOverwrite);
    }

    public boolean save(Item item, boolean useBatching) {
        return this.save(item, useBatching, this.alwaysOverwrite);
    }

    public boolean save(final Item item, Boolean useBatchingOption, Boolean alwaysOverwriteOption) {
        final boolean useBatching = useBatchingOption == null ? this.useBatchingForSave : useBatchingOption;
        final boolean alwaysOverwrite = alwaysOverwriteOption == null ? this.alwaysOverwrite : alwaysOverwriteOption;
        Boolean result = (Boolean)new InClassLoaderExecute<Boolean>(this.metricsService, this.getClass().getName() + ".saveItem", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Boolean execute(Object ... args) throws Exception {
                try {
                    block10: {
                        Long primaryTerm;
                        Long seqNo;
                        String itemType = item.getItemType();
                        if (item instanceof CustomItem) {
                            itemType = ((CustomItem)item).getCustomItemType();
                        }
                        String documentId = ElasticSearchPersistenceServiceImpl.this.getDocumentIDForItemType(item.getItemId(), itemType);
                        String index = item.getSystemMetadata("index") != null ? (String)item.getSystemMetadata("index") : ElasticSearchPersistenceServiceImpl.this.getIndex(itemType);
                        OpType opType = null;
                        if (!alwaysOverwrite) {
                            seqNo = (Long)item.getSystemMetadata(ElasticSearchPersistenceServiceImpl.SEQ_NO);
                            primaryTerm = (Long)item.getSystemMetadata(ElasticSearchPersistenceServiceImpl.PRIMARY_TERM);
                            opType = seqNo == null && primaryTerm == null ? OpType.Create : null;
                        } else {
                            primaryTerm = null;
                            seqNo = null;
                        }
                        String routing = ElasticSearchPersistenceServiceImpl.this.routingByType.containsKey(itemType) ? ElasticSearchPersistenceServiceImpl.this.routingByType.get(itemType) : null;
                        try {
                            if (ElasticSearchPersistenceServiceImpl.this.bulkIngester == null || !useBatching) {
                                IndexRequest.Builder indexRequestBuilder = new IndexRequest.Builder().index(index).id(documentId).document((Object)item).ifSeqNo(seqNo).ifPrimaryTerm(primaryTerm).opType(opType).routing(routing).refresh(ElasticSearchPersistenceServiceImpl.this.getRefreshPolicy(itemType));
                                IndexResponse response = ElasticSearchPersistenceServiceImpl.this.esClient.index(indexRequestBuilder.build());
                                String responseIndex = response.index();
                                String itemId = response.id();
                                ElasticSearchPersistenceServiceImpl.this.setMetadata(item, itemId, response.version(), response.seqNo() != null ? response.seqNo() : 0L, response.primaryTerm() != null ? response.primaryTerm() : 0L, responseIndex);
                                if ("session".equals(itemType) && ElasticSearchPersistenceServiceImpl.this.sessionLatestIndex != null && response.result().equals((Object)Result.Created) && !responseIndex.equals(ElasticSearchPersistenceServiceImpl.this.sessionLatestIndex)) {
                                    ElasticSearchPersistenceServiceImpl.this.sessionLatestIndex = responseIndex;
                                }
                            } else {
                                BulkOperation bulkOp = opType == OpType.Create ? BulkOperation.of(b -> b.create(c -> (ObjectBuilder)((CreateOperation.Builder)((CreateOperation.Builder)((CreateOperation.Builder)((CreateOperation.Builder)c.index(index)).id(documentId)).document((Object)item).ifSeqNo(seqNo)).ifPrimaryTerm(primaryTerm)).routing(routing))) : BulkOperation.of(b -> b.index(i -> (ObjectBuilder)((IndexOperation.Builder)((IndexOperation.Builder)((IndexOperation.Builder)((IndexOperation.Builder)i.index(index)).id(documentId)).document((Object)item).ifSeqNo(seqNo)).ifPrimaryTerm(primaryTerm)).routing(routing)));
                                ElasticSearchPersistenceServiceImpl.this.bulkIngester.add(bulkOp);
                            }
                            ElasticSearchPersistenceServiceImpl.this.logMetadataItemOperation("saved", item);
                        }
                        catch (ElasticsearchException e) {
                            if (e.status() != 404 || e.getMessage() == null || !e.getMessage().contains("index_not_found_exception")) break block10;
                            LOGGER.error("Could not find index {}, could not register item type {} with id {} ", new Object[]{index, itemType, item.getItemId(), e});
                            return false;
                        }
                    }
                    return true;
                }
                catch (IOException e) {
                    throw new Exception("Error saving item " + String.valueOf(item), e);
                }
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
        return Objects.requireNonNullElse(result, false);
    }

    public boolean update(Item item, Date dateHint, Class clazz, String propertyName, Object propertyValue) {
        return this.update(item, clazz, propertyName, propertyValue);
    }

    public boolean update(Item item, Date dateHint, Class clazz, Map source) {
        return this.update(item, clazz, source);
    }

    public boolean update(Item item, Date dateHint, Class clazz, Map source, boolean alwaysOverwrite) {
        return this.update(item, clazz, source, alwaysOverwrite);
    }

    public boolean update(Item item, Class clazz, String propertyName, Object propertyValue) {
        return this.update(item, clazz, Collections.singletonMap(propertyName, propertyValue), this.alwaysOverwrite);
    }

    public boolean update(Item item, Class clazz, Map source) {
        return this.update(item, clazz, source, this.alwaysOverwrite);
    }

    public boolean update(final Item item, final Class clazz, final Map source, final boolean alwaysOverwrite) {
        Boolean result = (Boolean)new InClassLoaderExecute<Boolean>(this.metricsService, this.getClass().getName() + ".updateItem", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Boolean execute(Object ... args) throws Exception {
                try {
                    UpdateRequest<Object, Object> updateRequest = ElasticSearchPersistenceServiceImpl.this.createUpdateRequest(clazz, item, source, alwaysOverwrite);
                    if (ElasticSearchPersistenceServiceImpl.this.bulkIngester == null || !ElasticSearchPersistenceServiceImpl.this.useBatchingForUpdate) {
                        UpdateResponse<Object> response = ElasticSearchPersistenceServiceImpl.this.esClient.update(updateRequest, clazz);
                        ElasticSearchPersistenceServiceImpl.this.setMetadata(item, response.id(), response.version(), response.seqNo() != null ? response.seqNo() : 0L, response.primaryTerm() != null ? response.primaryTerm() : 0L, response.index());
                    } else {
                        BulkOperation bulkOp = BulkOperation.of(builder -> builder.update(u -> (ObjectBuilder)((UpdateOperation.Builder)((UpdateOperation.Builder)((UpdateOperation.Builder)((UpdateOperation.Builder)u.index(updateRequest.index())).id(updateRequest.id())).action(b -> b.doc(updateRequest.doc())).ifSeqNo(updateRequest.ifSeqNo())).ifPrimaryTerm(updateRequest.ifPrimaryTerm())).routing(updateRequest.routing())));
                        ElasticSearchPersistenceServiceImpl.this.bulkIngester.add(bulkOp);
                    }
                    ElasticSearchPersistenceServiceImpl.this.logMetadataItemOperation("updated", item);
                    return true;
                }
                catch (ElasticsearchException e) {
                    if (e.getMessage().contains("index_not_found_exception")) {
                        throw new Exception("No index found for itemType=" + clazz.getName() + " itemId=" + item.getItemId(), e);
                    }
                    throw e;
                }
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
        return Objects.requireNonNullElse(result, false);
    }

    private UpdateRequest<Object, Object> createUpdateRequest(Class<?> clazz, Item item, Map<String, Object> source, boolean alwaysOverwrite) {
        String itemType = Item.getItemType(clazz);
        String documentId = this.getDocumentIDForItemType(item.getItemId(), itemType);
        String index = item.getSystemMetadata("index") != null ? (String)item.getSystemMetadata("index") : this.getIndex(itemType);
        UpdateRequest.Builder builder = new UpdateRequest.Builder().index(index).id(documentId).doc(source);
        if (!alwaysOverwrite) {
            Long seqNo = (Long)item.getSystemMetadata(SEQ_NO);
            Long primaryTerm = (Long)item.getSystemMetadata(PRIMARY_TERM);
            if (seqNo != null && primaryTerm != null) {
                builder.ifSeqNo(seqNo);
                builder.ifPrimaryTerm(primaryTerm);
            }
        }
        return builder.build();
    }

    public List<String> update(final Map<Item, Map> items, Date dateHint, final Class clazz) {
        if (items.isEmpty()) {
            return new ArrayList<String>();
        }
        List result = (List)new InClassLoaderExecute<List<String>>(this.metricsService, this.getClass().getName() + ".updateItems", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected List<String> execute(Object ... args) throws Exception {
                long batchRequestStartTime = System.currentTimeMillis();
                ArrayList operations = new ArrayList();
                items.forEach((item, source) -> {
                    UpdateRequest<Object, Object> updateRequest = ElasticSearchPersistenceServiceImpl.this.createUpdateRequest(clazz, (Item)item, (Map<String, Object>)source, ElasticSearchPersistenceServiceImpl.this.alwaysOverwrite);
                    BulkOperation bulkOp = BulkOperation.of(builder -> builder.update(u -> (ObjectBuilder)((UpdateOperation.Builder)((UpdateOperation.Builder)((UpdateOperation.Builder)((UpdateOperation.Builder)u.index(updateRequest.index())).id(updateRequest.id())).action(b -> b.doc(updateRequest.doc())).ifSeqNo(updateRequest.ifSeqNo())).ifPrimaryTerm(updateRequest.ifPrimaryTerm())).routing(updateRequest.routing())));
                    operations.add(bulkOp);
                });
                BulkRequest bulkRequest = new BulkRequest.Builder().operations(operations).build();
                BulkResponse bulkResponse = ElasticSearchPersistenceServiceImpl.this.esClient.bulk(bulkRequest);
                LOGGER.debug("{} profiles updated with bulk segment in {}ms", (Object)bulkRequest.operations().size(), (Object)(System.currentTimeMillis() - batchRequestStartTime));
                ArrayList<String> failedItemsIds = new ArrayList<String>();
                if (bulkResponse.items().stream().anyMatch(item -> item.error() != null)) {
                    bulkResponse.items().forEach(item -> {
                        if (item.error() != null) {
                            failedItemsIds.add(item.id());
                        }
                    });
                }
                return failedItemsIds;
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
        return result;
    }

    public boolean updateWithQueryAndScript(Date dateHint, Class<?> clazz, String[] scripts, Map<String, Object>[] scriptParams, Condition[] conditions) {
        return this.updateWithQueryAndScript(clazz, scripts, scriptParams, conditions);
    }

    public boolean updateWithQueryAndScript(Class<?> clazz, String[] scripts, Map<String, Object>[] scriptParams, Condition[] conditions) {
        Script[] builtScripts = new Script[scripts.length];
        for (int i = 0; i < scripts.length; ++i) {
            Map<String, JsonData> jsonDataParams = scriptParams[i].entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> JsonData.of(entry.getValue())));
            int finalI = i;
            builtScripts[i] = Script.of(s -> s.lang(ScriptLanguage.Painless).source(ScriptSource.of(scriptSourceBuilder -> scriptSourceBuilder.scriptString(scripts[finalI]))).params(jsonDataParams));
        }
        return this.updateWithQueryAndScript(new Class[]{clazz}, builtScripts, conditions, true);
    }

    public boolean updateWithQueryAndStoredScript(Date dateHint, Class<?> clazz, String[] scripts, Map<String, Object>[] scriptParams, Condition[] conditions) {
        return this.updateWithQueryAndStoredScript(new Class[]{clazz}, scripts, scriptParams, conditions, true);
    }

    public boolean updateWithQueryAndStoredScript(Class<?> clazz, String[] scripts, Map<String, Object>[] scriptParams, Condition[] conditions) {
        return this.updateWithQueryAndStoredScript(new Class[]{clazz}, scripts, scriptParams, conditions, true);
    }

    public boolean updateWithQueryAndStoredScript(Class<?>[] classes, String[] scripts, Map<String, Object>[] scriptParams, Condition[] conditions, boolean waitForComplete) {
        Script[] builtScripts = new Script[scripts.length];
        for (int i = 0; i < scripts.length; ++i) {
            int finalI = i;
            Map<String, JsonData> jsonDataParams = scriptParams[i].entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> JsonData.of(entry.getValue())));
            builtScripts[i] = Script.of(s -> s.id(scripts[finalI]).params(jsonDataParams));
        }
        return this.updateWithQueryAndScript(classes, builtScripts, conditions, waitForComplete);
    }

    private boolean updateWithQueryAndScript(final Class<?>[] classes, final Script[] scripts, final Condition[] conditions, final boolean waitForComplete) {
        Boolean result = (Boolean)new InClassLoaderExecute<Boolean>(this.metricsService, this.getClass().getName() + ".updateWithQueryAndScript", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Boolean execute(Object ... args) throws Exception {
                CharSequence[] itemTypes = (String[])Arrays.stream(classes).map(Item::getItemType).toArray(String[]::new);
                String[] indices = (String[])Arrays.stream(itemTypes).map(itemType -> ElasticSearchPersistenceServiceImpl.this.getIndexNameForQuery((String)itemType)).toArray(String[]::new);
                try {
                    for (int i = 0; i < scripts.length; ++i) {
                        ElasticSearchPersistenceServiceImpl.this.esClient.indices().refresh(r -> r.index(Arrays.asList(indices)));
                        Query query = ElasticSearchPersistenceServiceImpl.this.conditionESQueryBuilderDispatcher.buildFilter(conditions[i]);
                        int finalI = i;
                        UpdateByQueryRequest updateByQueryRequest = UpdateByQueryRequest.of(arg_0 -> this.lambda$execute$5(indices, scripts, finalI, (String[])itemTypes, query, arg_0));
                        UpdateByQueryResponse response = ElasticSearchPersistenceServiceImpl.this.esClient.updateByQuery(updateByQueryRequest);
                        if (response.task() == null) {
                            LOGGER.error("update with query and script: no response returned for query: {}", (Object)query);
                            continue;
                        }
                        if (waitForComplete) {
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("Waiting task [{}]: [{}] using query: [{}], polling every {}ms with a timeout configured to {}ms", new Object[]{response.task(), updateByQueryRequest, updateByQueryRequest.query(), ElasticSearchPersistenceServiceImpl.this.taskWaitingPollingInterval, ElasticSearchPersistenceServiceImpl.this.taskWaitingTimeout});
                            }
                            ElasticSearchPersistenceServiceImpl.this.waitForTaskComplete(response.task());
                            continue;
                        }
                        LOGGER.debug("ES task started {}", (Object)response.task());
                    }
                    return true;
                }
                catch (ElasticsearchException e) {
                    if (e.status() == 404 && e.getMessage() != null && e.getMessage().contains("index_not_found_exception")) {
                        throw new Exception("No index found for itemTypes=" + String.join((CharSequence)",", itemTypes), e);
                    }
                    LOGGER.error("Error in the update script : {}\n{}", new Object[]{e.response().toString(), e.getMessage(), e});
                    throw new Exception("Error in the update script");
                }
            }

            private /* synthetic */ ObjectBuilder lambda$execute$5(String[] indices, Script[] scripts2, int finalI, String[] itemTypes, Query query, UpdateByQueryRequest.Builder builder) {
                return builder.index(List.of(indices)).conflicts(Conflicts.Proceed).waitForCompletion(Boolean.valueOf(false)).slices(Slices.of(s -> s.value(2))).script(scripts2[finalI]).query(ElasticSearchPersistenceServiceImpl.this.wrapWithItemsTypeQuery(itemTypes, query));
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
        if (result == null) {
            return false;
        }
        return result;
    }

    private void waitForTaskComplete(final String task) {
        final long start = System.currentTimeMillis();
        new InClassLoaderExecute<Void>(this.metricsService, this.getClass().getName() + ".waitForTask", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Void execute(Object ... args) throws Exception {
                block5: {
                    GetTasksResponse tasksResponse;
                    while ((tasksResponse = ElasticSearchPersistenceServiceImpl.this.esClient.tasks().get(GetTasksRequest.of(builder -> builder.taskId(task)))) != null) {
                        long taskId = tasksResponse.task().id();
                        if (tasksResponse.completed()) {
                            if (!LOGGER.isDebugEnabled()) break block5;
                            long millis = tasksResponse.task().runningTimeInNanos() / 1000000L;
                            long seconds = millis / 1000L;
                            LOGGER.debug("Waiting task [{}]: Finished in {} {}", new Object[]{taskId, seconds >= 1L ? seconds : millis, seconds >= 1L ? "seconds" : "milliseconds"});
                            break block5;
                        }
                        if (start + (long)ElasticSearchPersistenceServiceImpl.this.taskWaitingTimeout.intValue() < System.currentTimeMillis()) {
                            LOGGER.error("Waiting task [{}]: Exceeded configured timeout ({}ms), aborting wait process", (Object)taskId, (Object)ElasticSearchPersistenceServiceImpl.this.taskWaitingTimeout);
                            break block5;
                        }
                        try {
                            Thread.sleep(ElasticSearchPersistenceServiceImpl.this.taskWaitingPollingInterval.intValue());
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new IllegalStateException("Waiting task [" + taskId + "]: interrupted");
                        }
                    }
                    LOGGER.error("Waiting task [{}]: No task found", (Object)task);
                }
                return null;
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
    }

    public boolean storeScripts(final Map<String, String> scripts) {
        Boolean result = (Boolean)new InClassLoaderExecute<Boolean>(this.metricsService, this.getClass().getName() + ".storeScripts", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Boolean execute(Object ... args) throws Exception {
                boolean executedSuccessfully = true;
                for (Map.Entry script : scripts.entrySet()) {
                    try {
                        PutScriptRequest putScriptRequest = PutScriptRequest.of(p -> p.id((String)script.getKey()).script(StoredScript.of(s -> s.lang("painless").source(ScriptSource.of(builder -> builder.scriptString((String)script.getValue()))))));
                        PutScriptResponse response = ElasticSearchPersistenceServiceImpl.this.esClient.putScript(putScriptRequest);
                        boolean acknowledged = response.acknowledged();
                        executedSuccessfully &= acknowledged;
                        if (acknowledged) {
                            LOGGER.info("Successfully stored painless script: {}", script.getKey());
                            continue;
                        }
                        LOGGER.error("Failed to store painless script: {}", script.getKey());
                    }
                    catch (Exception e) {
                        LOGGER.error("Exception while storing painless script: {}", script.getKey(), (Object)e);
                        executedSuccessfully = false;
                    }
                }
                return executedSuccessfully;
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
        return Objects.requireNonNullElse(result, false);
    }

    public boolean updateWithScript(Item item, Date dateHint, Class<?> clazz, String script, Map<String, Object> scriptParams) {
        return this.updateWithScript(item, clazz, script, scriptParams);
    }

    public boolean updateWithScript(final Item item, final Class<?> clazz, final String script, final Map<String, Object> scriptParams) {
        Boolean result = (Boolean)new InClassLoaderExecute<Boolean>(this.metricsService, this.getClass().getName() + ".updateWithScript", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Boolean execute(Object ... args) throws Exception {
                try {
                    String itemType = Item.getItemType((Class)clazz);
                    String index = ElasticSearchPersistenceServiceImpl.this.getIndex(itemType);
                    String documentId = ElasticSearchPersistenceServiceImpl.this.getDocumentIDForItemType(item.getItemId(), itemType);
                    Map<String, JsonData> jsonDataParams = scriptParams.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> JsonData.of(entry.getValue())));
                    Script actualScript = Script.of(s -> s.lang(ScriptLanguage.Painless).source(ScriptSource.of(scriptSourceBuilder -> scriptSourceBuilder.scriptString(script))).params(jsonDataParams));
                    if (ElasticSearchPersistenceServiceImpl.this.bulkIngester != null) {
                        UpdateOperation.Builder updateOperation = ((UpdateOperation.Builder)((UpdateOperation.Builder)((UpdateOperation.Builder)((UpdateOperation.Builder)new UpdateOperation.Builder().index(index)).id(documentId)).ifSeqNo((Long)item.getSystemMetadata(ElasticSearchPersistenceServiceImpl.SEQ_NO))).ifPrimaryTerm((Long)item.getSystemMetadata(ElasticSearchPersistenceServiceImpl.PRIMARY_TERM))).action(UpdateAction.of(action -> action.script(actualScript)));
                        BulkOperation operation = BulkOperation.of(op -> op.update(updateOperation.build()));
                        ElasticSearchPersistenceServiceImpl.this.bulkIngester.add(operation);
                    } else {
                        UpdateRequest updateRequest = new UpdateRequest.Builder().index(index).id(documentId).ifSeqNo((Long)item.getSystemMetadata(ElasticSearchPersistenceServiceImpl.SEQ_NO)).ifPrimaryTerm((Long)item.getSystemMetadata(ElasticSearchPersistenceServiceImpl.PRIMARY_TERM)).script(actualScript).build();
                        UpdateResponse response = ElasticSearchPersistenceServiceImpl.this.esClient.update(updateRequest, clazz);
                        ElasticSearchPersistenceServiceImpl.this.setMetadata(item, response.id(), response.version(), response.seqNo(), response.primaryTerm(), response.index());
                    }
                    return true;
                }
                catch (ElasticsearchException e) {
                    if (e.status() == 404 && e.getMessage() != null && e.getMessage().contains("index_not_found_exception")) {
                        throw new Exception("No index found for itemType=" + clazz.getName() + "itemId=" + item.getItemId(), e);
                    }
                    throw new Exception("Error during update with script", e);
                }
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
        return Objects.requireNonNullElse(result, false);
    }

    public <T extends Item> boolean remove(String itemId, Class<T> clazz) {
        return this.remove(itemId, clazz, null);
    }

    public boolean removeCustomItem(String itemId, String customItemType) {
        return this.remove(itemId, CustomItem.class, customItemType);
    }

    private <T extends Item> boolean remove(final String itemId, final Class<T> clazz, final String customItemType) {
        Boolean result = (Boolean)new InClassLoaderExecute<Boolean>(this.metricsService, this.getClass().getName() + ".removeItem", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Boolean execute(Object ... args) throws Exception {
                try {
                    String itemType = Item.getItemType((Class)clazz);
                    if (customItemType != null) {
                        itemType = customItemType;
                    }
                    String documentId = ElasticSearchPersistenceServiceImpl.this.getDocumentIDForItemType(itemId, itemType);
                    String index = ElasticSearchPersistenceServiceImpl.this.getIndexNameForQuery(itemType);
                    ElasticSearchPersistenceServiceImpl.this.esClient.delete(DeleteRequest.of(builder -> builder.index(index).id(documentId)));
                    if (MetadataItem.class.isAssignableFrom(clazz)) {
                        LOGGER.info("Item of type {} with ID {} has been removed", (Object)(customItemType != null ? customItemType : clazz.getSimpleName()), (Object)itemId);
                    }
                    return true;
                }
                catch (Exception e) {
                    throw new Exception("Cannot remove", e);
                }
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
        return Objects.requireNonNullElse(result, false);
    }

    public <T extends Item> boolean removeByQuery(final Condition query, final Class<T> clazz) {
        Boolean result = (Boolean)new InClassLoaderExecute<Boolean>(this.metricsService, this.getClass().getName() + ".removeByQuery", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Boolean execute(Object ... args) throws Exception {
                Query esQuery = ElasticSearchPersistenceServiceImpl.this.conditionESQueryBuilderDispatcher.getQueryBuilder(query);
                return ElasticSearchPersistenceServiceImpl.this.removeByQuery(esQuery, clazz);
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
        return Objects.requireNonNullElse(result, false);
    }

    public <T extends Item> boolean removeByQuery(Query query, Class<T> clazz) throws Exception {
        try {
            String itemType = Item.getItemType(clazz);
            LOGGER.debug("Remove item of type {} using a query", (Object)itemType);
            DeleteByQueryRequest deleteByQueryRequest = DeleteByQueryRequest.of(builder -> builder.index(this.getIndexNameForQuery(itemType), new String[0]).conflicts(Conflicts.Proceed).query(this.wrapWithItemTypeQuery(itemType, query)).timeout(Time.of(t -> t.time(this.removeByQueryTimeoutInMinutes + "m"))).waitForCompletion(Boolean.valueOf(false)));
            DeleteByQueryResponse deleteByQueryResponse = this.esClient.deleteByQuery(deleteByQueryRequest);
            String task = deleteByQueryResponse.task();
            if (task == null) {
                LOGGER.error("Remove by query: no response returned for query: {}", (Object)query);
                return false;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Waiting task [{}]: [{}] using query: [{}], polling every {}ms with a timeout configured to {}ms", new Object[]{task, deleteByQueryRequest, deleteByQueryRequest.query(), this.taskWaitingPollingInterval, this.taskWaitingTimeout});
            }
            this.waitForTaskComplete(task);
            return true;
        }
        catch (Exception e) {
            throw new Exception("Cannot remove by query", e);
        }
    }

    public boolean indexTemplateExists(final String templateName) {
        Boolean result = (Boolean)new InClassLoaderExecute<Boolean>(this.metricsService, this.getClass().getName() + ".indexTemplateExists", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Boolean execute(Object ... args) throws IOException {
                return ElasticSearchPersistenceServiceImpl.this.esClient.indices().existsIndexTemplate(ExistsIndexTemplateRequest.of(builder -> builder.name(templateName))).value();
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
        return Objects.requireNonNullElse(result, false);
    }

    public boolean removeIndexTemplate(final String templateName) {
        Boolean result = (Boolean)new InClassLoaderExecute<Boolean>(this.metricsService, this.getClass().getName() + ".removeIndexTemplate", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Boolean execute(Object ... args) throws IOException {
                DeleteIndexTemplateRequest deleteIndexTemplateRequest = DeleteIndexTemplateRequest.of(builder -> builder.name(templateName, new String[0]));
                return ElasticSearchPersistenceServiceImpl.this.esClient.indices().deleteIndexTemplate(deleteIndexTemplateRequest).acknowledged();
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
        return Objects.requireNonNullElse(result, false);
    }

    public void registerRolloverLifecyclePolicy() {
        new InClassLoaderExecute<Boolean>(this.metricsService, this.getClass().getName() + ".createLifecyclePolicy", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Boolean execute(Object ... args) throws IOException {
                RolloverAction.Builder rolloverActionBuilder = new RolloverAction.Builder();
                if (StringUtils.isNotEmpty((CharSequence)ElasticSearchPersistenceServiceImpl.this.rolloverMaxAge)) {
                    rolloverActionBuilder.maxAge(new Time.Builder().time(ElasticSearchPersistenceServiceImpl.this.rolloverMaxAge).build());
                }
                if (StringUtils.isNotEmpty((CharSequence)ElasticSearchPersistenceServiceImpl.this.rolloverMaxSize)) {
                    rolloverActionBuilder.maxSize(ElasticSearchPersistenceServiceImpl.this.rolloverMaxSize);
                }
                if (StringUtils.isNotEmpty((CharSequence)ElasticSearchPersistenceServiceImpl.this.rolloverMaxDocs)) {
                    rolloverActionBuilder.maxDocs(Long.valueOf(Long.parseLong(ElasticSearchPersistenceServiceImpl.this.rolloverMaxDocs)));
                }
                RolloverAction rolloverAction = rolloverActionBuilder.build();
                Phase hotPhase = new Phase.Builder().actions(new Actions.Builder().rollover(rolloverAction).build()).minAge(new Time.Builder().time("0ms").build()).build();
                IlmPolicy ilmPolicy = new IlmPolicy.Builder().phases(new Phases.Builder().hot(hotPhase).build()).build();
                PutLifecycleRequest request = new PutLifecycleRequest.Builder().policy(ilmPolicy).name(ElasticSearchPersistenceServiceImpl.this.indexPrefix + "-unomi-rollover-policy").build();
                PutLifecycleResponse response = ElasticSearchPersistenceServiceImpl.this.esClient.ilm().putLifecycle(request);
                return response.acknowledged();
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
    }

    public boolean createIndex(final String itemType) {
        LOGGER.debug("Create index {}", (Object)itemType);
        Boolean result = (Boolean)new InClassLoaderExecute<Boolean>(this.metricsService, this.getClass().getName() + ".createIndex", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Boolean execute(Object ... args) throws IOException {
                String index = ElasticSearchPersistenceServiceImpl.this.getIndex(itemType);
                BooleanResponse indexExists = ElasticSearchPersistenceServiceImpl.this.esClient.indices().exists(ExistsRequest.of(builder -> builder.index(index, new String[0])));
                if (!indexExists.value()) {
                    if (ElasticSearchPersistenceServiceImpl.this.isItemTypeRollingOver(itemType)) {
                        ElasticSearchPersistenceServiceImpl.this.internalCreateRolloverTemplate(itemType);
                        ElasticSearchPersistenceServiceImpl.this.internalCreateRolloverIndex(index);
                    } else {
                        ElasticSearchPersistenceServiceImpl.this.internalCreateIndex(index, ElasticSearchPersistenceServiceImpl.this.mappings.get(itemType));
                    }
                }
                return !indexExists.value();
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
        return Objects.requireNonNullElse(result, false);
    }

    public boolean removeIndex(String itemType) {
        final String index = this.getIndex(itemType);
        Boolean result = (Boolean)new InClassLoaderExecute<Boolean>(this.metricsService, this.getClass().getName() + ".removeIndex", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Boolean execute(Object ... args) throws IOException {
                boolean indexExists = ElasticSearchPersistenceServiceImpl.this.esClient.indices().existsIndexTemplate(ExistsIndexTemplateRequest.of(builder -> builder.name(index))).value();
                if (indexExists) {
                    ElasticSearchPersistenceServiceImpl.this.esClient.indices().delete(DeleteIndexRequest.of(builder -> builder.index(index, new String[0])));
                }
                return indexExists;
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
        return Objects.requireNonNullElse(result, false);
    }

    private void internalCreateRolloverTemplate(String itemName) throws IOException {
        if (!this.mappings.containsKey(itemName)) {
            LOGGER.warn("Couldn't find mapping for item {}, won't create monthly index template", (Object)itemName);
            return;
        }
        String rolloverAlias = this.buildRolloverAlias(itemName);
        IndexSettingsAnalysis analysis = this.buildAnalysis();
        IndexSettings indexSettings = this.buildIndexSettings(rolloverAlias, analysis);
        IndexTemplateMapping templateMapping = this.buildTemplateMapping(itemName, indexSettings);
        PutIndexTemplateRequest request = PutIndexTemplateRequest.of(builder -> builder.name(rolloverAlias + "-rollover-template").indexPatterns(Collections.singletonList(this.getRolloverIndexForQuery(itemName))).template(templateMapping).priority(Long.valueOf(1L)));
        this.esClient.indices().putIndexTemplate(request);
    }

    private String buildRolloverAlias(String itemName) {
        return this.indexPrefix + "-" + itemName;
    }

    private IndexSettingsAnalysis buildAnalysis() {
        return IndexSettingsAnalysis.of(an -> an.analyzer("folding", analyserBuilder -> analyserBuilder.custom(CustomAnalyzer.of(customAnalyzer -> customAnalyzer.tokenizer("keyword").filter("lowercase", new String[]{"asciifolding"})))));
    }

    private IndexSettings buildIndexSettings(String rolloverAlias, IndexSettingsAnalysis analysis) {
        return IndexSettings.of(builder -> builder.index(indexBuilder -> indexBuilder.numberOfShards(this.rolloverIndexNumberOfShards).numberOfReplicas(this.rolloverIndexNumberOfReplicas).mapping(MappingLimitSettings.of(limitBuilder -> limitBuilder.totalFields(MappingLimitSettingsTotalFields.of(totalFieldLimitBuilder -> totalFieldLimitBuilder.limit(this.rolloverIndexMappingTotalFieldsLimit))))).maxDocvalueFieldsSearch(Integer.valueOf(this.rolloverIndexMaxDocValueFieldsSearch)).lifecycle(lifecycleBuilder -> lifecycleBuilder.name(this.indexPrefix + "-unomi-rollover-policy").rolloverAlias(rolloverAlias))).analysis(analysis));
    }

    private IndexTemplateMapping buildTemplateMapping(String itemName, IndexSettings indexSettings) {
        return IndexTemplateMapping.of(templateMappingBuilder -> templateMappingBuilder.settings(indexSettings).mappings(mappingsBuilder -> (ObjectBuilder)mappingsBuilder.withJson((InputStream)new ByteArrayInputStream(this.mappings.get(itemName).getBytes(StandardCharsets.UTF_8)))));
    }

    private void internalCreateRolloverIndex(String indexName) throws IOException {
        CreateIndexResponse createIndexResponse = this.esClient.indices().create(CreateIndexRequest.of(builder -> builder.index(indexName + "-000001").aliases(indexName, Alias.of(aliasBuilder -> aliasBuilder.isWriteIndex(Boolean.valueOf(true))))));
        LOGGER.info("Index created: [{}], acknowledge: [{}], shards acknowledge: [{}]", new Object[]{createIndexResponse.index(), createIndexResponse.acknowledged(), createIndexResponse.shardsAcknowledged()});
    }

    private void internalCreateIndex(String indexName, String mappingSource) throws IOException {
        IndexSettings indexSettings = IndexSettings.of(builder -> builder.numberOfShards(this.numberOfShards).numberOfReplicas(this.numberOfReplicas).mapping(MappingLimitSettings.of(limitBuilder -> limitBuilder.totalFields(MappingLimitSettingsTotalFields.of(totalFieldLimitBuilder -> totalFieldLimitBuilder.limit(this.indexMappingTotalFieldsLimit))))).maxDocvalueFieldsSearch(Integer.valueOf(this.indexMaxDocValueFieldsSearch)).analysis(this.buildAnalysis()));
        CreateIndexRequest.Builder createIndexRequestBuilder = new CreateIndexRequest.Builder();
        createIndexRequestBuilder.index(indexName).settings(indexSettings);
        if (mappingSource != null) {
            createIndexRequestBuilder.mappings(mappingsBuilder -> (ObjectBuilder)mappingsBuilder.withJson((InputStream)new ByteArrayInputStream(mappingSource.getBytes(StandardCharsets.UTF_8))));
        }
        CreateIndexResponse createIndexResponse = this.esClient.indices().create(createIndexRequestBuilder.build());
        LOGGER.info("Index created: [{}], acknowledge: [{}], shards acknowledge: [{}]", new Object[]{createIndexResponse.index(), createIndexResponse.acknowledged(), createIndexResponse.shardsAcknowledged()});
    }

    public void createMapping(String type, String source) {
        try {
            this.putMapping(source, this.getIndex(type));
        }
        catch (IOException ioe) {
            LOGGER.error("Error while creating mapping for type {} and source {}", new Object[]{type, source, ioe});
        }
    }

    public void setPropertyMapping(PropertyType property, String itemType) {
        try {
            Map subMappings;
            Map subSubMappings;
            Map<String, Map<String, Object>> mappings = this.getPropertiesMapping(itemType);
            if (mappings == null) {
                mappings = new HashMap<String, Map<String, Object>>();
            }
            if ((subSubMappings = (Map)(subMappings = mappings.computeIfAbsent("properties", k -> new HashMap())).computeIfAbsent("properties", k -> new HashMap())).containsKey(property.getItemId())) {
                LOGGER.warn("Mapping already exists for type {} and property {}", (Object)itemType, (Object)property.getItemId());
                return;
            }
            Map<String, Object> propertyMapping = this.createPropertyMapping(property);
            if (propertyMapping.isEmpty()) {
                return;
            }
            this.mergePropertiesMapping(subSubMappings, propertyMapping);
            HashMap<String, Map<String, Map<String, Object>>> mappingsWrapper = new HashMap<String, Map<String, Map<String, Object>>>();
            mappingsWrapper.put("properties", mappings);
            String mappingsSource = ESCustomObjectMapper.getObjectMapper().writeValueAsString(mappingsWrapper);
            this.putMapping(mappingsSource, this.getIndex(itemType));
        }
        catch (IOException ioe) {
            LOGGER.error("Error while creating mapping for type {} and property {}", new Object[]{itemType, property.getValueTypeId(), ioe});
        }
    }

    private Map<String, Object> createPropertyMapping(PropertyType property) {
        String esType = this.convertValueTypeToESType(property.getValueTypeId());
        HashMap<String, Object> definition = new HashMap<String, Object>();
        if (esType == null) {
            LOGGER.warn("No predefined type found for property[{}], no mapping will be created", (Object)property.getValueTypeId());
            return Collections.emptyMap();
        }
        definition.put("type", esType);
        if ("text".equals(esType)) {
            definition.put("analyzer", "folding");
            HashMap fields = new HashMap();
            HashMap<String, Object> keywordField = new HashMap<String, Object>();
            keywordField.put("type", "keyword");
            keywordField.put("ignore_above", 256);
            fields.put("keyword", keywordField);
            definition.put("fields", fields);
        }
        if ("set".equals(property.getValueTypeId())) {
            HashMap childProperties = new HashMap();
            property.getChildPropertyTypes().forEach(childType -> {
                Map<String, Object> propertyMapping = this.createPropertyMapping((PropertyType)childType);
                if (!propertyMapping.isEmpty()) {
                    this.mergePropertiesMapping(childProperties, propertyMapping);
                }
            });
            definition.put("properties", childProperties);
        }
        return Collections.singletonMap(property.getItemId(), definition);
    }

    private String convertValueTypeToESType(String valueTypeId) {
        switch (valueTypeId) {
            case "set": 
            case "json": {
                return "object";
            }
            case "boolean": {
                return "boolean";
            }
            case "geopoint": {
                return "geo_point";
            }
            case "integer": {
                return "integer";
            }
            case "long": {
                return "long";
            }
            case "float": {
                return "float";
            }
            case "date": {
                return "date";
            }
            case "string": 
            case "id": 
            case "email": {
                return "text";
            }
        }
        return null;
    }

    private void putMapping(final String source, final String indexName) throws IOException {
        new InClassLoaderExecute<Boolean>(this.metricsService, this.getClass().getName() + ".putMapping", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Boolean execute(Object ... args) throws Exception {
                try {
                    PutMappingResponse putMappingResponse = ElasticSearchPersistenceServiceImpl.this.esClient.indices().putMapping(PutMappingRequest.of(builder -> (ObjectBuilder)builder.index(indexName, new String[0]).withJson((InputStream)new ByteArrayInputStream(source.getBytes(StandardCharsets.UTF_8)))));
                    return putMappingResponse.acknowledged();
                }
                catch (Exception e) {
                    throw new Exception("Cannot create/update mapping", e);
                }
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
    }

    public Map<String, Map<String, Object>> getPropertiesMapping(final String itemType) {
        return (Map)new InClassLoaderExecute<Map<String, Map<String, Object>>>(this.metricsService, this.getClass().getName() + ".getPropertiesMapping", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Map<String, Map<String, Object>> execute(Object ... args) throws Exception {
                GetMappingRequest getMappingsRequest = GetMappingRequest.of(r -> r.index(ElasticSearchPersistenceServiceImpl.this.getIndexNameForQuery(itemType), new String[0]));
                GetMappingResponse getMappingsResponse = ElasticSearchPersistenceServiceImpl.this.esClient.indices().getMapping(getMappingsRequest);
                Map mappings = getMappingsResponse.mappings();
                TreeSet orderedKeys = new TreeSet(mappings.keySet());
                HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
                try {
                    for (String key : orderedKeys) {
                        TypeMapping typeMapping;
                        if (!mappings.containsKey(key) || (typeMapping = ((IndexMappingRecord)mappings.get(key)).mappings()) == null || typeMapping.properties() == null) continue;
                        Map properties = typeMapping.properties();
                        HashMap<String, Map<String, Object>> propertiesMap = new HashMap<String, Map<String, Object>>();
                        for (Map.Entry entry : properties.entrySet()) {
                            propertiesMap.put((String)entry.getKey(), ElasticSearchPersistenceServiceImpl.this.propertyToMap((Property)entry.getValue()));
                        }
                        for (Map.Entry entry : propertiesMap.entrySet()) {
                            if (result.containsKey(entry.getKey())) {
                                Map subResult = (Map)result.get(entry.getKey());
                                for (Map.Entry subentry : ((Map)entry.getValue()).entrySet()) {
                                    if (subResult.containsKey(subentry.getKey()) && subResult.get(subentry.getKey()) instanceof Map && subentry.getValue() instanceof Map) {
                                        ElasticSearchPersistenceServiceImpl.this.mergePropertiesMapping((Map)subResult.get(subentry.getKey()), (Map)subentry.getValue());
                                        continue;
                                    }
                                    subResult.put((String)subentry.getKey(), subentry.getValue());
                                }
                                continue;
                            }
                            result.put((String)entry.getKey(), (Map)entry.getValue());
                        }
                    }
                }
                catch (Throwable t) {
                    throw new Exception("Cannot get mapping for itemType=" + itemType, t);
                }
                return result;
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
    }

    private Map<String, Object> propertyToMap(Property property) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonpMapper mapper = ((ElasticsearchTransport)this.esClient._transport()).jsonpMapper();
            JsonGenerator generator = mapper.jsonProvider().createGenerator((OutputStream)baos);
            mapper.serialize((Object)property, generator);
            generator.close();
            String json = baos.toString(StandardCharsets.UTF_8);
            ObjectMapper jackson = new ObjectMapper();
            return (Map)jackson.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (Exception e) {
            return new HashMap<String, Object>();
        }
    }

    private void mergePropertiesMapping(Map<String, Object> result, Map<String, Object> entry) {
        if (entry == null || entry.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Object> subentry : entry.entrySet()) {
            if (result.containsKey(subentry.getKey()) && result.get(subentry.getKey()) instanceof Map && subentry.getValue() instanceof Map) {
                this.mergePropertiesMapping((Map)result.get(subentry.getKey()), (Map)subentry.getValue());
                continue;
            }
            result.put(subentry.getKey(), subentry.getValue());
        }
    }

    public Map<String, Object> getPropertyMapping(String property, String itemType) {
        Map<String, Map<String, Object>> mappings = this.knownMappings.get(itemType);
        Map<String, Object> result = this.getPropertyMapping(property, mappings);
        if (result == null) {
            mappings = this.getPropertiesMapping(itemType);
            this.knownMappings.put(itemType, mappings);
            result = this.getPropertyMapping(property, mappings);
        }
        return result;
    }

    private Map<String, Object> getPropertyMapping(String property, Map<String, Map<String, Object>> mappings) {
        Map<String, Object> propMapping = null;
        String[] properties = StringUtils.split((String)property, (char)'.');
        for (int i = 0; i < properties.length && mappings != null; ++i) {
            String s = properties[i];
            propMapping = mappings.get(s);
            if (i == properties.length - 1) {
                return propMapping;
            }
            mappings = propMapping != null ? (Map)propMapping.get("properties") : null;
        }
        return null;
    }

    private String getPropertyNameWithData(String name, String itemType) {
        Map<String, Object> propertyMapping = this.getPropertyMapping((String)name, itemType);
        if (propertyMapping == null) {
            return null;
        }
        if ("text".equals(propertyMapping.get("type")) && propertyMapping.containsKey("fields") && ((Map)propertyMapping.get("fields")).containsKey("keyword")) {
            name = (String)name + ".keyword";
        }
        return name;
    }

    public boolean isValidCondition(Condition condition, Item item) {
        try {
            this.conditionEvaluatorDispatcher.eval(condition, item);
            Query.of(q -> q.bool(builder -> builder.must(mustBuilder -> mustBuilder.ids(IdsQuery.of(ids -> ids.values(item.getItemId(), new String[0])))).must(this.conditionESQueryBuilderDispatcher.buildFilter(condition), new Query[0])));
        }
        catch (Exception e) {
            LOGGER.error("Failed to validate condition. See debug log level for more information");
            LOGGER.debug("Failed to validate condition, condition={}", (Object)condition, (Object)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testMatch(Condition query, Item item) {
        long startTime = System.currentTimeMillis();
        try {
            boolean bl = this.conditionEvaluatorDispatcher.eval(query, item);
            return bl;
        }
        catch (UnsupportedOperationException e) {
            LOGGER.error("Eval not supported, continue with query", (Throwable)e);
        }
        finally {
            if (this.metricsService != null && this.metricsService.isActivated()) {
                this.metricsService.updateTimer(this.getClass().getName() + ".testMatchLocally", startTime);
            }
        }
        startTime = System.currentTimeMillis();
        try {
            Class<?> clazz = item.getClass();
            String itemType = Item.getItemType(clazz);
            String documentId = this.getDocumentIDForItemType(item.getItemId(), itemType);
            Query esQuery = Query.of(q -> q.bool(builder -> builder.must(mustBuilder -> mustBuilder.ids(IdsQuery.of(ids -> ids.values(documentId, new String[0])))).must(this.conditionESQueryBuilderDispatcher.buildFilter(query), new Query[0])));
            boolean bl = this.queryCount(esQuery, itemType) > 0L;
            return bl;
        }
        finally {
            if (this.metricsService != null && this.metricsService.isActivated()) {
                this.metricsService.updateTimer(this.getClass().getName() + ".testMatchInElasticSearch", startTime);
            }
        }
    }

    public <T extends Item> List<T> query(Condition query, String sortBy, Class<T> clazz) {
        return this.query(query, sortBy, clazz, 0, -1).getList();
    }

    public <T extends Item> PartialList<T> query(Condition query, String sortBy, Class<T> clazz, int offset, int size) {
        return this.query(this.conditionESQueryBuilderDispatcher.getQueryBuilder(query), sortBy, clazz, offset, size, null, null);
    }

    public <T extends Item> PartialList<T> query(Condition query, String sortBy, Class<T> clazz, int offset, int size, String scrollTimeValidity) {
        return this.query(this.conditionESQueryBuilderDispatcher.getQueryBuilder(query), sortBy, clazz, offset, size, null, scrollTimeValidity);
    }

    public PartialList<CustomItem> queryCustomItem(Condition query, String sortBy, String customItemType, int offset, int size, String scrollTimeValidity) {
        return this.query(this.conditionESQueryBuilderDispatcher.getQueryBuilder(query), sortBy, customItemType, offset, size, null, scrollTimeValidity);
    }

    public <T extends Item> PartialList<T> queryFullText(String fulltext, Condition query, String sortBy, Class<T> clazz, int offset, int size) {
        return this.query(Query.of(builder -> builder.bool(boolBuilder -> boolBuilder.must(mustBuilder -> mustBuilder.queryString(qsBuilder -> qsBuilder.query(fulltext))).filter(this.conditionESQueryBuilderDispatcher.getQueryBuilder(query), new Query[0]))), sortBy, clazz, offset, size, null, null);
    }

    public <T extends Item> List<T> query(String fieldName, String fieldValue, String sortBy, Class<T> clazz) {
        return this.query(fieldName, fieldValue, sortBy, clazz, 0, -1).getList();
    }

    public <T extends Item> List<T> query(String fieldName, String[] fieldValues, String sortBy, Class<T> clazz) {
        Query termQuery = Query.of(builder -> builder.terms(t -> t.field(fieldName).terms(TermsQueryField.of(termsBuilder -> termsBuilder.value(Arrays.stream(fieldValues).map(fieldValue -> FieldValue.of(ConditionContextHelper.foldToASCII((String)fieldValue))).toList())))));
        return this.query(termQuery, sortBy, clazz, 0, -1, this.getRouting(fieldName, fieldValues, clazz), null).getList();
    }

    public <T extends Item> PartialList<T> query(String fieldName, String fieldValue, String sortBy, Class<T> clazz, int offset, int size) {
        Query termQuery = Query.of(builder -> builder.terms(t -> t.field(fieldName).terms(TermsQueryField.of(termsBuilder -> termsBuilder.value(List.of(FieldValue.of(ConditionContextHelper.foldToASCII((String)fieldValue))))))));
        return this.query(termQuery, sortBy, clazz, offset, size, this.getRouting(fieldName, new String[]{fieldValue}, clazz), null);
    }

    public <T extends Item> PartialList<T> queryFullText(String fieldName, String fieldValue, String fulltext, String sortBy, Class<T> clazz, int offset, int size) {
        Query query = Query.of(q -> q.bool(b -> b.must(Query.of(qs -> qs.queryString(qsq -> qsq.query(fulltext))), new Query[0]).must(Query.of(t -> t.term(term -> term.field(fieldName).value(fieldValue))), new Query[0])));
        return this.query(query, sortBy, clazz, offset, size, this.getRouting(fieldName, new String[]{fieldValue}, clazz), null);
    }

    public <T extends Item> PartialList<T> queryFullText(String fulltext, String sortBy, Class<T> clazz, int offset, int size) {
        return this.query(Query.of(q -> q.queryString(qs -> qs.query(fulltext))), sortBy, clazz, offset, size, null, null);
    }

    public long queryCount(Condition query, String itemType) {
        try {
            return this.conditionESQueryBuilderDispatcher.count(query);
        }
        catch (UnsupportedOperationException e) {
            try {
                Query filter = this.conditionESQueryBuilderDispatcher.buildFilter(query);
                if (filter.isIds()) {
                    return filter.ids().values().size();
                }
                return this.queryCount(filter, itemType);
            }
            catch (UnsupportedOperationException e1) {
                return -1L;
            }
        }
    }

    private long queryCount(final Query query, final String itemType) {
        return (Long)new InClassLoaderExecute<Long>(this.metricsService, this.getClass().getName() + ".queryCount", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Long execute(Object ... args) throws IOException {
                CountRequest countRequest = CountRequest.of(builder -> builder.index(ElasticSearchPersistenceServiceImpl.this.getIndexNameForQuery(itemType), new String[0]).query(ElasticSearchPersistenceServiceImpl.this.wrapWithItemTypeQuery(itemType, query)));
                return ElasticSearchPersistenceServiceImpl.this.esClient.count(countRequest).count();
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
    }

    private <T extends Item> PartialList<T> query(Query query, String sortBy, Class<T> clazz, int offset, int size, String[] routing, String scrollTimeValidity) {
        return this.query(query, sortBy, clazz, null, offset, size, routing, scrollTimeValidity);
    }

    private PartialList<CustomItem> query(Query query, String sortBy, String customItemType, int offset, int size, String[] routing, String scrollTimeValidity) {
        return this.query(query, sortBy, CustomItem.class, customItemType, offset, size, routing, scrollTimeValidity);
    }

    private <T extends Item> PartialList<T> query(final Query query, final String sortBy, final Class<T> clazz, final String customItemType, final int offset, final int size, final String[] routing, final String scrollTimeValidity) {
        return (PartialList)new InClassLoaderExecute<PartialList<T>>(this.metricsService, this.getClass().getName() + ".query", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected PartialList<T> execute(Object ... args) throws Exception {
                ArrayList<Item> results = new ArrayList<Item>();
                String scrollIdentifier = null;
                long totalHits = 0L;
                PartialList.Relation totalHitsRelation = PartialList.Relation.EQUAL;
                try {
                    String itemType = customItemType != null ? customItemType : Item.getItemType((Class)clazz);
                    int limit = size < 0 ? ElasticSearchPersistenceServiceImpl.this.defaultQueryLimit : size;
                    SearchRequest.Builder searchRequest = new SearchRequest.Builder();
                    searchRequest.index(ElasticSearchPersistenceServiceImpl.this.getIndexNameForQuery(itemType), new String[0]).from(Integer.valueOf(offset)).size(Integer.valueOf(limit)).query(ElasticSearchPersistenceServiceImpl.this.wrapWithItemTypeQuery(itemType, query)).seqNoPrimaryTerm(Boolean.valueOf(true)).source(src -> src.fetch(Boolean.valueOf(true)));
                    Time keepAlive = Time.of(t -> t.time("1h"));
                    if (scrollTimeValidity != null) {
                        keepAlive = Time.of(t -> t.time(scrollTimeValidity.isBlank() ? "1h" : scrollTimeValidity));
                        searchRequest.scroll(keepAlive);
                    }
                    if (size == Integer.MIN_VALUE) {
                        searchRequest.size(ElasticSearchPersistenceServiceImpl.this.defaultQueryLimit);
                    } else if (size != -1) {
                        searchRequest.size(Integer.valueOf(size));
                    } else {
                        searchRequest.scroll(keepAlive);
                    }
                    if (routing != null) {
                        searchRequest.routing(String.join((CharSequence)",", routing));
                    }
                    if (sortBy != null) {
                        String[] sortByArray = sortBy.split(",");
                        for (String sortByElement : sortByArray) {
                            if (sortByElement.startsWith("geo:")) {
                                String[] elements = sortByElement.split(":");
                                GeoLocation location = GeoLocation.of(g -> g.latlon(latlon -> latlon.lat(Double.parseDouble(elements[2])).lon(Double.parseDouble(elements[3]))));
                                SortOrder order = elements.length > 4 && "desc".equals(elements[4]) ? SortOrder.Desc : SortOrder.Asc;
                                GeoDistanceSort geoSort = GeoDistanceSort.of(g -> g.field(elements[1]).location(location, new GeoLocation[0]).unit(DistanceUnit.Kilometers).order(order));
                                searchRequest.sort(s -> s.geoDistance(geoSort));
                                continue;
                            }
                            String name = ElasticSearchPersistenceServiceImpl.this.getPropertyNameWithData(StringUtils.substringBeforeLast((String)sortByElement, (String)":"), itemType);
                            if (name == null) continue;
                            SortOrder sortOrder = sortByElement.endsWith(":desc") ? SortOrder.Desc : SortOrder.Asc;
                            searchRequest.sort(s -> s.field(f -> f.field(name).order(sortOrder)));
                        }
                    }
                    searchRequest.version(Boolean.valueOf(true));
                    SearchResponse response = ElasticSearchPersistenceServiceImpl.this.esClient.search(searchRequest.build(), clazz);
                    if (size == -1) {
                        List hits = response.hits().hits();
                        String scrollId = response.scrollId();
                        while (!hits.isEmpty()) {
                            for (Hit hit : hits) {
                                Item value = (Item)hit.source();
                                ElasticSearchPersistenceServiceImpl.this.setMetadata(value, hit.id(), hit.version(), hit.seqNo(), hit.primaryTerm(), hit.index());
                                results.add(value);
                            }
                            ScrollRequest scrollRequest = new ScrollRequest.Builder().scrollId(scrollId).scroll(keepAlive).build();
                            ScrollResponse scrollResponse = ElasticSearchPersistenceServiceImpl.this.esClient.scroll(scrollRequest, clazz);
                            hits = scrollResponse.hits().hits();
                            scrollId = scrollResponse.scrollId();
                        }
                        ElasticSearchPersistenceServiceImpl.this.esClient.clearScroll(new ClearScrollRequest.Builder().scrollId(response.scrollId(), new String[0]).build());
                    } else {
                        totalHits = response.hits().total() != null ? response.hits().total().value() : 0L;
                        totalHitsRelation = ElasticSearchPersistenceServiceImpl.this.getTotalHitsRelation(response.hits().total());
                        scrollIdentifier = response.scrollId();
                        if (scrollIdentifier != null && totalHits == 0L) {
                            ClearScrollRequest clearScrollRequest = new ClearScrollRequest.Builder().scrollId(scrollIdentifier, new String[0]).build();
                            ElasticSearchPersistenceServiceImpl.this.esClient.clearScroll(clearScrollRequest);
                        }
                        for (Hit hit : response.hits().hits()) {
                            Item value = (Item)hit.source();
                            ElasticSearchPersistenceServiceImpl.this.setMetadata(value, hit.id(), hit.version() != null ? hit.version() : 0L, hit.seqNo() != null ? hit.seqNo() : 0L, hit.primaryTerm() != null ? hit.primaryTerm() : 0L, hit.index());
                            results.add(value);
                        }
                    }
                }
                catch (Exception t2) {
                    throw new Exception("Error loading itemType=" + clazz.getName() + " query=" + String.valueOf(query) + " sortBy=" + sortBy, t2);
                }
                PartialList result = new PartialList(results, (long)offset, (long)size, totalHits, totalHitsRelation);
                if (scrollIdentifier != null && totalHits != 0L) {
                    result.setScrollIdentifier(scrollIdentifier);
                    result.setScrollTimeValidity(scrollTimeValidity);
                }
                return result;
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
    }

    private PartialList.Relation getTotalHitsRelation(TotalHits totalHits) {
        return TotalHitsRelation.Gte.equals((Object)totalHits.relation()) ? PartialList.Relation.GREATER_THAN_OR_EQUAL_TO : PartialList.Relation.EQUAL;
    }

    public <T extends Item> PartialList<T> continueScrollQuery(final Class<T> clazz, final String scrollIdentifier, final String scrollTimeValidity) {
        return (PartialList)new InClassLoaderExecute<PartialList<T>>(this.metricsService, this.getClass().getName() + ".continueScrollQuery", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected PartialList<T> execute(Object ... args) throws Exception {
                ArrayList<Item> results = new ArrayList<Item>();
                long totalHits = 0L;
                try {
                    Time keepAlive = Time.of(t -> t.time(scrollTimeValidity.isBlank() ? "10m" : scrollTimeValidity));
                    ScrollRequest scrollRequest = new ScrollRequest.Builder().scrollId(scrollIdentifier).scroll(keepAlive).build();
                    ScrollResponse scrollResponse = ElasticSearchPersistenceServiceImpl.this.esClient.scroll(scrollRequest, clazz);
                    if (scrollResponse.hits().hits().isEmpty()) {
                        ClearScrollRequest clearScrollRequest = new ClearScrollRequest.Builder().scrollId(scrollResponse.scrollId(), new String[0]).build();
                        ElasticSearchPersistenceServiceImpl.this.esClient.clearScroll(clearScrollRequest);
                    } else {
                        for (Hit hit : scrollResponse.hits().hits()) {
                            Item value = (Item)hit.source();
                            ElasticSearchPersistenceServiceImpl.this.setMetadata(value, hit.id(), hit.version() != null ? hit.version() : 0L, hit.seqNo() != null ? hit.seqNo() : 0L, hit.primaryTerm() != null ? hit.primaryTerm() : 0L, hit.index());
                            results.add(value);
                        }
                    }
                    if (scrollResponse.hits().total() != null) {
                        totalHits = scrollResponse.hits().total().value();
                    }
                    PartialList result = new PartialList(results, 0L, (long)scrollResponse.hits().hits().size(), totalHits, ElasticSearchPersistenceServiceImpl.this.getTotalHitsRelation(scrollResponse.hits().total()));
                    if (scrollIdentifier != null) {
                        result.setScrollIdentifier(scrollIdentifier);
                        result.setScrollTimeValidity(scrollTimeValidity);
                    }
                    return result;
                }
                catch (Exception t2) {
                    throw new Exception("Error continuing scrolling query for itemType=" + clazz.getName() + " scrollIdentifier=" + scrollIdentifier + " scrollTimeValidity=" + scrollTimeValidity, t2);
                }
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
    }

    public PartialList<CustomItem> continueCustomItemScrollQuery(final String customItemType, final String scrollIdentifier, final String scrollTimeValidity) {
        return (PartialList)new InClassLoaderExecute<PartialList<CustomItem>>(this.metricsService, this.getClass().getName() + ".continueScrollQuery", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected PartialList<CustomItem> execute(Object ... args) throws Exception {
                ArrayList<CustomItem> results = new ArrayList<CustomItem>();
                long totalHits = 0L;
                try {
                    Time keepAlive = Time.of(t -> t.time(scrollTimeValidity.isBlank() ? "10m" : scrollTimeValidity));
                    ScrollRequest scrollRequest = new ScrollRequest.Builder().scrollId(scrollIdentifier).scroll(keepAlive).build();
                    ScrollResponse<CustomItem> scrollResponse = ElasticSearchPersistenceServiceImpl.this.esClient.scroll(scrollRequest, CustomItem.class);
                    if (scrollResponse.hits().hits().isEmpty()) {
                        ClearScrollRequest clearScrollRequest = new ClearScrollRequest.Builder().scrollId(scrollResponse.scrollId(), new String[0]).build();
                        ElasticSearchPersistenceServiceImpl.this.esClient.clearScroll(clearScrollRequest);
                    } else {
                        for (Hit hit : scrollResponse.hits().hits()) {
                            CustomItem value = (CustomItem)hit.source();
                            ElasticSearchPersistenceServiceImpl.this.setMetadata((Item)value, hit.id(), hit.version() != null ? hit.version() : 0L, hit.seqNo() != null ? hit.seqNo() : 0L, hit.primaryTerm() != null ? hit.primaryTerm() : 0L, hit.index());
                            results.add(value);
                        }
                    }
                    if (scrollResponse.hits().total() != null) {
                        totalHits = scrollResponse.hits().total().value();
                    }
                    PartialList result = new PartialList(results, 0L, (long)scrollResponse.hits().hits().size(), totalHits, ElasticSearchPersistenceServiceImpl.this.getTotalHitsRelation(scrollResponse.hits().total()));
                    if (scrollIdentifier != null) {
                        result.setScrollIdentifier(scrollIdentifier);
                        result.setScrollTimeValidity(scrollTimeValidity);
                    }
                    return result;
                }
                catch (Exception t2) {
                    throw new Exception("Error continuing scrolling query for itemType=" + customItemType + " scrollIdentifier=" + scrollIdentifier + " scrollTimeValidity=" + scrollTimeValidity, t2);
                }
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
    }

    @Deprecated
    public Map<String, Long> aggregateQuery(Condition filter, BaseAggregate aggregate, String itemType) {
        return this.aggregateQuery(filter, aggregate, itemType, false, this.aggregateQueryBucketSize);
    }

    public Map<String, Long> aggregateWithOptimizedQuery(Condition filter, BaseAggregate aggregate, String itemType) {
        return this.aggregateQuery(filter, aggregate, itemType, true, this.aggregateQueryBucketSize);
    }

    public Map<String, Long> aggregateWithOptimizedQuery(Condition filter, BaseAggregate aggregate, String itemType, int size) {
        return this.aggregateQuery(filter, aggregate, itemType, true, size);
    }

    private Map<String, Long> aggregateQuery(final Condition filter, final BaseAggregate aggregate, final String itemType, final boolean optimizedQuery, final int queryBucketSize) {
        return (Map)new InClassLoaderExecute<Map<String, Long>>(this.metricsService, this.getClass().getName() + ".aggregateQuery", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Map<String, Long> execute(Object ... args) throws IOException {
                SearchResponse<Void> response;
                LinkedHashMap<String, Long> results = new LinkedHashMap<String, Long>();
                Map<String, Aggregation> aggregationsByType = new HashMap<String, Aggregation>();
                if (aggregate != null) {
                    Aggregation bucketsAggregation = null;
                    String fieldName = aggregate.getField();
                    if (aggregate instanceof DateAggregate) {
                        DateAggregate dateAggregate = (DateAggregate)aggregate;
                        DateHistogramAggregation.Builder dateHistogramBuilder = new DateHistogramAggregation.Builder().field(fieldName).calendarInterval(CalendarInterval.valueOf((String)dateAggregate.getIntervalByAlias(dateAggregate.getInterval())));
                        if (dateAggregate.getFormat() != null) {
                            dateHistogramBuilder.format(dateAggregate.getFormat());
                        }
                        bucketsAggregation = new Aggregation.Builder().dateHistogram(dateHistogramBuilder.build()).build();
                    } else if (aggregate instanceof NumericRangeAggregate) {
                        NumericRangeAggregate numericRangeAggregate = (NumericRangeAggregate)aggregate;
                        ArrayList<AggregationRange> ranges = new ArrayList<AggregationRange>();
                        for (NumericRange numericRange : numericRangeAggregate.getRanges()) {
                            if (numericRange == null) continue;
                            ranges.add(AggregationRange.of(builder -> builder.from(numericRange.getFrom()).to(numericRange.getTo()).key(numericRange.getKey())));
                        }
                        RangeAggregation rangeAgg = new RangeAggregation.Builder().field(fieldName).ranges(ranges).build();
                        bucketsAggregation = new Aggregation.Builder().range(rangeAgg).build();
                    } else if (aggregate instanceof DateRangeAggregate) {
                        DateRangeAggregate dateRangeAggregate = (DateRangeAggregate)aggregate;
                        ArrayList<DateRangeExpression> dateRanges = new ArrayList<DateRangeExpression>();
                        for (Object range : dateRangeAggregate.getDateRanges()) {
                            if (range == null) continue;
                            DateRangeExpression.Builder exprBuilder = new DateRangeExpression.Builder();
                            if (range.getKey() != null) {
                                exprBuilder.key(range.getKey());
                            }
                            if (range.getFrom() != null) {
                                exprBuilder.from(FieldDateMath.of(arg_0 -> 28.lambda$execute$1((DateRange)range, arg_0)));
                            }
                            if (range.getTo() != null) {
                                exprBuilder.to(FieldDateMath.of(arg_0 -> 28.lambda$execute$2((DateRange)range, arg_0)));
                            }
                            dateRanges.add(exprBuilder.build());
                        }
                        DateRangeAggregation.Builder dateRangeBuilder = new DateRangeAggregation.Builder().field(fieldName).ranges(dateRanges);
                        if (dateRangeAggregate.getFormat() != null) {
                            dateRangeBuilder.format(dateRangeAggregate.getFormat());
                        }
                        bucketsAggregation = new Aggregation.Builder().dateRange(dateRangeBuilder.build()).build();
                    } else if (aggregate instanceof IpRangeAggregate) {
                        IpRangeAggregate ipRangeAggregate = (IpRangeAggregate)aggregate;
                        IpRangeAggregation.Builder ipRangeBuilder = new IpRangeAggregation.Builder().field(fieldName);
                        ArrayList<IpRangeAggregationRange> ranges = new ArrayList<IpRangeAggregationRange>();
                        for (IpRange range : ipRangeAggregate.getRanges()) {
                            if (range == null) continue;
                            IpRangeAggregationRange.of(builder -> builder.from(range.getFrom()).to(range.getTo()));
                            ranges.add(IpRangeAggregationRange.of(builder -> builder.from(range.getFrom()).to(range.getTo())));
                        }
                        ipRangeBuilder.ranges(ranges);
                        bucketsAggregation = ipRangeBuilder.build()._toAggregation();
                    } else if ((fieldName = ElasticSearchPersistenceServiceImpl.this.getPropertyNameWithData(fieldName, itemType)) != null) {
                        TermsAggregate termsAggregate;
                        TermsAggregation.Builder termsAggBuilder = new TermsAggregation.Builder().field(fieldName).size(Integer.valueOf(queryBucketSize));
                        if (aggregate instanceof TermsAggregate && (termsAggregate = (TermsAggregate)aggregate).getPartition() > -1 && termsAggregate.getNumPartitions() > -1) {
                            termsAggBuilder.include(TermsInclude.of(ti -> ti.partition(pi -> pi.partition((long)termsAggregate.getPartition()).numPartitions((long)termsAggregate.getNumPartitions()))));
                        }
                        bucketsAggregation = termsAggBuilder.build()._toAggregation();
                    }
                    if (bucketsAggregation != null) {
                        MissingAggregation missingAggregation = new MissingAggregation.Builder().field(fieldName).build();
                        aggregationsByType.put("buckets", bucketsAggregation);
                        aggregationsByType.put("missing", missingAggregation._toAggregation());
                    }
                }
                SearchRequest.Builder searchSourceBuilder = new SearchRequest.Builder();
                searchSourceBuilder.index(ElasticSearchPersistenceServiceImpl.this.getIndexNameForQuery(itemType), new String[0]);
                searchSourceBuilder.size(Integer.valueOf(0));
                searchSourceBuilder.query(ElasticSearchPersistenceServiceImpl.this.isItemTypeSharingIndex(itemType) ? ElasticSearchPersistenceServiceImpl.this.getItemTypeQuery(itemType) : Query.of(q -> q.matchAll(m -> m)));
                if (optimizedQuery) {
                    searchSourceBuilder.aggregations(aggregationsByType);
                    if (filter != null) {
                        searchSourceBuilder.query(ElasticSearchPersistenceServiceImpl.this.wrapWithItemTypeQuery(itemType, ElasticSearchPersistenceServiceImpl.this.conditionESQueryBuilderDispatcher.buildFilter(filter)));
                    }
                } else {
                    if (filter != null) {
                        Aggregation.Builder aggBuilder = new Aggregation.Builder();
                        aggBuilder.filter(ElasticSearchPersistenceServiceImpl.this.wrapWithItemTypeQuery(itemType, ElasticSearchPersistenceServiceImpl.this.conditionESQueryBuilderDispatcher.buildFilter(filter))).aggregations(aggregationsByType);
                        aggregationsByType = Map.of("filter", aggBuilder.build());
                    }
                    Aggregation globalAgg = new Aggregation.Builder().global(new GlobalAggregation.Builder().build()).aggregations(aggregationsByType).build();
                    searchSourceBuilder.aggregations(String.valueOf(globalAgg._kind()), globalAgg);
                }
                RequestOptions.Builder builder2 = RequestOptions.DEFAULT.toBuilder();
                RestClientOptions additionalOptions = null;
                if (ElasticSearchPersistenceServiceImpl.this.aggQueryMaxResponseSizeHttp != null) {
                    HttpAsyncResponseConsumerFactory.HeapBufferedResponseConsumerFactory httpAsyncResponseConsumerFactory = new HttpAsyncResponseConsumerFactory.HeapBufferedResponseConsumerFactory(ElasticSearchPersistenceServiceImpl.this.aggQueryMaxResponseSizeHttp.intValue());
                    RequestOptions requestOptions = RequestOptions.DEFAULT.toBuilder().setHttpAsyncResponseConsumerFactory((HttpAsyncResponseConsumerFactory)httpAsyncResponseConsumerFactory).build();
                    additionalOptions = new RestClientOptions(requestOptions, true);
                }
                if (additionalOptions != null) {
                    ElasticsearchClient clientWithOptions = ElasticSearchPersistenceServiceImpl.this.esClient.withTransportOptions((TransportOptions)additionalOptions);
                    response = clientWithOptions.search(searchSourceBuilder.build());
                    clientWithOptions.close();
                } else {
                    response = ElasticSearchPersistenceServiceImpl.this.esClient.search(searchSourceBuilder.build());
                }
                Map aggregations = response.aggregations();
                if (aggregations != null) {
                    if (optimizedQuery) {
                        if (response.hits() != null) {
                            results.put("_filtered", response.hits().total().value());
                        }
                    } else {
                        GlobalAggregate globalAggregate = ((Aggregate)aggregations.get(Aggregation.Kind.Global.jsonValue())).global();
                        results.put("_all", globalAggregate.docCount());
                        aggregations = globalAggregate.aggregations();
                        if (aggregations.get(Aggregate.Kind.Filter.jsonValue()) != null) {
                            FilterAggregate filterAggregate = ((Aggregate)aggregations.get(Aggregation.Kind.Filter.jsonValue())).filter();
                            results.put("_filtered", filterAggregate.docCount());
                            aggregations = filterAggregate.aggregations();
                        }
                    }
                    if (aggregations.get("buckets") != null) {
                        MissingAggregate missing;
                        StringTermsAggregate terms;
                        Aggregate agg;
                        if (ElasticSearchPersistenceServiceImpl.this.aggQueryThrowOnMissingDocs && (agg = (Aggregate)aggregations.get("buckets")).isSterms() && ((terms = ((Aggregate)aggregations.get("buckets")).sterms()).docCountErrorUpperBound() > 0L || terms.sumOtherDocCount() > 0L)) {
                            throw new UnsupportedOperationException("Some docs are missing in aggregation query. docCountError is:" + terms.docCountErrorUpperBound() + " sumOfOtherDocCounts:" + terms.sumOtherDocCount());
                        }
                        long totalDocCount = 0L;
                        Aggregate bucketsAggregate = (Aggregate)aggregations.get("buckets");
                        if (bucketsAggregate.isMultiTerms()) {
                            terms = ((Aggregate)aggregations.get("buckets")).multiTerms();
                            for (MultiTermsBucket bucket : terms.buckets().array()) {
                                results.put(bucket.keyAsString(), bucket.docCount());
                                totalDocCount += bucket.docCount();
                            }
                        } else if (bucketsAggregate.isSterms()) {
                            terms = bucketsAggregate.sterms();
                            for (StringTermsBucket bucket : terms.buckets().array()) {
                                results.put(bucket.key().stringValue(), bucket.docCount());
                                totalDocCount += bucket.docCount();
                            }
                        } else if (bucketsAggregate.isLterms()) {
                            terms = bucketsAggregate.lterms();
                            for (LongTermsBucket bucket : terms.buckets().array()) {
                                results.put(bucket.keyAsString(), bucket.docCount());
                                totalDocCount += bucket.docCount();
                            }
                        } else if (bucketsAggregate.isDateHistogram()) {
                            DateHistogramAggregate histogramAggregate = bucketsAggregate.dateHistogram();
                            for (DateHistogramBucket bucket : histogramAggregate.buckets().array()) {
                                results.put(bucket.keyAsString(), bucket.docCount());
                                totalDocCount += bucket.docCount();
                            }
                        }
                        if ((missing = ((Aggregate)aggregations.get("missing")).missing()).docCount() > 0L) {
                            results.put("_missing", missing.docCount());
                            totalDocCount += missing.docCount();
                        }
                        if (response.hits() != null && TotalHitsRelation.Gte.equals((Object)response.hits().total().relation())) {
                            results.put("_filtered", totalDocCount);
                        }
                    }
                }
                return results;
            }

            private static /* synthetic */ ObjectBuilder lambda$execute$2(DateRange range, FieldDateMath.Builder f) {
                return f.expr(range.getTo().toString());
            }

            private static /* synthetic */ ObjectBuilder lambda$execute$1(DateRange range, FieldDateMath.Builder f) {
                return f.expr(range.getFrom().toString());
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
    }

    private <T extends Item> String[] getRouting(String fieldName, String[] fieldValues, Class<T> clazz) {
        String itemType = Item.getItemType(clazz);
        String[] routing = null;
        if (this.routingByType.containsKey(itemType) && this.routingByType.get(itemType).equals(fieldName)) {
            routing = fieldValues;
        }
        return routing;
    }

    public void refresh() {
        new InClassLoaderExecute<Boolean>(this.metricsService, this.getClass().getName() + ".refresh", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Boolean execute(Object ... args) {
                try {
                    ElasticSearchPersistenceServiceImpl.this.esClient.indices().refresh(new RefreshRequest.Builder().build());
                }
                catch (IOException e) {
                    LOGGER.error("Failed to refresh persistence for reason: {}. Set the log in DEBUG level for details", (Object)e.getMessage());
                    LOGGER.debug("Error on refresh: ", (Throwable)e);
                }
                return true;
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
    }

    public <T extends Item> void refreshIndex(final Class<T> clazz, Date dateHint) {
        new InClassLoaderExecute<Boolean>(this.metricsService, this.getClass().getName() + ".refreshIndex", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Boolean execute(Object ... args) {
                try {
                    ElasticSearchPersistenceServiceImpl.this.esClient.indices().refresh(RefreshRequest.of(builder -> builder.index(ElasticSearchPersistenceServiceImpl.this.getIndex(Item.getItemType((Class)clazz)), new String[0])));
                }
                catch (IOException e) {
                    LOGGER.error("Failed to refresh index for reason: {}. Set the log in DEBUG level for details", (Object)e.getMessage());
                    LOGGER.debug("Error on refresh: ", (Throwable)e);
                }
                return true;
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
    }

    public void purge(Date date) {
    }

    public <T extends Item> void purgeTimeBasedItems(final int existsNumberOfDays, final Class<T> clazz) {
        new InClassLoaderExecute<Boolean>(this.metricsService, this.getClass().getName() + ".purgeTimeBasedItems", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Boolean execute(Object ... args) throws Exception {
                String itemType = Item.getItemType((Class)clazz);
                if (existsNumberOfDays > 0 && ElasticSearchPersistenceServiceImpl.this.isItemTypeRollingOver(itemType)) {
                    Query query = Query.of(builder -> builder.range(RangeQuery.of(r -> r.term(term -> (ObjectBuilder)term.field("timeStamp").lte("now-" + existsNumberOfDays + "d")))));
                    ElasticSearchPersistenceServiceImpl.this.removeByQuery(query, clazz);
                    TreeMap<String, Long> countsPerIndex = new TreeMap<String, Long>();
                    GetIndexResponse getIndexResponse = ElasticSearchPersistenceServiceImpl.this.esClient.indices().get(new GetIndexRequest.Builder().index(ElasticSearchPersistenceServiceImpl.this.getIndexNameForQuery(itemType), new String[0]).build());
                    Map indices = getIndexResponse.indices();
                    for (Map.Entry entry : indices.entrySet()) {
                        String indexName = (String)entry.getKey();
                        CountRequest countRequest = new CountRequest.Builder().index(indexName, new String[0]).build();
                        countsPerIndex.put(indexName, ElasticSearchPersistenceServiceImpl.this.esClient.count(countRequest).count());
                    }
                    if (!countsPerIndex.isEmpty()) {
                        countsPerIndex.pollLastEntry();
                        for (Map.Entry indexCount : countsPerIndex.entrySet()) {
                            if ((Long)indexCount.getValue() != 0L) continue;
                            ElasticSearchPersistenceServiceImpl.this.esClient.indices().delete(new DeleteIndexRequest.Builder().index((String)indexCount.getKey(), new String[0]).build());
                        }
                    }
                }
                return true;
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
    }

    public void purge(final String scope) {
        LOGGER.debug("Purge scope {}", (Object)scope);
        new InClassLoaderExecute<Void>(this.metricsService, this.getClass().getName() + ".purgeWithScope", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Void execute(Object ... args) throws IOException {
                BulkResponse bulkResponse;
                Query query = TermQuery.of(builder -> builder.field("scope").value(scope))._toQuery();
                ArrayList<BulkOperation> operations = new ArrayList<BulkOperation>();
                Time keepAlive = Time.of(t -> t.time("1h"));
                SearchRequest searchRequest = SearchRequest.of(s -> s.index(ElasticSearchPersistenceServiceImpl.this.getAllIndexForQuery(), new String[0]).scroll(keepAlive).size(Integer.valueOf(100)).query(query).source(src -> src.fetch(Boolean.valueOf(true))));
                SearchResponse<JsonData> searchResponse = ElasticSearchPersistenceServiceImpl.this.esClient.search(searchRequest, JsonData.class);
                List hits = searchResponse.hits().hits();
                String scrollId = searchResponse.scrollId();
                while (!hits.isEmpty()) {
                    for (Hit hit : searchResponse.hits().hits()) {
                        operations.add(BulkOperation.of(builder -> builder.delete(d -> (ObjectBuilder)((DeleteOperation.Builder)d.index(hit.index())).id(hit.id()))));
                    }
                    ScrollRequest scrollRequest = new ScrollRequest.Builder().scrollId(scrollId).scroll(keepAlive).build();
                    ScrollResponse<JsonData> scrollResponse = ElasticSearchPersistenceServiceImpl.this.esClient.scroll(scrollRequest, JsonData.class);
                    hits = scrollResponse.hits().hits();
                    scrollId = scrollResponse.scrollId();
                    if (!hits.isEmpty()) continue;
                    ClearScrollRequest clearScrollRequest = new ClearScrollRequest.Builder().scrollId(scrollId, new String[0]).build();
                    ElasticSearchPersistenceServiceImpl.this.esClient.clearScroll(clearScrollRequest);
                }
                if (!operations.isEmpty() && (bulkResponse = ElasticSearchPersistenceServiceImpl.this.esClient.bulk(b -> b.operations(operations))).errors()) {
                    bulkResponse.items().forEach(item -> {
                        if (item.error() != null) {
                            LOGGER.warn("Couldn't delete item {} from scope {}: {}", new Object[]{item.id(), scope, item.error().reason()});
                        }
                    });
                }
                return null;
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
    }

    public Map<String, Double> getSingleValuesMetrics(final Condition condition, final String[] metrics, final String field, final String itemType) {
        return (Map)new InClassLoaderExecute<Map<String, Double>>(this.metricsService, this.getClass().getName() + ".getSingleValuesMetrics", this.bundleContext, this.fatalIllegalStateErrors, this.throwExceptions){

            @Override
            protected Map<String, Double> execute(Object ... args) throws IOException {
                Aggregate metricsAgg;
                Aggregation filterAggregation;
                SearchRequest searchRequest;
                SearchResponse<Void> searchResponse;
                Map aggregationResult;
                LinkedHashMap<String, Double> results = new LinkedHashMap<String, Double>();
                HashMap<String, Aggregation> subAggs = new HashMap<String, Aggregation>();
                if (metrics != null) {
                    String[] stringArray = metrics;
                    int n = stringArray.length;
                    block16: for (int i = 0; i < n; ++i) {
                        String metric;
                        switch (metric = stringArray[i]) {
                            case "sum": {
                                subAggs.put("sum", ((SumAggregation.Builder)AggregationBuilders.sum().field(field)).build()._toAggregation());
                                continue block16;
                            }
                            case "avg": {
                                subAggs.put("avg", ((AverageAggregation.Builder)AggregationBuilders.avg().field(field)).build()._toAggregation());
                                continue block16;
                            }
                            case "min": {
                                subAggs.put("min", ((MinAggregation.Builder)AggregationBuilders.min().field(field)).build()._toAggregation());
                                continue block16;
                            }
                            case "max": {
                                subAggs.put("max", ((MaxAggregation.Builder)AggregationBuilders.max().field(field)).build()._toAggregation());
                                continue block16;
                            }
                            case "card": {
                                subAggs.put("card", ((CardinalityAggregation.Builder)AggregationBuilders.cardinality().field(field)).build()._toAggregation());
                                continue block16;
                            }
                            case "count": {
                                subAggs.put("count", Aggregation.of(a -> a.valueCount(vc -> (ObjectBuilder)vc.field(field))));
                            }
                        }
                    }
                }
                if ((aggregationResult = (searchResponse = ElasticSearchPersistenceServiceImpl.this.esClient.search(searchRequest = SearchRequest.of(arg_0 -> this.lambda$execute$6(itemType, filterAggregation = Aggregation.of(a -> a.filter(ElasticSearchPersistenceServiceImpl.this.conditionESQueryBuilderDispatcher.buildFilter(condition)).aggregations(subAggs)), arg_0)))).aggregations()) != null && (metricsAgg = (Aggregate)aggregationResult.get("metrics")) != null && metricsAgg.isFilter()) {
                    Map subAggsResult = metricsAgg.filter().aggregations();
                    for (Map.Entry<String, Aggregate> entry : subAggsResult.entrySet()) {
                        String name = (String)entry.getKey();
                        Double value = ElasticSearchPersistenceServiceImpl.getAggregeValue(entry);
                        if (value == null) continue;
                        results.put("_" + name, value);
                    }
                }
                return results;
            }

            private /* synthetic */ ObjectBuilder lambda$execute$6(String itemType2, Aggregation filterAggregation, SearchRequest.Builder s) {
                return s.index(ElasticSearchPersistenceServiceImpl.this.getIndexNameForQuery(itemType2), new String[0]).size(Integer.valueOf(0)).source(builder -> builder.fetch(Boolean.valueOf(true))).query(ElasticSearchPersistenceServiceImpl.this.isItemTypeSharingIndex(itemType2) ? ElasticSearchPersistenceServiceImpl.this.getItemTypeQuery(itemType2) : Query.of(q -> q.matchAll(m -> m))).aggregations("metrics", filterAggregation);
            }
        }.catchingExecuteInClassLoader(true, new Object[0]);
    }

    private static Double getAggregeValue(Map.Entry<String, Aggregate> entry) {
        Aggregate agg = entry.getValue();
        Double value = null;
        if (agg.isSum()) {
            value = agg.sum().value();
        } else if (agg.isAvg()) {
            value = agg.avg().value();
        } else if (agg.isMin()) {
            value = agg.min().value();
        } else if (agg.isMax()) {
            value = agg.max().value();
        } else if (agg.isCardinality()) {
            value = agg.cardinality().value();
        } else if (agg.isValueCount()) {
            value = agg.valueCount().value();
        }
        return value;
    }

    private String getConfig(Map<String, String> settings, String key, String defaultValue) {
        if (settings != null && settings.get(key) != null) {
            return settings.get(key);
        }
        return defaultValue;
    }

    private String getAllIndexForQuery() {
        return this.indexPrefix + "*";
    }

    private String getIndexNameForQuery(String itemType) {
        return this.isItemTypeRollingOver(itemType) ? this.getRolloverIndexForQuery(itemType) : this.getIndex(itemType);
    }

    private String getRolloverIndexForQuery(String itemType) {
        return this.indexPrefix + "-" + itemType.toLowerCase() + "-*";
    }

    private String getIndex(String itemType) {
        return (this.indexPrefix + "-" + this.getIndexNameForItemType(itemType)).toLowerCase();
    }

    private String getIndexNameForItemType(String itemType) {
        return itemTypeIndexNameMap.getOrDefault(itemType, itemType);
    }

    private String getDocumentIDForItemType(String itemId, String itemType) {
        return systemItems.contains(itemType) ? itemId + "_" + itemType.toLowerCase() : itemId;
    }

    private Query wrapWithItemTypeQuery(String itemType, Query originalQuery) {
        if (this.isItemTypeSharingIndex(itemType)) {
            return Query.of(q -> q.bool(b -> b.must(this.getItemTypeQuery(itemType), new Query[0]).must(originalQuery, new Query[0])));
        }
        return originalQuery;
    }

    private Query wrapWithItemsTypeQuery(String[] itemTypes, Query originalQuery) {
        if (itemTypes.length == 1) {
            return this.wrapWithItemTypeQuery(itemTypes[0], originalQuery);
        }
        if (Arrays.stream(itemTypes).anyMatch(this::isItemTypeSharingIndex)) {
            BoolQuery.Builder itemTypeQuery = new BoolQuery.Builder();
            itemTypeQuery.minimumShouldMatch("1");
            for (String itemType : itemTypes) {
                itemTypeQuery.should(this.getItemTypeQuery(itemType), new Query[0]);
            }
            BoolQuery.Builder wrappedQuery = new BoolQuery.Builder();
            wrappedQuery.filter(itemTypeQuery.build(), new QueryVariant[0]);
            wrappedQuery.must(originalQuery, new Query[0]);
            return Query.of(builder -> builder.bool(wrappedQuery.build()));
        }
        return originalQuery;
    }

    private Query getItemTypeQuery(String itemType) {
        return Query.of(q -> q.term(t -> t.field("itemType").value(ConditionContextHelper.foldToASCII((String)itemType))));
    }

    private boolean isItemTypeSharingIndex(String itemType) {
        return itemTypeIndexNameMap.containsKey(itemType);
    }

    private boolean isItemTypeRollingOver(String itemType) {
        return this.rolloverIndices.contains(itemType);
    }

    private Refresh getRefreshPolicy(String itemType) {
        if (this.itemTypeToRefreshPolicy.containsKey(itemType)) {
            return this.itemTypeToRefreshPolicy.get(itemType);
        }
        return Refresh.False;
    }

    private void logMetadataItemOperation(String operation, Item item) {
        if (item instanceof MetadataItem) {
            LOGGER.info("Item of type {} with ID {} has been {}", new Object[]{item.getItemType(), item.getItemId(), operation});
        }
    }

    static {
        for (String systemItem : systemItems) {
            itemTypeIndexNameMap.put(systemItem, "systemItems");
        }
        itemTypeIndexNameMap.put("profile", "profile");
        itemTypeIndexNameMap.put("persona", "profile");
    }

    public static abstract class InClassLoaderExecute<T> {
        private final String timerName;
        private final MetricsService metricsService;
        private final BundleContext bundleContext;
        private final String[] fatalIllegalStateErrors;
        private final boolean throwExceptions;

        public InClassLoaderExecute(MetricsService metricsService, String timerName, BundleContext bundleContext, String[] fatalIllegalStateErrors, boolean throwExceptions) {
            this.timerName = timerName;
            this.metricsService = metricsService;
            this.bundleContext = bundleContext;
            this.fatalIllegalStateErrors = fatalIllegalStateErrors;
            this.throwExceptions = throwExceptions;
        }

        protected abstract T execute(Object ... var1) throws Exception;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T executeInClassLoader(Object ... args) throws Exception {
            long startTime = System.currentTimeMillis();
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                T t = this.execute(args);
                return t;
            }
            finally {
                if (this.metricsService != null && this.metricsService.isActivated()) {
                    this.metricsService.updateTimer(this.timerName, startTime);
                }
                Thread.currentThread().setContextClassLoader(tccl);
            }
        }

        public T catchingExecuteInClassLoader(boolean logError, Object ... args) {
            try {
                return this.executeInClassLoader(this.timerName, args);
            }
            catch (Throwable t) {
                for (Throwable tTemp = t; tTemp != null; tTemp = tTemp.getCause()) {
                    if (!(tTemp instanceof IllegalStateException)) continue;
                    if (!Arrays.stream(this.fatalIllegalStateErrors).anyMatch(tTemp.getMessage()::contains)) continue;
                    this.handleFatalStateError();
                    return null;
                }
                this.handleError(t, logError);
                return null;
            }
        }

        private void handleError(Throwable t, boolean logError) {
            if (logError) {
                LOGGER.error("Error while executing in class loader", t);
            }
            if (this.throwExceptions) {
                throw new RuntimeException(t);
            }
        }

        private void handleFatalStateError() {
            LOGGER.error("Fatal state error occurred - stopping application");
            try {
                this.bundleContext.getBundle(0L).stop();
            }
            catch (Throwable tInner) {
                System.exit(-1);
            }
        }
    }
}

