/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.router.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.unomi.api.PropertyType;
import org.apache.unomi.router.api.ImportExportConfiguration;
import org.apache.unomi.router.api.RouterConstants;

public class RouterUtils {
    public static ImportExportConfiguration addExecutionEntry(ImportExportConfiguration configuration, Map execution, int executionsHistorySize) {
        if (configuration.getExecutions() == null) {
            configuration.setExecutions(new ArrayList<Map<String, Object>>());
        }
        if (configuration.getExecutions().size() >= executionsHistorySize) {
            int oldestExecIndex = 0;
            long oldestExecDate = (Long)configuration.getExecutions().get(0).get(RouterConstants.KEY_EXECS_DATE);
            for (int i = 1; i < configuration.getExecutions().size(); ++i) {
                if ((Long)configuration.getExecutions().get(i).get(RouterConstants.KEY_EXECS_DATE) >= oldestExecDate) continue;
                oldestExecDate = (Long)configuration.getExecutions().get(i).get(RouterConstants.KEY_EXECS_DATE);
                oldestExecIndex = i;
            }
            configuration.getExecutions().remove(oldestExecIndex);
        }
        configuration.getExecutions().add(execution);
        return configuration;
    }

    public static char getCharFromLineSeparator(String lineSeparator) {
        char charLineSep = '\n';
        if ("\r".equals(lineSeparator)) {
            charLineSep = '\r';
        }
        return charLineSep;
    }

    public static PropertyType getPropertyTypeById(Collection<PropertyType> propertyTypes, String propertyTypeId) {
        for (PropertyType propertyType : propertyTypes) {
            if (!propertyType.getMetadata().getId().equals(propertyTypeId)) continue;
            return propertyType;
        }
        return null;
    }
}

