/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.jetty;

import java.io.IOException;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.wicket.protocol.ws.AbstractUpgradeFilter;
import org.apache.wicket.protocol.ws.jetty.JettyWebSocketProcessor;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketFactory;

public class Jetty7WebSocketFilter
extends AbstractUpgradeFilter
implements WebSocketFactory.Acceptor {
    private WebSocketFactory _webSocketFactory;

    public void init(boolean isServlet, FilterConfig filterConfig) throws ServletException {
        super.init(isServlet, filterConfig);
        try {
            String bs = filterConfig.getInitParameter("bufferSize");
            this._webSocketFactory = new WebSocketFactory((WebSocketFactory.Acceptor)this, bs == null ? 8192 : Integer.parseInt(bs));
            this._webSocketFactory.start();
            String max = filterConfig.getInitParameter("maxIdleTime");
            if (max != null) {
                this._webSocketFactory.setMaxIdleTime(Integer.parseInt(max));
            }
            if ((max = filterConfig.getInitParameter("maxTextMessageSize")) != null) {
                this._webSocketFactory.setMaxTextMessageSize(Integer.parseInt(max));
            }
            if ((max = filterConfig.getInitParameter("maxBinaryMessageSize")) != null) {
                this._webSocketFactory.setMaxBinaryMessageSize(Integer.parseInt(max));
            }
        }
        catch (ServletException x) {
            throw x;
        }
        catch (Exception x) {
            throw new ServletException((Throwable)x);
        }
    }

    protected boolean acceptWebSocket(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        return super.acceptWebSocket(req, resp) && this._webSocketFactory.acceptWebSocket(req, resp);
    }

    public WebSocket doWebSocketConnect(HttpServletRequest request, String protocol) {
        JettyWebSocketProcessor webSocketHandler = new JettyWebSocketProcessor(request, this.getApplication());
        return new JettyWebSocketProcessor.JettyWebSocket(webSocketHandler);
    }

    public boolean checkOrigin(HttpServletRequest request, String origin) {
        return true;
    }

    public void destroy() {
        try {
            this._webSocketFactory.stop();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        super.destroy();
    }
}

