/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.jetty9;

import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.ws.api.AbstractWebSocketProcessor;
import org.apache.wicket.protocol.ws.api.IWebSocketConnection;
import org.apache.wicket.protocol.ws.jetty9.Jetty9UpgradeHttpRequest;
import org.apache.wicket.protocol.ws.jetty9.Jetty9WebSocketConnection;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jetty9WebSocketProcessor
extends AbstractWebSocketProcessor
implements WebSocketListener {
    private static final Logger LOG = LoggerFactory.getLogger(Jetty9WebSocketProcessor.class);

    public Jetty9WebSocketProcessor(UpgradeRequest upgradeRequest, UpgradeResponse upgradeResponse, WebApplication application) {
        super((HttpServletRequest)new Jetty9UpgradeHttpRequest(upgradeRequest), application);
    }

    public void onWebSocketConnect(Session session) {
        this.onConnect((IWebSocketConnection)new Jetty9WebSocketConnection(session, this));
    }

    public void onWebSocketText(String message) {
        this.onMessage(message);
    }

    public void onWebSocketBinary(byte[] payload, int offset, int len) {
        this.onMessage(payload, offset, len);
    }

    public void onWebSocketClose(int statusCode, String reason) {
        this.onClose(statusCode, reason);
    }

    public void onWebSocketError(Throwable throwable) {
        LOG.error("An error occurred when using WebSocket.", throwable);
        this.onError(throwable);
    }

    public void onOpen(Object connection) {
        if (!(connection instanceof Session)) {
            throw new IllegalArgumentException(Jetty9WebSocketProcessor.class.getName() + " can work only with " + Session.class.getName());
        }
        this.onWebSocketConnect((Session)connection);
    }
}

