﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/customer-profiles/CustomerProfilesRequest.h>
#include <aws/customer-profiles/CustomerProfiles_EXPORTS.h>

#include <utility>

namespace Aws {
namespace CustomerProfiles {
namespace Model {

/**
 */
class BatchGetProfileRequest : public CustomerProfilesRequest {
 public:
  AWS_CUSTOMERPROFILES_API BatchGetProfileRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "BatchGetProfile"; }

  AWS_CUSTOMERPROFILES_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The unique name of the domain.</p>
   */
  inline const Aws::String& GetDomainName() const { return m_domainName; }
  inline bool DomainNameHasBeenSet() const { return m_domainNameHasBeenSet; }
  template <typename DomainNameT = Aws::String>
  void SetDomainName(DomainNameT&& value) {
    m_domainNameHasBeenSet = true;
    m_domainName = std::forward<DomainNameT>(value);
  }
  template <typename DomainNameT = Aws::String>
  BatchGetProfileRequest& WithDomainName(DomainNameT&& value) {
    SetDomainName(std::forward<DomainNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>List of unique identifiers for customer profiles to retrieve.</p>
   */
  inline const Aws::Vector<Aws::String>& GetProfileIds() const { return m_profileIds; }
  inline bool ProfileIdsHasBeenSet() const { return m_profileIdsHasBeenSet; }
  template <typename ProfileIdsT = Aws::Vector<Aws::String>>
  void SetProfileIds(ProfileIdsT&& value) {
    m_profileIdsHasBeenSet = true;
    m_profileIds = std::forward<ProfileIdsT>(value);
  }
  template <typename ProfileIdsT = Aws::Vector<Aws::String>>
  BatchGetProfileRequest& WithProfileIds(ProfileIdsT&& value) {
    SetProfileIds(std::forward<ProfileIdsT>(value));
    return *this;
  }
  template <typename ProfileIdsT = Aws::String>
  BatchGetProfileRequest& AddProfileIds(ProfileIdsT&& value) {
    m_profileIdsHasBeenSet = true;
    m_profileIds.emplace_back(std::forward<ProfileIdsT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_domainName;

  Aws::Vector<Aws::String> m_profileIds;
  bool m_domainNameHasBeenSet = false;
  bool m_profileIdsHasBeenSet = false;
};

}  // namespace Model
}  // namespace CustomerProfiles
}  // namespace Aws
