/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.catalog;

import org.gradle.api.internal.artifacts.ImmutableVersionConstraint;
import org.gradle.api.internal.catalog.AbstractContextAwareModel;
import org.jspecify.annotations.Nullable;

public class PluginModel
extends AbstractContextAwareModel {
    private final String id;
    private final ImmutableVersionConstraint version;
    private final String versionRef;
    private final int hashCode;

    public PluginModel(String id, @Nullable String versionRef, ImmutableVersionConstraint version, @Nullable String context) {
        super(context);
        this.id = id;
        this.version = version;
        this.versionRef = versionRef;
        this.hashCode = this.doComputeHashCode();
    }

    public String getId() {
        return this.id;
    }

    public ImmutableVersionConstraint getVersion() {
        return this.version;
    }

    public @Nullable String getVersionRef() {
        return this.versionRef;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginModel that = (PluginModel)o;
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
            return false;
        }
        return this.versionRef != null ? this.versionRef.equals(that.versionRef) : that.versionRef == null;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int doComputeHashCode() {
        int result = this.id.hashCode();
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.versionRef != null ? this.versionRef.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "plugin {id='" + this.id + '\'' + ", version='" + this.version + '\'' + '}';
    }
}

