/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiClassPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiModifierListOwnerPattern;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import groovy.lang.Closure;
import groovy.lang.Script;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.plugins.groovy.dsl.DslPointcut;
import org.jetbrains.plugins.groovy.dsl.GdslMethod;
import org.jetbrains.plugins.groovy.dsl.GdslType;
import org.jetbrains.plugins.groovy.dsl.GroovyClassDescriptor;
import org.jetbrains.plugins.groovy.dsl.PointcutContextFilter;
import org.jetbrains.plugins.groovy.dsl.toplevel.CompositeContextFilter;
import org.jetbrains.plugins.groovy.dsl.toplevel.Context;
import org.jetbrains.plugins.groovy.dsl.toplevel.ContextFilter;
import org.jetbrains.plugins.groovy.dsl.toplevel.scopes.AnnotatedScope;
import org.jetbrains.plugins.groovy.dsl.toplevel.scopes.ClassScope;
import org.jetbrains.plugins.groovy.dsl.toplevel.scopes.ClosureScope;
import org.jetbrains.plugins.groovy.dsl.toplevel.scopes.Scope;
import org.jetbrains.plugins.groovy.dsl.toplevel.scopes.ScriptScope;

public abstract class GdslScriptBase
extends Script {
    private static final String ideaVersion;
    private final List<Pair<ContextFilter, Closure>> enhancers = new ArrayList<Pair<ContextFilter, Closure>>();
    private final MultiMap staticInfo = new MultiMap();
    private boolean locked = false;

    public static String getIdeaVersion() {
        return ideaVersion;
    }

    public final List<Pair<ContextFilter, Closure>> getEnhancers() {
        return this.enhancers;
    }

    public final MultiMap getStaticInfo() {
        return this.staticInfo;
    }

    public abstract void scriptBody();

    public Boolean run() {
        try {
            this.scriptBody();
        }
        catch (InvalidVersionException ignore) {
            this.enhancers.clear();
        }
        this.locked = true;
        return true;
    }

    public DslPointcut methodMissing(String name, Object args) {
        return DslPointcut.UNKNOWN;
    }

    public void contribute(Object cts, Closure toDo) {
        List contexts;
        if ((cts = this.handleImplicitBind(cts)) instanceof DslPointcut) {
            if (((DslPointcut)((Object)cts)).operatesOn(GroovyClassDescriptor.class)) {
                PointcutContextFilter filter = new PointcutContextFilter((DslPointcut)((Object)cts));
                this.addClassEnhancer(List.of(filter), toDo);
            } else {
                Logger.getInstance(((Object)((Object)this)).getClass()).error("A non top-level pointcut passed to contributor");
            }
            return;
        }
        if (cts instanceof Map) {
            cts = new Context((Map)((Object)cts));
        }
        if (!(cts instanceof List)) {
            assert (cts instanceof Context) : "The contributor() argument must be a context";
            cts = List.of(cts);
        }
        if (!(contexts = ContainerUtil.filter((Collection)cts, x -> x != null)).isEmpty()) {
            List filters = ContainerUtil.map((Collection)contexts, x -> x.getFilter());
            this.addClassEnhancer(filters, toDo);
        }
    }

    public void contributor(Object cts, Closure toDo) {
        this.contribute(cts, toDo);
    }

    public void assertVersion(Object ver) {
        if (!this.supportsVersion(ver)) {
            throw new InvalidVersionException();
        }
    }

    public void scriptSuperClass(Map args) {
        this.staticInfo.putValue((Object)"scriptSuperClass", (Object)args);
    }

    public boolean supportsVersion(Object ver) {
        if (ver instanceof String) {
            return StringUtil.compareVersionNumbers((String)ideaVersion, (String)((String)ver)) >= 0;
        }
        if (ver instanceof Map) {
            String dsl = (String)((Map)ver).get("dsl");
            if (dsl != null && !dsl.isEmpty()) {
                return StringUtil.compareVersionNumbers((String)"1.0", (String)dsl) >= 0;
            }
            String intellij = (String)((Map)ver).get("intellij");
            if (intellij != null && !intellij.isEmpty()) {
                return StringUtil.compareVersionNumbers((String)ideaVersion, (String)intellij) >= 0;
            }
        }
        return false;
    }

    public void addClassEnhancer(List<? extends ContextFilter> cts, Closure toDo) {
        assert (!this.locked) : "Contributing to GDSL is only allowed at the top-level of the *.gdsl script";
        this.enhancers.add((Pair<ContextFilter, Closure>)Pair.create((Object)CompositeContextFilter.compose(cts, false), (Object)toDo));
    }

    public Scope closureScope(Map args) {
        return new ClosureScope(args);
    }

    public Scope scriptScope(Map args) {
        return new ScriptScope(args);
    }

    public Scope classScope(Map args) {
        return new ClassScope(args);
    }

    public Scope annotatedScope(Map args) {
        return new AnnotatedScope(args);
    }

    public Context context(Map args) {
        return new Context(args);
    }

    public PsiModifierListOwnerPattern.Capture<PsiModifierListOwner> hasAnnotation(String annoQName) {
        return (PsiModifierListOwnerPattern.Capture)PsiJavaPatterns.psiModifierListOwner().withAnnotation(annoQName);
    }

    public PsiClassPattern hasField(ElementPattern fieldCondition) {
        return PsiJavaPatterns.psiClass().withField(true, (ElementPattern)PsiJavaPatterns.psiField().and(fieldCondition));
    }

    public PsiClassPattern hasMethod(ElementPattern methodCondition) {
        return PsiJavaPatterns.psiClass().withMethod(true, (ElementPattern)PsiJavaPatterns.psiMethod().and(methodCondition));
    }

    public DslPointcut bind(Object arg) {
        return DslPointcut.bind(arg);
    }

    public Object handleImplicitBind(Object arg) {
        if (arg instanceof Map && ((Map)arg).size() == 1 && ((Map)arg).keySet().iterator().next() instanceof String && ((Map)arg).values().iterator().next() instanceof DslPointcut) {
            return DslPointcut.bind(arg);
        }
        return arg;
    }

    public DslPointcut<GdslType, GdslType> subType(Object arg) {
        return DslPointcut.subType(this.handleImplicitBind(arg));
    }

    public DslPointcut<GroovyClassDescriptor, GdslType> currentType(Object arg) {
        return DslPointcut.currentType(this.handleImplicitBind(arg));
    }

    public DslPointcut<GroovyClassDescriptor, GdslType> enclosingType(Object arg) {
        return DslPointcut.enclosingType(this.handleImplicitBind(arg));
    }

    public DslPointcut<Object, String> name(Object arg) {
        return DslPointcut.name(this.handleImplicitBind(arg));
    }

    public DslPointcut<GroovyClassDescriptor, GdslMethod> enclosingMethod(Object arg) {
        return DslPointcut.enclosingMethod(this.handleImplicitBind(arg));
    }

    static {
        String major = ApplicationInfo.getInstance().getMajorVersion();
        String minor = ApplicationInfo.getInstance().getMinorVersion();
        ideaVersion = major + (String)(minor != null ? "." + minor : "");
    }

    private static class InvalidVersionException
    extends RuntimeException {
        private InvalidVersionException() {
        }
    }
}

