/*
 * Decompiled with CFR 0.152.
 */
package training.statistic;

import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.impl.CloseProjectWindowHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import training.lang.LangManager;
import training.statistic.LearnProjectState;
import training.statistic.LearnProjectStateListenerKt;
import training.statistic.StatisticBase;
import training.util.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Ltraining/statistic/LearnProjectStateListener;", "Lcom/intellij/openapi/project/ProjectManagerListener;", "<init>", "()V", "projectOpened", "", "project", "Lcom/intellij/openapi/project/Project;", "projectClosingBeforeSave", "projectClosed", "intellij.featuresTrainer"})
final class LearnProjectStateListener
implements ProjectManagerListener {
    public void projectOpened(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = LangManager.Companion.getInstance().getLanguageId();
        if (string == null) {
            return;
        }
        String languageId = string;
        if (UtilsKt.isLearningProject(project, languageId)) {
            CloseProjectWindowHelper.Companion.getSHOW_WELCOME_FRAME_FOR_PROJECT().set((UserDataHolder)project, (Object)true);
        } else {
            LearnProjectState learnProjectState = LearnProjectState.Companion.getInstance$intellij_featuresTrainer();
            StatisticBase.LearnProjectOpeningWay way = learnProjectState.getFirstTimeOpenedWay();
            if (way != null) {
                StatisticBase.INSTANCE.logNonLearningProjectOpened(way);
                learnProjectState.setFirstTimeOpenedWay(null);
            }
            LearnProjectStateListenerKt.access$considerNotifyAboutNewLessons(project);
        }
    }

    public void projectClosingBeforeSave(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = LangManager.Companion.getInstance().getLanguageId();
        if (string == null) {
            return;
        }
        String languageId = string;
        if (UtilsKt.isLearningProject(project, languageId)) {
            RecentProjectsManagerBase.Companion.getInstanceEx().setProjectHidden(project, true);
            if (!StatisticBase.INSTANCE.isLearnProjectCloseLogged()) {
                StatisticBase.INSTANCE.logLessonStopped(StatisticBase.LessonStopReason.CLOSE_PROJECT);
            }
        }
    }

    public void projectClosed(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = LangManager.Companion.getInstance().getLanguageId();
        if (string == null) {
            return;
        }
        String languageId = string;
        if (UtilsKt.isLearningProject(project, languageId)) {
            StatisticBase.INSTANCE.setLearnProjectCloseLogged(false);
        }
    }
}

